/*
 * Decompiled with CFR 0.152.
 */
package king;

import driftwood.gui.ReflectiveAction;
import driftwood.r3.Transform;
import driftwood.util.Props;
import driftwood.util.SoftLog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.lang.reflect.Constructor;
import java.util.List;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import king.KMessage;
import king.KingMain;
import king.KingPrefs;
import king.ToolBox;
import king.core.Aspect;
import king.core.Engine;
import king.core.Engine2D;
import king.core.KView;
import king.core.Kinemage;
import king.core.Transformable;
import king.painters.HighQualityPainter;
import king.painters.StandardPainter;

public class KinCanvas
extends JComponent
implements KMessage.Subscriber,
Transformable,
ChangeListener,
Printable {
    static final double LOG_2 = Math.log(2.0);
    static final int SLIDER_SCALE = 16;
    public static final int QUALITY_GOOD = 0;
    public static final int QUALITY_BETTER = 1;
    public static final int QUALITY_BEST = 2;
    public static final int QUALITY_JOGL = 10;
    KingMain kMain = null;
    Engine2D engine = null;
    ToolBox toolbox = null;
    StandardPainter goodPainter = new StandardPainter(false);
    StandardPainter betterPainter = new StandardPainter(true);
    HighQualityPainter bestPainter = new HighQualityPainter(true);
    Component joglCanvas = null;
    ReflectiveAction joglAction = null;
    DefaultBoundedRangeModel zoommodel = null;
    DefaultBoundedRangeModel clipmodel = null;
    Image logo = null;
    int renderQuality = 0;
    boolean writeFPS;
    String currViewKey;
    String currAspectKey;

    public KinCanvas(KingMain kingMain) {
        Object object;
        this.kMain = kingMain;
        this.currViewKey = this.getClass().getName() + "@" + System.identityHashCode(this) + ".current_view";
        this.currAspectKey = this.getClass().getName() + "@" + System.identityHashCode(this) + ".current_aspect";
        try {
            object = System.getProperty("os.name").toLowerCase();
            if (((String)object).indexOf("mac") != -1 || ((String)object).indexOf("apple") != -1) {
                this.renderQuality = 1;
            }
        }
        catch (SecurityException securityException) {
            SoftLog.err.println(securityException.getMessage());
        }
        object = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds();
        int n = 3 * Math.min(((Rectangle)object).width, ((Rectangle)object).height) / 4;
        KingPrefs kingPrefs = this.kMain.getPrefs();
        Dimension dimension = new Dimension(n, n);
        Dimension dimension2 = new Dimension(200, 200);
        if (kingPrefs.hasProperty("graphicsWidth") && kingPrefs.getInt("graphicsWidth") >= dimension2.width) {
            dimension.width = kingPrefs.getInt("graphicsWidth");
        }
        if (kingPrefs.hasProperty("graphicsHeight") && kingPrefs.getInt("graphicsHeight") >= dimension2.height) {
            dimension.height = kingPrefs.getInt("graphicsHeight");
        }
        this.writeFPS = kingPrefs.getBoolean("writeFPS", false);
        this.setPreferredSize(dimension);
        this.setMinimumSize(dimension2);
        this.setOpaque(true);
        this.zoommodel = new DefaultBoundedRangeModel(0, 0, -48, 112);
        this.zoommodel.addChangeListener(this);
        this.clipmodel = new DefaultBoundedRangeModel(200, 0, 0, 800);
        this.clipmodel.addChangeListener(this);
        this.engine = new Engine2D();
        this.updatePrefs(this.engine, kingPrefs);
        this.logo = Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("images/king-logo.gif"));
        this.toolbox = new ToolBox(this.kMain, this);
        this.toolbox.listenTo(this);
        if (this.kMain.getPrefs().getBoolean("joglByDefault")) {
            try {
                this.loadJOGL();
                this.renderQuality = 10;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.kMain.getFileDropHandler().handleDropsFor(this);
        this.kMain.subscribe(this);
    }

    void updatePrefs(Engine2D engine2D, Props props) {
        engine2D.setPickingRadius(props.getDouble("pickingRadius"));
        engine2D.useObjPicking = props.getBoolean("pickObjects");
        engine2D.stereoRotation = (float)Math.toRadians(props.getDouble("stereoAngle"));
        engine2D.bigFont = new Font("SansSerif", 0, props.getInt("fontSizeBig"));
        engine2D.smallFont = new Font("SansSerif", 0, props.getInt("fontSizeSmall"));
    }

    public void syncToKin(Engine engine, Kinemage kinemage) {
        engine.usePerspective = kinemage.atPerspective;
        engine.cueThickness = !kinemage.atOnewidth;
        engine.thinLines = kinemage.atThinline;
        engine.whiteBackground = kinemage.atWhitebackground;
        engine.colorByList = kinemage.atListcolordominant;
        Aspect aspect = this.getCurrentAspect();
        engine.activeAspect = aspect == null ? 0 : aspect.getIndex();
    }

    public void deliverMessage(KMessage kMessage) {
        Kinemage kinemage = this.kMain.getKinemage();
        if (this.engine != null) {
            if (kMessage.testProg(64L)) {
                this.updatePrefs(this.engine, this.kMain.getPrefs());
            }
            if (kMessage.testProg(24L)) {
                this.engine.flushZBuffer();
            }
            if (kinemage != null && kMessage.testProg(4L)) {
                this.syncToKin(this.engine, kinemage);
            }
        }
        this.repaint();
        KView kView = this.kMain.getView();
        if (kView != null && kMessage.testProg(260L)) {
            double d = kView.getSpan();
            double d2 = this.kMain.getKinemage().getSpan();
            this.zoommodel.setValue((int)Math.round(16.0 * Math.log(d2 / d) / LOG_2));
            this.clipmodel.setValue((int)((double)kView.getClip() * 200.0));
        }
    }

    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.paintCanvas(graphics2D, this.getSize(), this.renderQuality);
    }

    public void paintCanvas(Graphics2D graphics2D, Dimension dimension, int n) {
        Kinemage kinemage = this.kMain.getKinemage();
        if (kinemage == null) {
            graphics2D.setColor(Color.black);
            graphics2D.fillRect(0, 0, dimension.width, dimension.height);
            if (this.logo != null) {
                graphics2D.drawImage(this.logo, (dimension.width - this.logo.getWidth(this)) / 2, (dimension.height - this.logo.getHeight(this)) / 2, this);
            }
            if (this.kMain.getPrefs().newerVersionAvailable()) {
                this.announceNewVersion(graphics2D);
            }
        } else if (n >= 10 && this.joglAction != null) {
            this.joglAction.actionPerformed(null);
        } else {
            StandardPainter standardPainter = null;
            if (n == 1) {
                this.betterPainter.setGraphics(graphics2D);
                standardPainter = this.betterPainter;
            } else if (n == 2) {
                this.bestPainter.setGraphics(graphics2D);
                standardPainter = this.bestPainter;
            } else {
                this.goodPainter.setGraphics(graphics2D);
                standardPainter = this.goodPainter;
            }
            long l = System.currentTimeMillis();
            KView kView = this.getCurrentView();
            Rectangle rectangle = new Rectangle(dimension);
            this.syncToKin(this.engine, kinemage);
            this.engine.render(this, kView, rectangle, standardPainter);
            if (this.toolbox != null) {
                this.toolbox.overpaintCanvas(standardPainter);
            }
            l = System.currentTimeMillis() - l;
            if (this.writeFPS) {
                SoftLog.err.println(l + " ms (" + (l > 0L ? Long.toString(1000L / l) : ">1000") + " FPS) - " + this.engine.getNumberPainted() + " objects painted");
            }
        }
    }

    void announceNewVersion(Graphics2D graphics2D) {
        String string = "A new version of KiNG is now available";
        Dimension dimension = this.getSize();
        Font font = new Font("SansSerif", 1, 16);
        graphics2D.setFont(font);
        graphics2D.setColor(Color.white);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics2D);
        graphics2D.drawString(string, (dimension.width - (int)rectangle2D.getWidth()) / 2, (dimension.height - (int)rectangle2D.getHeight()) / 2 + 170);
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Dimension dimension = this.getCanvasSize();
        Kinemage kinemage = this.kMain.getKinemage();
        if (kinemage == null || n > 0) {
            return 1;
        }
        KView kView = this.getCurrentView();
        double d = Math.min(pageFormat.getImageableWidth() / (double)dimension.width, pageFormat.getImageableHeight() / (double)dimension.height);
        graphics2D.scale(d, d);
        graphics2D.setClip((int)(pageFormat.getImageableX() / d), (int)(pageFormat.getImageableY() / d), dimension.width, dimension.height);
        Rectangle rectangle = new Rectangle(dimension);
        rectangle.setLocation((int)(pageFormat.getImageableX() / d), (int)(pageFormat.getImageableY() / d));
        this.syncToKin(this.engine, kinemage);
        this.bestPainter.setGraphics(graphics2D);
        this.engine.render(this, kView, rectangle, this.bestPainter);
        if (this.toolbox != null) {
            this.toolbox.overpaintCanvas(this.bestPainter);
        }
        return 0;
    }

    public void doTransform(Engine engine, Transform transform) {
        Kinemage kinemage = this.kMain.getKinemage();
        if (kinemage == null) {
            return;
        }
        kinemage.doTransform(engine, transform);
        if (this.toolbox != null) {
            this.toolbox.doTransform(engine, transform);
        }
    }

    public BoundedRangeModel getZoomModel() {
        return this.zoommodel;
    }

    public BoundedRangeModel getClipModel() {
        return this.clipmodel;
    }

    public Component getPickcenterButton() {
        return this.toolbox.services.doPickcenter;
    }

    public Component getMarkersButton() {
        return this.toolbox.services.doMarkers;
    }

    public Dimension getCanvasSize() {
        return this.engine.getCanvasSize();
    }

    public Engine2D getEngine() {
        return this.engine;
    }

    public ToolBox getToolBox() {
        return this.toolbox;
    }

    public void setQuality(int n) {
        this.renderQuality = n;
        if (n == 10) {
            try {
                this.loadJOGL();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(SoftLog.err);
                this.joglCanvas = null;
                this.joglAction = null;
                JOptionPane.showMessageDialog(this.kMain.getTopWindow(), "Unable to initialize OpenGL graphics.\nSee user manual for details on enabling this feature.", "No OpenGL", 0);
            }
        } else if (n < 10) {
            this.kMain.getContentPane().setGraphicsComponent(this);
        }
    }

    public KView getCurrentView() {
        return this.getCurrentView(this.kMain.getKinemage());
    }

    public KView getCurrentView(Kinemage kinemage) {
        if (kinemage == null) {
            return null;
        }
        KView kView = (KView)kinemage.metadata.get(this.currViewKey);
        if (kView == null) {
            List<KView> list = kinemage.getViewList();
            if (list.size() < 1) {
                kinemage.addView(new KView(kinemage));
            }
            kView = list.get(0);
            this.setCurrentView(kinemage, kView);
        }
        return kView;
    }

    public void setCurrentView(KView kView) {
        this.setCurrentView(this.kMain.getKinemage(), kView);
    }

    public void setCurrentView(Kinemage kinemage, KView kView) {
        if (kinemage == null) {
            return;
        }
        kinemage.metadata.put(this.currViewKey, kView.clone());
        kView.activateViewingAxes();
        this.kMain.publish(new KMessage(this, 256L));
    }

    public Aspect getCurrentAspect() {
        Kinemage kinemage = this.kMain.getKinemage();
        if (kinemage == null) {
            return null;
        }
        return (Aspect)kinemage.metadata.get(this.currAspectKey);
    }

    public void setCurrentAspect(Aspect aspect) {
        Kinemage kinemage = this.kMain.getKinemage();
        if (kinemage == null) {
            return;
        }
        kinemage.metadata.put(this.currAspectKey, aspect);
        this.kMain.publish(new KMessage(this, 512L));
    }

    public void stateChanged(ChangeEvent changeEvent) {
        int n;
        KView kView = this.kMain.getView();
        if (kView == null) {
            return;
        }
        if (changeEvent.getSource() == this.zoommodel) {
            double d = kView.getSpan();
            double d2 = this.kMain.getKinemage().getSpan();
            int n2 = (int)Math.round(16.0 * Math.log(d2 / d) / LOG_2);
            if (n2 != this.zoommodel.getValue()) {
                double d3 = d2 / Math.pow(2.0, (double)this.zoommodel.getValue() / 16.0);
                kView.setSpan((float)d3);
            }
        } else if (changeEvent.getSource() == this.clipmodel && (n = (int)((double)kView.getClip() * 200.0)) != this.clipmodel.getValue()) {
            double d = (double)this.clipmodel.getValue() / 200.0;
            kView.setClip((float)d);
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public boolean isFocusable() {
        return true;
    }

    public void repaint() {
        super.repaint();
        if (this.renderQuality >= 10 && this.joglAction != null) {
            if (this.kMain.getContentPane().getGraphicsComponent() != this.joglCanvas) {
                this.kMain.getContentPane().setGraphicsComponent(this.joglCanvas);
            }
            this.joglAction.actionPerformed(null);
        }
    }

    private void loadJOGL() throws Throwable {
        Class<?> clazz = Class.forName("king.JoglCanvas");
        Constructor<?> constructor = clazz.getConstructor(KingMain.class, Engine2D.class, ToolBox.class);
        this.joglCanvas = (Component)constructor.newInstance(this.kMain, this.engine, this.toolbox);
        this.joglAction = new ReflectiveAction(null, null, this.joglCanvas, "requestRepaint");
    }
}

