/*
 * aboutdlg.cpp
 * Copyright (C) 2001-2003  Justin Karneges, Michail Pishchagin
 *
 * Copyright (C) 2007 by Matvey Kozhev <sikon@lucidfox.org>
 *                                                                         *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <QTextStream>
#include <QFile>

#include "qink.h"
#include "aboutdlg.h"

extern const char *appname;
extern const char *version;
extern const char *description;

AboutDlg::AboutDlg(QWidget* parent)
        : QDialog(parent)
{
    setupUi(this);
    setWindowTitle(tr("About %1").arg(appname));
    
    QIcon icon(ICONFILE("64x64"));
    icon.addFile(ICONFILE("32x32"));
    icon.addFile(ICONFILE("16x16"));
    setWindowIcon(icon);
    
    lb_name->setText(QString("<h3><b>%1 v%2</b></h3>").arg(appname).arg(version));
    lb_icon->setPixmap(QPixmap(RESDIR "/app.png"));
    lb_about->setText(tr(description));

    te_license->setText(loadText(":/COPYING"));

    QString lang_name = QApplication::translate("@default", "language_name");
    if (lang_name == "language_name")   // remove the translation tab, if no translation is used
        tw_tabs->removeTab(3);
    else
        te_translation->setText(tr("translated_by"));

    // fill in Authors tab...
    te_authors->setText(loadText(DOCDIR "/AUTHORS"));

    // fill in Thanks To tab...
    QString thanks;
    te_thanks->setText(loadText(DOCDIR "/THANKS"));
    
    pb_close->setIcon(getButtonIcon("window-close"));
}

QString AboutDlg::loadText(const QString& fileName)
{
    QString text;

    QFile f(fileName);
    if (f.open(QIODevice::ReadOnly))
    {
        QTextStream t(&f);
        while (!t.atEnd())
            text += t.readLine() + '\n';
        f.close();
    }

    return text;
}

QString AboutDlg::details(QString name, QString email, QString jabber, QString www, QString desc)
{
    QString ret;
    const QString nbsp = "&nbsp;&nbsp;";
    ret += name + "<br>\n";
    if (!email.isEmpty())
        ret += nbsp + "E-mail: " + "<a href=\"mailto:" + email + "\">" + email + "</a><br>\n";
    if (!jabber.isEmpty())
        ret += nbsp + "Jabber: " + "<a href=\"jabber:" + jabber + "\">" + jabber + "</a><br>\n";
    if (!www.isEmpty())
        ret += nbsp + "WWW: " + "<a href=\"" + www + "\">" + www + "</a><br>\n";
    if (!desc.isEmpty())
        ret += nbsp + desc + "<br>\n";
    ret += "<br>\n";

    return ret;
}
