#!/usr/bin/perl -w
use strict;

# qlandkarte.pl - quick perl script to set up a working directory
#                 of the QLandkarte source, for a new device.

# Very little error trapping.  The program takes a single option on the
# command line, which is the name you want to use to describe this
# new device.  The page at QLandkarte.sourceforge uses MyGarmin
# in their examples.

# This program uses svn to export the project into a directory here.
# The exported directory is qlandkarte.  A working directory copy is
# created by using the archive mode of the cp command by the name
# of qlandkarte.work.  This is so that a diff of the 2 directories
# can be made, to send changes to the project.

# In the work directory, it clones the src/device/template directory
# to produce a src/device/$MyDev directory.  The template.pro file
# is renamed, the <template> substitution is done in the files, and
# QLandkarte.pro file is the main directory is altered for this
# new device.

# At that point, you need to actually write some code in your
# $work/src/device/$MyDev directory.

# Copyright 2008, Gordon Haverland, Matter Realisations <perl@materialisations.com>
# This program is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.

#  See <http://www.perl.com/perl/misc/Artistic.html>

 

my $to   = 'qlandkarte';
my $work = $to . '.work';

unless( -d $to && -d $work ) {
    unless( -d $to ) {
	svn_installed();
	svn_export();
    }
    unless( -d $work ) {
	make_workdir();
    }
}
if( -d $work ) {
    chdir "$work/src/device";

    my $DevName;
    if( @ARGV ) {
	$DevName = shift;
	copy_template( $DevName );

    } elsif( -d $DevName ) {
	die "$DevName already exists\n";

    } else {
	die "You must provide a device name to use, such as MyGarmin\n";
    }


    chdir $DevName;
    rename_template_pro( $DevName );

    apply_template( $DevName );

    alter_QLandkarte_pro( $DevName );
}




print "All done.\n";



sub svn_installed {
    open( WHICH, "/usr/bin/which svn |" ) ||
	die "Can't spawn which to find svn binary: $!\n";
    my @which = <WHICH>;
    close( WHICH );

    unless( @which ) {
	print "The QLandkarte source is stored in a subversion repository.\n";
	print "You need the subversion package installed in order to download\n";
	print "it.  A qlandkarte directory will be created here to store the\n";
	print "source\n";
	exit 0;
    }
}

sub svn_export {
    my $from     = 'https://qlandkarte.svn.sourceforge.net/svnroot/qlandkarte/trunk';

    my @svn = (
	'/usr/bin/svn',
	'export',
	$from,
	$to
	);

    system( @svn );
}

sub make_workdir {
#    mkdir $work;
    my @cp = (
	'/bin/cp',
	'-a',
	$to,
	$work
	);
    system( @cp );
}

sub copy_template {
    my $DevName = shift;

    my @cp = (
	'/bin/cp',
	'-r',
	'template',
	$DevName
	);
    system( @cp );
}

sub rename_template_pro {
    my $DevName = shift;

    my @mv = (
	'/bin/mv',
	'template.pro',
	$DevName . '.pro'
	);
    system( @mv );
}

sub apply_template {
    my $DevName = shift;

    opendir( MyDev, '.' ) || 
	die "Can't read directory $DevName: $!\n";
    while( defined( my $file = readdir( MyDev ) ) ) {
	next if( $file eq '.' || $file eq '..' );

	open( FILE, "< $file" ) ||
	    die "Can't open $file in $DevName for read: $!\n";
	my $f;
	{
	    local $/;
	    $f = <FILE>;
	}
	close( FILE );
	$f =~ s/\<template\>/$DevName/g;
	open( FILE, "> $file" ) ||
	    die "Can't open $file in $DevName for overwrite: $!\n";
	print FILE $f;
	close( FILE );
    }
    closedir( MyDev );
}

sub alter_QLandkarte_pro {
    my $DevName = shift;

    chdir "../../..";
    my $file = 'QLandkarte.pro';
    open( FILE, "< $file" ) ||
	die "Can't open $file for read: $!\n";
    my @f = <FILE>;
    close( FILE );

    my $win32  = 0;
    my $subdrs = 0;
    for( my $i = 0; $i <= $#f; $i++ ) {
#    foreach my $f (@f) {
	$win32  = 1 if( $f[$i] =~ /!win32 {/ );
#	$win32  = 1 if( $f[$i] =~ /win32 {/ );
	$subdrs = 1 if( $win32 == 1 && $f[$i] =~ /^SUBDIRS \+= / );
	if( $subdrs == 1 && $f[$i] =~ /^}/ ) {
	    $f[$i] = "           sub_$DevName\n$f[$i]";
	    chomp( $f[$i-1] );
	    $f[$i-1] .= " \\\n";
	    $subdrs = 0;
	    $win32  = 0;
	}
    }
    push @f, "sub_$DevName" . ".subdir  = src/device/$DevName\n";
    push @f, "sub_$DevName" . ".depends = sub_device\n";

    open( FILE, "> $file" ) ||
	die "Can't open $file in $DevName for overwrite: $!\n";
    print FILE @f;
    close( FILE );
}    
