// infobar.C
//
// This program is free software. See the file COPYING for details.
// Author: Mattias Engdegrd, 1997-1999

// 13,245,200
#include <stdio.h>
#include <sys/types.h>
#include <time.h>

#include <qframe.h>
#include <qbrush.h>
#include <qdrawutil.h>
#include <qbitmap.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qcursor.h>

#include "global.h"
#include "infobar.h"
#include "proc.h"
#include "qps.h"
#include "misc.h"

float cpu_total=0;
float cpu_idle=0;
float cpu_used=0;

Infobar::Infobar(QWidget *parent) : QWidget(parent)
{
	int i = 0;
	

	is_vertical = Qps::vertical_cpu_bar;

	QFont f = font();

	QHBoxLayout *hl=new QHBoxLayout(this);
	hl->setMargin(1);
	

	load_graph = new LoadGraph2(this, 1280);
	load_graph->setFrameStyle(QFrame::Panel | QFrame::Sunken);

	hl->addWidget(load_graph);
	
	setMinimumHeight( is_vertical ? 97 : 49);
}

int rightOf(QWidget *w)
{
	return w->x() + w->width();
}

int below(QWidget *w)
{
	return w->y() + w->height();
}

void Infobar::resizeEvent(QResizeEvent *r)
{
	return;
}

// return true if the swap meter is redlined
bool Infobar::swaplim_exceeded()
{
	if(Qps::swaplim_percent) {
		if(Procinfo::swap_total > 0) {
			int free_p = 100 * Procinfo::swap_free / Procinfo::swap_total;
			return free_p < Qps::swaplimit;
		} else
			return FALSE;
	} else {
		return Procinfo::swap_free < Qps::swaplimit;
	}
}

char rotate_str[]="|/-\\|/-\\";
//char rotate_str[]="REFRESH.*^__-\\|-/|-\\|";
int rotate_idx=0;
char rotate_char='|';
// refresh status bar; if step_load is true, add a point to the load graph
void Infobar::refresh()
{
	QString s;
	
	if(rotate_str[++rotate_idx]==0)	rotate_idx=0;
	rotate_char=rotate_str[rotate_idx];

	
	if(Qps::show_load_graph) {
		//load_graph->repaint();
		load_graph->update();
	} 

#ifdef SOLARIS
	int usedram = Procinfo::mem_total - Procinfo::mem_free ;
#endif
#ifdef LINUX
	int usedram = Procinfo::mem_total - Procinfo::mem_free - Procinfo::mem_buffers - Procinfo::mem_cached
#endif
		;

	//cpu_total=0;
	unsigned  total=0,total_idle=0;
	for(unsigned cpu = 0; cpu < Procinfo::num_cpus; cpu++) {
		unsigned user=0, system=0, idle=0,nice=0, wait=0;

		if(Procinfo::num_cpus == Procinfo::old_num_cpus) {

#define TIMEDIFF(kind) (Procinfo::cpu_times(cpu, Procinfo::kind) - \
		Procinfo::old_cpu_times(cpu, Procinfo::kind))

			user = TIMEDIFF(CPUTIME_USER);
#ifdef LINUX
			nice = TIMEDIFF(CPUTIME_NICE);
#endif
			system = TIMEDIFF(CPUTIME_SYSTEM);
#ifdef SOLARIS
			wait = TIMEDIFF(CPUTIME_WAIT);
#endif
			idle = TIMEDIFF(CPUTIME_IDLE);


#undef TIMEDIFF
		} else {
			// number of cpus just changed
			// FIXME: this is not enough to support dynamic addition/removal
			// of cpus at runtime; the number of graphs should be dynamic
			// as well.
			user = Procinfo::cpu_times(cpu, Procinfo::CPUTIME_USER);
#ifdef LINUX
			nice = Procinfo::cpu_times(cpu, Procinfo::CPUTIME_NICE);
#endif
			system = Procinfo::cpu_times(cpu, Procinfo::CPUTIME_SYSTEM);
#ifdef SOLARIS
			wait = Procinfo::cpu_times(cpu, Procinfo::CPUTIME_WAIT);
#endif
			idle = Procinfo::cpu_times(cpu, Procinfo::CPUTIME_IDLE);
		}
	
		total+= user + nice + system + wait + idle;
		total_idle+=idle;
	}

	//cpu_idle=idle;
	//cpu_total = user+ nice + system + wait + idle ;
	//printf("cpu_total=%f,cpu_idle=%f,cpu_used=%f\n",cpu_total,cpu_idle,cpu_used);
	cpu_used= (float)(total-total_idle)/total;
	//printf("cpu_used=%f\n",cpu_used);
		
}

void Infobar::update_load()
{	
	load_graph->add_load_point();
}

// if p, then show a and hide b; otherwise do the opposite
void Infobar::show_and_hide(bool p, QWidget *a, QWidget *b)
{
	if(!p) {
		QWidget *c = a;
		a = b;
		b = c;
	}
	if(!a->isVisible()) {
		b->hide();
		a->show();
	}
}

// show/hide components, arrange in vertical/horizontal style
void Infobar::configure()
{
	if(is_vertical != Qps::vertical_cpu_bar) {
		is_vertical = Qps::vertical_cpu_bar;
	}
	//show_and_hide(Qps::show_cpu_bar, cpu_bar, cpu_lbl);
	refresh();
}


//DEL
void Infobar::toggle_load()
{
}
//DEL 
void Infobar::toggle_cpu()
{
}
//DEL
void Infobar::toggle_mem()
{
}
//DEL
void Infobar::toggle_swap()
{
}

/*
void CpuLabel::drawContents(QPainter *p)
{
	QString s;
	QRect cr = contentsRect();
	cr.moveBy(3, 2);
	cr.setWidth(cr.width() - 6); cr.setHeight(cr.height() - 4);
	if(vert) {
		p->drawText(cr.x(), cr.y(), cr.width(), cr.height(),
				AlignLeft | AlignTop,
#ifdef LINUX
				"user\nnice\nsys\nidle"
#endif
#ifdef SOLARIS
				"user\nsys\nwait\nidle"
#endif
				);
		for(int cpu = 0; cpu < ncpus; cpu++) {
			int i = 0;
			unsigned long user = values(cpu, i++);
#ifdef LINUX
			unsigned long nice = values(cpu, i++);
#endif
			unsigned long system = values(cpu, i++);
#ifdef SOLARIS
			unsigned long wait = values(cpu, i++);
#endif
			unsigned long idle = values(cpu, i);
			float tot = (user
#ifdef LINUX
					+ nice
#endif
					+ system
#ifdef SOLARIS
					+ wait
#endif
					+ idle) * 0.01;
			if(tot == 0)
				tot = 1;
			s.sprintf("%.1f%%\n%.1f%%\n%.1f%%\n%.1f%%\ncpu%d",
#ifdef LINUX
					user / tot, nice / tot, system / tot,
#endif
#ifdef SOLARIS
					user / tot, system / tot, wait / tot,
#endif
					idle / tot, cpu);
// At the origin, we had 36 instead of 49
			p->drawText(cr.x(), cr.y(),
					cr.width() - (ncpus - 1 - cpu) * 49, cr.height(),
					AlignRight | AlignTop, s);
		}
	} else {
		unsigned long user = 0;
		unsigned long nice = 0;
		unsigned long system = 0;
		unsigned long wait = 0;
		unsigned long idle = 0;

		for(int cpu = 0; cpu < ncpus; cpu++) {
			int i = 0;
			user += values(cpu, i++);
#ifdef LINUX
			nice += values(cpu, i++);
#endif
			system += values(cpu, i++);
#ifdef SOLARIS
			wait += values(cpu, i++);
#endif
			idle += values(cpu, i);
		}
		//printf("cpu_total=%f,cpu_idle=%f,cpu_used=%f\n",cpu_total,cpu_idle,cpu_used);
		float tot = (user+ nice	+ system + wait + idle ) / 100.0;
		// printf("tot=%f\n",tot);

#ifdef LINUX
		s.sprintf("cpu %.1f%% user, %.1f%% nice\n"
				"%.1f%% system, %.1f%% idle",
				user / tot, nice / tot, system / tot, idle / tot);
#endif
#ifdef SOLARIS
		s.sprintf("cpu %.1f%% user, %.1f%% system\n"
				"%.1f%% wait, %.1f%% idle",
				user / tot, system / tot, wait / tot, idle / tot);
#endif
		p->drawText(cr.x(), cr.y(), cr.width(), cr.height(),
				AlignLeft | AlignTop, s);
	}
}

void BarGraph::drawBar(QPainter *p, int x, int y, int w, int h, int bar)
{
	unsigned long *v = new unsigned long[ndivs];
	int downscale = 0;
	for(int i = 0; i < ndivs; i++) {
		if(bar == -1) {
			v[i] = 0;
			for(int j = 0; j < nbars; j++)
				v[i] += values(j, i) / nbars;
		} else
			v[i] = values(bar, i);
		if(v[i] > 1000000)
			downscale = 10;	// fix possible overflow
	}
	unsigned long sum = 0;
	for(int i = 0; i < ndivs; i++)
		sum += v[i] >>= downscale;
	int dist = 0;

	QColorGroup g = colorGroup();
	QBrush fill(colors[ndivs - 1]);
	qDrawShadePanel(p, x, y, w, h, g, TRUE, 1, &fill);
	w -= 2;
	h -= 2;
	x++;
	y++;

	if(sum > 0) {
		for(int i = 0; i < ndivs - 1; i++) {
			int size;
			if(vert) {
				size = h * v[i] / sum;
				// fill vertical bars from the bottom up
				p->fillRect(x, y + h - dist - size, w, size, colors[i]);
			} else {
				size = w * v[i] / sum;
				p->fillRect(x + dist, y, size, h, colors[i]);
			}
			dist += size;
		}
	} else {
		p->fillRect(x, y, w, h, colorGroup().background());
		p->drawText(x, y, w, h, AlignCenter, vert ? "n\no\nn\ne" : "(none)");
	}
	delete[] v;
}
*/

#define TOTAL_BAR 50
QColor total_color;
QColor part1_color;
QColor part2_color;
QColor part3_color;
// DRAFT CODE : DRAFT CODE : DRAFT CODE : DRAFT CODE :  DRAFT CODE !!
// return width
int drawSPECTRUM(QPainter *p,int x,int y,char *name,
		int total, int part1,int part2=0,int part3=0,int part4=0) 
{
	int total_width;
	//blue lay  0,180,255
	total_color.setRgb(0,85,90);
	part1_color.setRgb(0,255,210);
	part2_color.setRgb(0,220,175);
	part3_color.setRgb(0,180,150);
	int i,w, h;
	int tx,ty,bar_x_offset,bar_h;
	int bar;

	if (total==0) total=1;
	
	h=pf_char_height();	
	w=2+pf_write(p,x+2,y+2,name)+3;
	bar_x_offset= x + w ;

	bar_h=h-1;
	ty=y+2;
	tx=0;
	p->setPen(total_color);
	for(i=0; i < TOTAL_BAR; i++)	
	{	
		p->drawLine(bar_x_offset+tx,ty,bar_x_offset+tx,ty+bar_h);
		tx++;
		tx++;
	}
	total_width = w+ tx;

	// draw part1 
	p->setPen(part1_color);
	bar=part1*TOTAL_BAR/total;
	tx=0;
	if(bar==0 and part1!=0 ) bar=1;
	for(i=0; i < bar ; i++ )
	{	
		p->drawLine(bar_x_offset+tx,ty,bar_x_offset+tx,ty+bar_h);
		tx+=2;
		//tx++;
	}

	if( part2 >= 0 )
	{
		p->setPen(part2_color);
		bar=part2*TOTAL_BAR/total;
		if(bar==0 and part2!=0 ) bar=1;
		for(i=0; i < bar ; i++ )
		{	
			p->drawLine(bar_x_offset+tx,ty,bar_x_offset+tx,ty+bar_h);
			tx+=2;
			//tx++;
		}
	}
	if( part3 >= 0 )
	{
		p->setPen(part3_color);
		bar=part3*(TOTAL_BAR)/total;
		for(i=0; i < bar ; i++ )
		{	
			p->drawLine(bar_x_offset+tx,ty,bar_x_offset+tx,ty+bar_h);
			tx+=2;
		}
	}

	if(tx>TOTAL_BAR*2) printf(" total =%d , part1=%d , part2=%d\n",total,part1,part2);
	return total_width;
}

// DRAFT CODE : DRAFT CODE : DRAFT CODE : DRAFT CODE :  DRAFT CODE !!
int drawUTIME(QPainter *p,int x,int y,long boot_time)
{
	char buff[1024]; 
	//printf("size of long=%d, size of time_t=%d \n",sizeof(long),sizeof(time_t));
	long u = (long)time(NULL) - (long)boot_time;
	int up_days = u / (3600 * 24);
	u %= (3600 * 24);
	int up_hrs = u / 3600;
	u %= 3600;
	int up_mins = u / 60;
	if(up_days == 0) {
		if(up_hrs == 0)
			sprintf(buff,"UPTIME %d min", up_mins);
		else
			sprintf(buff,"UPTIME %d:%02d", up_hrs, up_mins);
	} else
		sprintf(buff,"UPTIME %d DAY%s, %d:%02d", up_days, (up_days == 1) ? "" : "s", up_hrs, up_mins);
	return pf_write(p,x,y,buff );
}

// ============================ 
gwidget *x_cpu;
gwidget *x_mem;
gwidget *x_swap;
gwidget *x_utime;
gwidget *x_load_avg;

char 	str_buff[512];
class w_cpu: public gwidget
{
	private:
		int cpu_n;
		unsigned long total, user, system, idle,nice, wait;

	public:
	virtual void draw(QPainter *p)
	{
		x=0;
		char buff[32];
		int cpu_id;
		int cpu_n;
		height=pf_char_height()+4;

		user=0, system=0, idle=0,nice=0, wait=0;
		
		if(Procinfo::num_cpus>=4) // temporaly... 
            cpu_n=4;
		else 
            cpu_n=Procinfo::num_cpus;
        
		for(cpu_id = 0; cpu_id < cpu_n; cpu_id++) {
			if(Procinfo::num_cpus == Procinfo::old_num_cpus) {
#define TIMEDIFF(kind) (Procinfo::cpu_times(cpu_id, Procinfo::kind) - Procinfo::old_cpu_times(cpu_id, Procinfo::kind))
				user = TIMEDIFF(CPUTIME_USER);
#ifdef LINUX
				nice = TIMEDIFF(CPUTIME_NICE);
#endif
				system = TIMEDIFF(CPUTIME_SYSTEM);
#ifdef SOLARIS
				wait = TIMEDIFF(CPUTIME_WAIT);
#endif
				idle = TIMEDIFF(CPUTIME_IDLE);
#undef TIMEDIFF
			} else {
				// number of cpus just changed
				// FIXME: this is not enough to support dynamic addition/removal
				// of cpus at runtime; the number of graphs should be dynamic
				// as well.
				user = Procinfo::cpu_times(cpu_id, Procinfo::CPUTIME_USER);
#ifdef LINUX
				nice = Procinfo::cpu_times(cpu_id, Procinfo::CPUTIME_NICE);
#endif
				system = Procinfo::cpu_times(cpu_id, Procinfo::CPUTIME_SYSTEM);
#ifdef SOLARIS
				wait = Procinfo::cpu_times(cpu_id, Procinfo::CPUTIME_WAIT);
#endif
				idle = Procinfo::cpu_times(cpu_id, Procinfo::CPUTIME_IDLE);
			}

			total=user+system+wait+nice+idle;
			
			sprintf(buff,"CPU%d",cpu_id);

//			if(idle<0)
//			printf("xx idle=%d , old =%d \n",Procinfo::cpu_times(cpu_id, Procinfo::CPUTIME_IDLE),Procinfo::old_cpu_times(cpu_id, Procinfo::CPUTIME_IDLE));
			//if(total == 1 or total ==0)	printf(":total=%ld user=%ld system=%d wait=%d ,nice=%d idle=%ld\n",total,user,system,wait,nice,idle);
#ifdef LINUX
		width=drawSPECTRUM(p,0,cpu_id*10,buff,total,user,system,nice);
#endif			
#ifdef SOLARIS
		width=drawSPECTRUM(p,0,cpu_id*10,buff,total,user,system,wait);
#endif

		}
	}

	virtual char *info()
	{
		char str[80];
		float f_user,f_nice,f_system,f_wait;
	
		f_user=(float)user/total *100;
		f_nice=(float)nice/total *100;
		f_wait=(float)wait/total *100;
		f_system=(float)system/total *100;
#ifdef LINUX
		sprintf(str_buff,"user: %1.1f%%  system:%1.1f%%  nice:%1.1f%% "
			,f_user,f_system,f_nice);
#endif

		return str_buff;
	};

};


class w_mem: public gwidget
{
	private :
		int used;
	public:
	virtual void draw(QPainter *p)
	{
		height=pf_char_height()+4;
		x=x_cpu->xpluswidth()+10;
#ifdef LINUX
		used = Procinfo::mem_total -  Procinfo::mem_free - Procinfo::mem_buffers -Procinfo::mem_cached;
		width=drawSPECTRUM(p,x,0,"MEM",Procinfo::mem_total,used, Procinfo::mem_cached,Procinfo::mem_buffers);
#endif

#ifdef SOLARIS
		used = Procinfo::mem_total -  Procinfo::mem_free;
		width=drawSPECTRUM(p,x,0,"MEM",Procinfo::mem_total,used);
#endif

	}
	virtual char *info()
	{
		char str[80];

		strcpy(str_buff,"Total: ");
		mem_string(Procinfo::mem_total,str);
		strcat(str_buff,str);
	
		strcat(str_buff,"  used: ");
		mem_string(used,str);
		strcat(str_buff,str);

#ifdef LINUX
		strcat(str_buff,"  cached: ");
		mem_string(Procinfo::mem_cached,str);
		strcat(str_buff,str);
		strcat(str_buff,"  buffer: ");
		mem_string(Procinfo::mem_buffers,str);
		strcat(str_buff,str);
#endif

	
	//	sprintf(str_buff,"Total: %dKb , cache: %dKb , buffer: %dKb",
	//		Procinfo::mem_total,Procinfo::mem_cached,Procinfo::mem_buffers);
		return str_buff;
	};

};

class w_swap: public gwidget
{
	private:
		int used;
	public:
	virtual void draw(QPainter *p)
	{	
		x=x_mem->xpluswidth()+10;
		used=Procinfo::swap_total-Procinfo::swap_free;
		width=drawSPECTRUM(p,x,0,"SWAP",Procinfo::swap_total,used);
		height=pf_char_height()+4;
	}
	virtual char *info()
	{	
		char str[80];
		
		strcpy(str_buff,"Total: ");
		mem_string(Procinfo::swap_total,str);
		strcat(str_buff,str);
		strcat(str_buff,"  Free: ");
		mem_string(Procinfo::swap_free,str);
		strcat(str_buff,str);
		strcat(str_buff,"  Used: ");
		mem_string(used,str);
		strcat(str_buff,str);

		//sprintf(str_buff,"Total: %d Kbyte , used %d Kbyte",
		//		Procinfo::swap_total,Procinfo::swap_free);
		return str_buff;
	};

};

class w_utime: public gwidget
{
	public:
	virtual void draw(QPainter *p)
	{
		height=pf_char_height()+4;
		x=x_swap->xpluswidth()+10;
		width=drawUTIME(p,x,2,Procinfo::boot_time);
	}
	virtual char *info()
	{
		return "passed time after system booting";
	};
};

class w_load_avg : public gwidget
{
	virtual void draw(QPainter *p)
	{
		char buff[64];
		//	printf("w_load_avg\n");
		sprintf(buff,"1m:%1.02f%% 5m:%1.02f%% 15m:%1.02f%%",
				Procinfo::loadavg[0],Procinfo::loadavg[1], Procinfo::loadavg[2]);

		width=pf_str_width(buff);

		x=parent->width()-width-6;
		
		int w=x_utime->xpluswidth()+15;
		if (x<w)
			x=w;
		
		pf_write(p,x,2,buff);

		x=parent->width()-8;
		y=parent->height()-9;

		char str[2]={0,0};
		str[0]=rotate_char;
		pf_write(p,x,y,str);
	}
	virtual char *info()
	{
		return "Average CPU%% each 1, 5 ,15minutes";
	};

};


LoadGraph2::LoadGraph2(QWidget *parent, int history_size) 
: QFrame(parent),
//: QWidget(parent),
	npoints(0),peak(0),h_index(0), dirty(TRUE)
{
	//setCursor ( QCursor(Qt::CrossCursor) ) ;
	//setCursor ( Qt::CrossCursor );

	p=new QPainter(this);
	hist_size=history_size;
	history=new float[history_size];
    setBackgroundMode(Qt::NoBackground); //flicker free

	x_cpu=new w_cpu();
	x_cpu->setParent(this);
	x_mem=new w_mem();
	x_mem->setParent(this);
	x_swap=new w_swap();
	x_swap->setParent(this);
	x_utime=new w_utime();
	x_utime->setParent(this);
	x_load_avg=new w_load_avg();	
	x_load_avg->setParent(this);
	
	wlist.add(x_cpu);
	wlist.add(x_mem);
	wlist.add(x_swap);
	wlist.add(x_utime);
	wlist.add(x_load_avg);
	
	QWidget::setMouseTracking(true);
}

LoadGraph2::~LoadGraph2()
{
	delete[] history;
}

// add value to the history, updating peak.
void LoadGraph2::add_history_point2(float value)
{
	static float v[3]={0,0,0};
	static float last_val=0;
	
	float f;
	f=last_val-value;
	//if (f > 0)
	//	value+=f/1.15;  // slow up ,slow down
	//else 
		value+=f/1.5;  // slow up ,slow down
	history[h_index++] = value;
	if(h_index >= hist_size)
		h_index = 0;
	if(npoints < hist_size)
		npoints++;
	if(value > peak)
		peak = value;
	else {
		peak = 0;		// no negative values
		for(int i = 0; i < npoints; i++)
			if(history[i] > peak)
				peak = history[i];
	}
	// printf("hist_size=%d h_index=%d  val=%f\n",hist_size,h_index,value);
			
	
	last_val=value;
}



// Add current load (the 1 min average) as a data point
void LoadGraph2::add_load_point()
{
	add_history_point((unsigned)(Procinfo::loadavg[0] * history_scale));
	//add_history_point2(cpu_used);
	dirty = TRUE;
}

// draw the load graph on the internal pixmap, if needed
void LoadGraph2::make_graph2(int w, int h)
{
	if(w != pm.width() || h != pm.height()) {
		pm.resize(w, h);
		pm.setMask(QBitmap());	// remove the mask ???
	} else 
		if(!dirty)
			return;

	pm.fill(Qps::color_set[Qps::COLOR_LOAD_BG]);
	int npts = QMIN(npoints, w);
	
	int ofs = h_index - npts;
	if(ofs < 0)
		ofs += hist_size; //??

	QPointArray pa(npts);
	// make the scale slightly over the peak since a constant load is quite
	// common and makes it hard to see the graph otherwise
	for(int i = 0; i < npts; i++) {
		int j = ofs + i;
		if(j >= hist_size) j -= hist_size;
		pa[i] = QPoint(i, h - 1 - (int)(history[j] * h*0.9));
		
	}	
	
	QPainter p(&pm);
	p.setPen(Qps::color_set[Qps::COLOR_LOAD_FG]);
	p.drawPolyline(pa);
	dirty = FALSE;
}

// return updated pixmap for use as an icon
QPixmap *LoadGraph2::make_icon(int w, int h)
{
	make_graph(w, h);
	return &pm;
}

void LoadGraph2::mousePressEvent(QMouseEvent *)
{
	emit clicked();
}

// only works if mouse cursor in this area 
void LoadGraph2::mouseMoveEvent(QMouseEvent *e)
{
	int x=0,y=0;
	int px,py;
	int half_height;
	int dy,a_y;
	int gap;


	px=e->pos().x() ;//+ pos().x();
	py=e->pos().y() ;//+ pos().y();

	
	half_height=height()/2;
	
	dy=py-half_height;
	dy/=2;

	x=8+pos().x();
	y=12+pos().y()-dy;

	//
	//gap=infobox->width() + px  - width();
	//if(gap > 0)	x-= gap;

	gap= py - infobox->height() ;
	if(gap < 0)
		y-= gap;

	//
	int i;
	int setinfo=0;
	for(i=0;i<wlist.size();i++)
		if(wlist[i]->intersect(px,py)) 
		{
			setinfo=1;
			infobox->setText(wlist[i]->info());
		}

	if (setinfo==0)
		infobox->setText("UNDER DEVELOPMENT");

	infobox->show();
	infobox->move(px+x,py+y);

}

void LoadGraph2::leaveEvent ( QEvent * ) 
{
	infobox->hide();
}

// old style : relative method  
// add value to the history, updating peak.
void LoadGraph2::add_history_point(unsigned value)
{	
	static unsigned last_val=0;
	
	if(value==last_val) return;
	
	history[h_index++] = value;
	if(h_index >= hist_size)
		h_index = 0;
	if(npoints < hist_size)
		npoints++;
	if(value > peak)
		peak = value;
	else {
		peak = 0;		// no negative values
		for(int i = 0; i < npoints; i++)
			if(history[i] > peak)
				peak = history[i];
	}
	last_val=value;
}


// USING NOW
// draw the load graph on the internal pixmap, if needed
void LoadGraph2::make_graph(int w, int h)
{
	if(w != pm.width() || h != pm.height()) {
		pm.resize(w, h);
		pm.setMask(QBitmap());	// remove the mask
	} 
	else 
		if(!dirty)
			return;

	pm.fill(Qps::color_set[Qps::COLOR_LOAD_BG]);
	int npts = QMIN(npoints, w);
	int ofs = h_index - npts;
	if(ofs < 0)
		ofs += hist_size;

	QPointArray pa(npts);	
	// make the scale slightly over the peak since a constant load is quite
	// common and makes it hard to see the graph otherwise
	unsigned int scale =(unsigned int) QMAX(peak + history_scale * 1 / 8 ,history_scale * 9 / 8);
	float mul = (float)h / scale;
	for(int i = 0; i < npts; i++) {
		int j = ofs + i;
		if(j >= hist_size) j -= hist_size;
		pa[i] = QPoint(i, h - 1 - (int)(history[j] * mul));
	}
	QPainter p(&pm);

	// draw scale lines
	p.setPen(QColor(0,70,54));
///	for(unsigned y = history_scale; y < scale; y += history_scale)
///		p.drawLine(0, h - 1 - (int)(mul * y),w - 1, h - 1 - (int)(mul * y));
	
	p.setPen(QColor(0,195,80));
	p.drawPolyline(pa);
	dirty = FALSE;
}



// DRAFT CODE  !!!
void LoadGraph2::drawContents(QPainter *p)
//void LoadGraph2::paintEvent ( QPaintEvent *e )
{
//	QPainter *p=new QPainter(this);
	char buff[128];
	int w;
	int width;
	int x,y;
	int i;
	//QRect cr = contentsRect();
	QRect cr = p->window();
	//QRect cr = p->viewport();
	make_graph(cr.width(), cr.height());

	QPainter px(&pm);
	for(i=0;i<wlist.size();i++)
		wlist[i]->draw(&px);

	p->drawPixmap(cr.x(), cr.y(), pm);
//	delete p;
}


