/***************************************************************************
                          qimageconfig.h  -  description
                             -------------------
    begin                : Tue Jul 4 2000
    copyright            : (C) 2000 by Michael Goffioul
    email                : gofioul@imec.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef QIMAGECONFIG_H
#define QIMAGECONFIG_H

#include "qconfigpage.h"
#include "qimageconfigbase.h"

class QButtonGroup;

/**
  *@author Michael Goffioul
  */

class QImageConfig : public QImageConfigBase, public QConfigPage
{
   Q_OBJECT

//friend class QCupsPrinterConfigDialog;

public:
	QImageConfig(QWidget *parent=0, const char *name=0);
	~QImageConfig();

  void initOptions(int num_options, cups_option_t *options, global_ppd_file_t *ppd, ipp_t *req = 0);
  void getCupsOptions(int& num_options, cups_option_t **options, bool include_default = false, ipp_t *req = 0);

protected:
	void initDialog();

protected slots:
  void horizChanged(int ID);
  void vertChanged(int ID);
	void ppiChanged(int value);
	void scalingChanged(int value);
  void defaultClicked();
	void ppiCheckClicked();
	void scalingCheckClicked();
  void colorSettingsChanged(int);

private: // Private attributes
  int vertpos_;
  int horizpos_;
	QButtonGroup	*horizgrp_, *vertgrp_;
};

#endif
