/****************************************************************************
**
** Created: Thu Dec 06 2001
**      by:  haili (linux@263.net)
**
** NOTE: This file may be used, distributed and modified without limitation.
**
****************************************************************************/
#include "copyarticle.h"
#include "sysconfig.h"

#include <stdio.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qmessagebox.h>
#include <qfile.h>
#include <qfiledialog.h>
#include <qcstring.h>
#include <qstring.h>
#include <qlayout.h>

/* 
 *  Constructs a CopyArticle which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
CopyArticle::CopyArticle( QWidget* parent,  const char* name, bool modal, WFlags fl )
    : QDialog( parent, name, modal, fl )
{
    if ( !name )
	setName( "CopyArticle" );
    resize( 600, 480 ); 
    setCaption( tr( "Copy Article" ) );
     
	copyArticleLayout = new QGridLayout( this );
	copyArticleLayout->setSpacing( 6 );
	copyArticleLayout->setMargin( 11 );	
	QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
	copyArticleLayout->addItem( spacer, 2, 0 );
	QSpacerItem* spacer_2 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
	copyArticleLayout->addItem( spacer_2, 2, 4 );
			  
    TextLabel1 = new QLabel( this, "TextLabel1" );
    TextLabel1->setText( tr( "Article Content:" ) );
	copyArticleLayout->addMultiCellWidget( TextLabel1,0,0,0,3 );
	QSpacerItem* spacer_3 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
	copyArticleLayout->addItem( spacer_3, 2, 2 );
	 
    articleMle = new QMultiLineEdit( this, "articleMle");
    articleMle->setGeometry( QRect( 20, 40, 449, 299) );
	copyArticleLayout->addMultiCellWidget( articleMle, 1, 1, 0, 4 );
	
    cancelButton = new QPushButton( this, "cancelButton" );
    cancelButton->setText( tr( "&Cancel" ) );
    connect(cancelButton,SIGNAL(clicked()),this,SLOT(onCancel()));
 	copyArticleLayout->addWidget( cancelButton, 2, 3 );
	
    okButton = new QPushButton( this, "okButton" );
    okButton->setText( tr( "&Save as..." ) );
//    okButton->setDefault(TRUE);
    connect(okButton,SIGNAL(clicked()),this,SLOT(onOk()));
	copyArticleLayout->addWidget( okButton, 2, 1 );
}

/*
 *  Destroys the object and frees any allocated resources
 */
CopyArticle::~CopyArticle()
{
    // no need to delete child widgets, Qt does it all for us
}

void CopyArticle::onOk()
{
	if ( save() )
		done(1);
}

void CopyArticle::onCancel()
{
	done(0);
}

bool CopyArticle::save()
{
	QFileDialog fdlg;
	QString filename  = fdlg.getSaveFileName();

	if ( filename != NULL ){
		QFile f(filename);
		if ( (f.open(IO_WriteOnly)) ) {
			QCString articleLocal = (articleMle->text()).local8Bit();
			f.writeBlock(articleLocal, articleLocal.length());
			f.close();
			return true;
		}
		else {
			QMessageBox mb( "Access file error:",
					filename,
					QMessageBox::Warning,
					0, 0, 
					0, this, 0, true);
			mb.exec();
		}
	}
	return false;
}
