/*******************************************************************************
FILENAME:      qtermscreen.cpp
REVISION:      2001.8.12 first created.
         
AUTHOR:        kingson fiasco
*******************************************************************************/
/*******************************************************************************
                                    NOTE
 This file may be used, distributed and modified without limitation.
 *******************************************************************************/
#include "global.h"
#include "qtermscreen.h"
#include "qterm.h"
#include "qtermtextline.h"
#include "qtermwndmgr.h"
#include "sysconfig.h"
#include "qtermwindow.h"

#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <qpainter.h>
#include <qpoint.h>
#include <qtimer.h>
#include <qmessagebox.h>
#include <qpixmap.h>
#include <qbitmap.h>
#include <qcheckbox.h>
#include <qcursor.h>
#include <qapplication.h>
#include <qevent.h>

/**************************************************************************/


QTermScreen::QTermScreen( QWidget *parent, const char *name, WFlags f ,QString fgColor,QString bgColor,QString font)
	: QWidget( parent, name, f )
{	
///add by kingson 10-25-01
	setFocusPolicy(ClickFocus);
///	
	int r, g, b;
	sscanf( fgColor, "%d %d %d", &r, &g, &b );
	defaultFG = QColor( r, g, b );
	
	sscanf( bgColor, "%d %d %d", &r, &g, &b );
	defaultBG = QColor( r, g, b );
	
//	rawFontName=font;
	fontFamily=font;

	parentWin= (QTermWindow *)parent;
	
	initSettings();
	initColors();
	initFont();
	
	resize( nCharWidth * LINECHARNUM + 2 * nBorder, nCharHeight * LINENUM + 2 * nBorder );
        setMicroFocusHint(650,350,0,0,TRUE);

	pm = new QPixmap( nCharWidth * LINECHARNUM, nCharHeight * LINENUM );
	pm->fill( Qt::black );
	backPm = NULL;

	setBackground( strPixmap );

	initPainter();	

	m_attr = defaultAttr;
	setAttr( m_attr );	

	blinkTimerID = startTimer( nBlinkTime );

	bBlink = false;
	
	bMouseSupp = TRUE;
	
	bCursorVisible = true;

	setMouseTracking( true );

       	bSelecting = false;
	bSelected  = false;	

	popMenu = new QPopupMenu(this);
        popMenu->insertItem( "Copy", parentWin, SLOT(copy()) );
        popMenu->insertItem( "Paste", parentWin, SLOT(paste()) );
        popMenu->insertSeparator();
        popMenu->insertItem( "Copy Article", parentWin, SLOT(copyArticle()) );
		    
}

QTermScreen::~QTermScreen()
{
	painter->end();
	
	delete pm;
	delete backPm;

	delete fm;
	delete m_font;

	delete []m_color;
	
	delete painter;

	killTimer( blinkTimerID );


}	

void QTermScreen::initFont()
{
	// we have not solved chinese font problem

#ifdef _OS_LINUX_
	QString fontname = "fixed";
	m_font = new QFont( fontname );
	
#else 
	m_font = new QFont ( font() );
	m_font->setPointSize( nFontSize<=0 ? 8 : nFontSize );
#endif

	if(!fontFamily.isNull())
       {
	       m_font->setFamily(fontFamily);
       }
	fm = new QFontMetrics( *m_font );
	nCharWidth = fm->width( 'x');
	nCharHeight = fm->height();
	nCharAscent = fm->ascent();
	nCharDescent = fm->descent();
}

void QTermScreen::initColors()
{
	m_color = new QColor[17];

	m_color[0]  = defaultBG; 
	m_color[1]  = QColor( Qt::darkRed );
	m_color[2]  = QColor( Qt::darkGreen );
	m_color[3]  = QColor( Qt::darkYellow );
	m_color[4]  = QColor( Qt::darkBlue );
	m_color[5]  = QColor( Qt::darkMagenta );
	m_color[6]  = QColor( Qt::darkCyan );
	m_color[7]  = defaultFG; 

	m_color[8]  = QColor( Qt::gray );
	m_color[9]  = QColor( Qt::red );
	m_color[10] = QColor( Qt::green );
	m_color[11] = QColor( Qt::yellow );
	m_color[12] = QColor( Qt::blue );
	m_color[13] = QColor( Qt::magenta );
	m_color[14] = QColor( Qt::cyan );
	m_color[15] = QColor( Qt::white );

//m_color[16] = QColor( Qt::gray );

}

void QTermScreen::initPainter()
{
	// start painting into pm
	painter = new QPainter();
	painter->begin( pm );
	painter->setBackgroundMode( Qt::OpaqueMode );
	painter->setFont( *m_font );
}

void QTermScreen::initSettings()
{


	bBGPixmap = true;

	strPixmap = "";

	nBlinkTime = 400;

	defaultAttr = COLORPAIR( /*0x4b*/NO_COLOR ) | EXTRAATTR( NO_ATTR );

	caretX = 0;
	caretY = 0;
	nBorder = 0;

}

void QTermScreen::setTextLineList( QList<QTermTextLine> *list )
{
	lineList = list;
}

void QTermScreen::setBackground( const QString& strPixmap )
{
	QPixmap bgPm = QPixmap( strPixmap );
	if ( bgPm.isNull() || !bBGPixmap )	// if no background pixmap, use default background color
	{
		setBackgroundColor( m_color[ GET_BG( GET_COLORPAIR( defaultAttr ) ) ] );	
		bBGPixmap = false;
	}
	else
	{
		setBackgroundPixmap( bgPm );	
		bBGPixmap = true;
	}
	
// Note: M$ windows and X have defferent behaviors.
// the following code can work well under X.

#ifdef _OS_WIN32_
	if ( bBGPixmap )
	{
		int i, j;
		int w, h;
		for ( i = 0; i <= pm->height() / bgPm.height(); i++ )
			for ( j = 0; j <= pm->width() / bgPm.width(); j++ )
			{
				if ( bgPm.height()*i > pm->height() )
					h = pm->height() % bgPm.height();
				else
					h = bgPm.height();
				if ( bgPm.width()*j > pm->width() )
					w = pm->width() % bgPm.width();
				else
					w = bgPm.width();
				
				bitBlt( pm, j*bgPm.width() /*- nLeftBorder*/, i*bgPm.height()/* - nTopBorder*/, &bgPm, 0, 0, w, h );
			}
	}
	else
		pm->fill( m_color[ GET_BG( GET_COLORPAIR( defaultAttr ) ) ] );
#else
	pm->fill( this, nBorder, nBorder );
#endif
	
	if ( backPm != NULL )
		delete backPm;

	if ( bBGPixmap )
		backPm = new QPixmap( *pm );
}

void QTermScreen::paintEvent( QPaintEvent * )
{
	// display pm to screen
	bitBlt( this, nBorder, nBorder, pm );
	setMicroFocusHint((caretX+2)*nCharWidth,(caretY+1)*nCharHeight,0,0,TRUE);
}

void QTermScreen::timerEvent( QTimerEvent * ) 
{
        bBlink = !bBlink;
	blinkWin();	// blink letters and caret
}

void QTermScreen::enterEvent( QEvent * )
{
	// save last mouse position
	emit mouseAction( 0 );
}

void QTermScreen::leaveEvent( QEvent * )
{
	emit mouseAction( 4 );
}

void QTermScreen::mouseMoveEvent( QMouseEvent *e )
{
	// get mouse index position
	mouseX = ( e->x() - nBorder ) / nCharWidth;
	mouseY = ( e->y() - nBorder ) / nCharHeight;

     	if(mouseX>=80)	mouseX=79;
     	if(mouseX<0)	mouseX=0;
	if(mouseY>=24)	mouseY=23;
	if(mouseY<0)	mouseY=0;


	if(bMouseSupp&&bSelecting)
	{
		redrawSelectArea( beginX,beginY,endX,  endY );
		drawSelectArea  ( beginX,beginY,mouseX,mouseY);
		refreshWin();
		endX =  mouseX;
		endY =  mouseY;
	}

        if(bMouseSupp)
        {
		emit mouseAction( 1 );
	}
}


void QTermScreen::mousePressEvent( QMouseEvent * e)
{
	// if focus out of screen, refocus by click mouse
	setFocus();
        ((QTerm* )( qApp->mainWidget()))->wndmgr->activateTheTab( (QTermWindow *) parentWidget()    );

	if(bMouseSupp&&e->button()==Qt::RightButton)
	{
		popMenu->popup(QCursor::pos());

	}
	
        if(bMouseSupp&&e->button()==Qt::LeftButton)
        {

		if(bSelected == true)
		{
		 	redrawSelectArea(beginX,MIN(beginY,endY),endX,MAX(beginY,endY));
		    	bSelected=false;
		}

	beginX = ( e->x() - nBorder ) / nCharWidth;
	endX=beginX;
	beginY = ( e->y() - nBorder ) / nCharHeight;
	endY=beginY;

     	if(endX>=80)	beginX=endX=79;
     	if(endX<0)	beginX=endX=0;
	if(endY>=24)	beginY=endY=23;
	if(endY<0)	beginY=endY=0;

	bSelecting=true;
	bSelected=false;
	///
	emit mouseAction( 2 );
	}

}

void QTermScreen::mouseReleaseEvent( QMouseEvent * e)
{
	if(bMouseSupp&&e->button()==Qt::LeftButton)
	{
		endX= ( e->x() - nBorder ) / nCharWidth;
		endY= ( e->y() - nBorder ) / nCharHeight;

     	if(endX>=80)	endX=79;
     	if(endX<0)	endX=0;
	if(endY>=24)	endY=23;
	if(endY<0)	endY=0;

		if((endX!=beginX)||(endY!=beginY))
			{
				setSelectText();
				bSelected=true;
			}
		bSelecting = false;

		emit mouseAction( 3 );
	}
}

void QTermScreen::repaint()
{
	// override this virtual function 
	bitBlt( this, nBorder, nBorder, pm );
}

// set attr to painter
void QTermScreen::setAttr( short attr )
{
	char cp = GET_COLORPAIR( attr );
	char ea = GET_EXTRAATTR( attr );
	
	// some attributes i have not operated
	
	// test bold mask	or always highlighted
	if ( GET_BOLD( ea ) || bAllHighLighted )
		cp = HIGHLIGHT( cp );		// use 8-15 color
	// test dim mask
	if ( GET_DIM( ea ) )
	{
	};
	// test underline mask
	if ( GET_UNDERLINE( ea ) )
	{
		m_font->setUnderline( true );
		painter->setFont( *m_font );
	}
	else
	{
		m_font->setUnderline( false );
		painter->setFont( *m_font );
	}
	// test blink mask
	if ( GET_BLINK( ea ) )
	{
	};
	// test rapidblink mask
	if ( GET_RAPIDBLINK( ea ) )
	{
	};
	// test reverse mask
	if ( GET_REVERSE( ea ) )
		cp = REVERSECOLOR( cp );
	// test mivisible mask	
	if ( GET_INVISIBLE( ea ) )
	{
	};

	painter->setPen( m_color[ GET_FG(cp) ] );
	painter->setBackgroundColor( m_color[ GET_BG(cp) ] );
}


// draw functions
void QTermScreen::drawStr( const QString& str, short attr, int x, int y, int length )
{	
	setAttr( attr );
	painter->drawText( getPosX( x ), getPosY( y ) + nCharAscent, str );
	
	// for we support background pixmap,
	// so when use default attribute, we must marge foreground text and background pixmap together
	// now we use a mask pixmap to do this as following
	if ( ( GET_BG( GET_COLORPAIR( attr ) ) == GET_BG( GET_COLORPAIR( defaultAttr ) ) ) 
		&& !GET_REVERSE( GET_EXTRAATTR( attr ) ) 
		&& bBGPixmap )
	{
		QPixmap *tempPm = new QPixmap( length * nCharWidth, nCharHeight );	// mask pixmap
		QPainter *p = new QPainter();
		p->begin( tempPm );
		p->setPen( Qt::black );			// black foreground color
		p->setBackgroundColor( Qt::white );	// white background color
		p->setBackgroundMode( Qt::OpaqueMode );
		p->setFont( *m_font );
		p->drawText( 0, nCharAscent, str );
	
		p->end();
		
		// use mask pixmap to merge them together
		bitBlt( pm, getPosX( x ), getPosY( y ), tempPm, 0, 0, length * nCharWidth, nCharHeight, Qt::NotAndROP, false );
		bitBlt( tempPm, 0, 0, backPm, getPosX( x ), getPosY( y ), length * nCharWidth, nCharHeight, Qt::AndROP, false );
		bitBlt( pm, getPosX( x ), getPosY( y ), tempPm, 0, 0, length * nCharWidth, nCharHeight, Qt::OrROP, false );

		delete tempPm;
		delete p;
	}	

}

void QTermScreen::drawLine( int index, short specialAttr )
{
	currentLine = lineList->at( index );
	int linelength = currentLine->getLength();
	int startx;
	QCString cp = currentLine->getColorpair();
	QCString ea = currentLine->getExtraAttr();

	char tempcp, tempea;
	short tempattr;
	
	for ( int i = 0; i < linelength; i++ )
	{
		startx = i;
		tempcp = cp[i];
		tempea = ea[i];
		
		// get str of the same attribute
		while ( tempcp == cp[i] && tempea == ea[i] && i < linelength )
			i++;
		strShow = currentLine->getText( startx, i - startx );

		tempattr = COLORPAIR( tempcp ) | EXTRAATTR( tempea ) | specialAttr;
		drawStr( strShow, tempattr, startx, index, i - startx );
		
		i--;
	}

}

void QTermScreen::drawChangeLine( int index, short specialAttr )
{
	currentLine = lineList->at( index );

	if ( currentLine->changeEnd == 0 )
		return;

	int linelength = currentLine->getLength();

	if ( currentLine->changeEnd > linelength )
 		drawEraseRect( currentLine->changeStart, index, currentLine->changeEnd - currentLine->changeStart, 1, m_attr );

	int startx;
	QCString cp = currentLine->getColorpair();
	QCString ea = currentLine->getExtraAttr();
	char tempcp, tempea;
	short tempattr;
	
	for ( int i = currentLine->changeStart; i < linelength; i++ )
  	{
 		startx = i;
		tempcp = cp[i];
		tempea = ea[i];
		while ( tempcp == cp[i] && tempea == ea[i] && i < linelength )
			i++;
		tempattr = COLORPAIR( tempcp ) | EXTRAATTR( tempea ) | specialAttr;
		// some times need erase area
		if ( ( GET_BLINK( tempea ) && bBlink ) || GET_INVISIBLE( tempea ) )
			drawEraseRect( startx, index, i - startx, 1, tempattr );
		else
		{
			strShow = currentLine->getText( startx, i - startx );
			drawStr( strShow, tempattr, startx, index, i - startx );
		}

		
		i--;
	}		

	if ( !( currentLine->bBlink ) ) 
		currentLine->changeDrawn();
}
	
void QTermScreen::drawEraseRect( int startX, int startY, int width, int height, short attr )
{
	// use current attribute to erase rect
	setAttr( attr );
	painter->eraseRect( getPosX( startX ), getPosY( startY ), width  * nCharWidth, height * nCharHeight );

	// if use default attribute and background pixmap, repaint pixmap 
	if ( GET_BG( GET_COLORPAIR( attr ) ) == GET_BG( NO_COLOR ) && bBGPixmap )
		bitBlt( pm, getPosX( startX ), getPosY( startY ), backPm, getPosX( startX ), getPosY( startY ), width * nCharWidth, height * nCharHeight, Qt::CopyROP, false );

}

void QTermScreen::drawRefreshRect( int startX, int startY, int width, int height )
{
	// display pm
	bitBlt( this, getPosX( startX ) + nBorder, getPosY( startY ) + nBorder, pm, getPosX( startX ), getPosY( startY ), nCharWidth * width, nCharHeight * height, Qt::CopyROP );
}


void QTermScreen::refreshWin()
{
	for ( uint i = 0; i < lineList->count(); i++ )
	{	
		drawEraseRect( 0, i , LINECHARNUM, 1, m_attr );
		drawLine( i );	
	}
	
	repaint();
}

void QTermScreen::blinkWin()
{
	
	for ( uint i = 0; i < LINENUM; i++ )
	{
		currentLine = lineList->at( i );

		if ( !( currentLine->bBlink ) )
			continue;

		// for mouse support
		// reverse area that mouse select
		if ( nSelectLine == ( int ) i )
		{
			if ( nPageState == 1 )
			{
				if( parentWin->arrowState==0)
					drawChangeLine( i, 0x0088 );
			}
			else
			{
				if( parentWin->arrowState==0)
				{
					currentLine = lineList->at( mouseY );
					strShow = currentLine->getText( nMenuStart, nMenuLength );
					drawStr( strShow, m_attr | 0x0088, nMenuStart, mouseY, nMenuLength ); 
				}
			}
		}
		else
			drawChangeLine( i );
	}
	
	if(parentWin->bIsLogin)
	     drawCaret( bBlink );

	repaint();
}

// draw caret in current position
void QTermScreen::drawCaret( bool bShow )
{
	short tempattr;
	if ( !bShow )
		tempattr = m_attr;	
	else
		tempattr = COLORPAIR( REVERSECOLOR( GET_COLORPAIR( m_attr ) ) ) | EXTRAATTR( GET_EXTRAATTR( m_attr ) );

	currentLine = lineList->at( caretY );
	
	if ( caretX >= currentLine->getLength() )
		strShow = " ";
	else
		strShow = currentLine->getText(caretX,1 );
	drawStr( strShow, tempattr, caretX, caretY, 1);  
}



void QTermScreen::setPageState( int pageState, int selectLine, int menuStart, int menuLength )
{
	nPageState = pageState;
	nSelectLine = selectLine;
	nMenuStart = menuStart;
	nMenuLength = menuLength;
}
void QTermScreen::resizeEvent(QResizeEvent * re)
{
	//calculate the new font size
        int i=0;

loop:	
	int nNewFont=MIN((re->size()).height()/(25+i),(re->size()).width()/40);

//	printf("resize:%d  %d  Font:%d\n",re->size().width(),re->size().height(),nNewFont);
	m_font->setPixelSize( nNewFont<=0 ? 12 : nNewFont);
	nFontSize=m_font->pointSize();	
	//and reset the param about font too
	delete fm;
	fm = new QFontMetrics( *m_font );
	nCharWidth = fm->width( 'x');
	nCharHeight = fm->height();
	nCharAscent = fm->ascent();
	nCharDescent = fm->descent();
        if((nCharHeight > re->size().height()/LINENUM)&&(nNewFont!=0))
	{
		i++;
		goto loop;
	}
	
	//prepare new pm and new painter
	painter->end();
	pm->resize(nCharWidth * LINECHARNUM , nCharHeight * LINENUM );
	setBackground(strPixmap);
	pm->fill( Qt::black );
	delete painter;
	initPainter();
        nBorder=0;
	refreshWin();
}

void QTermScreen::drawSelectArea(int topX,int topY,int bottomX,int bottomY)
{
	if(bottomY==topY)
	{
		lineList->at(topY)->setAttr(MIN(topX,bottomX),abs(bottomX-topX),0x4000);
		return;
	}


	lineList->at(topY)->setAttr( (topY<bottomY)?topX:0,
				     (topY<bottomY)?LINECHARNUM-topX:topX,0x4000);

	for(int i=MIN(topY,bottomY)+1;i<MAX(topY,bottomY);i++)
	{
		lineList->at(i)->setAttr(0,LINECHARNUM,0x4000);
	}

	lineList->at(bottomY)->setAttr((topY<bottomY)?0:bottomX,
				       (topY<bottomY)?bottomX:LINECHARNUM-bottomX,0x4000);
}

void QTermScreen::redrawSelectArea(int topX,int topY,int bottomX,int bottomY)
{
	if(bottomY==topY)
	{
		lineList->at(topY)->resetAttr(MIN(topX,bottomX),abs(bottomX-topX),0x4000);
		return;
	}

	lineList->at(topY)->resetAttr((topY<bottomY)?topX:0,
				     (topY<bottomY)?LINECHARNUM-topX:topX,0x4000);

	for(int i=MIN(topY,bottomY)+1;i<MAX(topY,bottomY);i++)
	{
		lineList->at(i)->resetAttr(0,LINECHARNUM,0x4000);
	}

	lineList->at(bottomY)->resetAttr((topY<bottomY)?0:bottomX,
				       (topY<bottomY)?bottomX:LINECHARNUM-bottomX,0x4000);
}

void QTermScreen::setSelectText()
{
	strSelectText="";

	int topX,topY,bottomX,bottomY;
	topY=MIN(beginY,endY);
	topX=(beginY==topY)?beginX:endX;
	bottomY=MAX(beginY,endY);
	bottomX=(beginY==bottomY)?beginX:endX;

	if(beginY==endY)
	{
		strSelectText=lineList->at(beginY)->getText(MIN(beginX,endX),abs(endX-beginX));
		strSelectText+='\n';
		return;
	}

	strSelectText+=lineList->at(topY)->getText(topX,LINECHARNUM-topX);
	strSelectText+='\n';

	for(int i=topY+1;i<bottomY;i++)
	{
		strSelectText+=lineList->at(i)->getText(0,LINECHARNUM);
		strSelectText+='\n';
	}

	strSelectText+=lineList->at(bottomY)->getText(0,bottomX);
	strSelectText+='\n';
}
///add by kingson 10-25-01
void QTermScreen::focusInEvent(QFocusEvent *)
{
	
	((QTerm* )( qApp->mainWidget()))->wndmgr->activateTheTab
		((QTermWindow*)parentWidget());
	
}
