/*******************************************************************************
FILENAME:      qtermwndmgr.cpp
REVISION:      2001.8.12 first created.
         
AUTHOR:        kingson fiasco
*******************************************************************************/
/*******************************************************************************
                                    NOTE
 This file may be used, distributed and modified without limitation.
 *******************************************************************************/
#include "qtermwndmgr.h"
#include "qterm.h"
#include "qtermwindow.h"
#include <qapplication.h>
#include <qlist.h>
#include <stdio.h>
#include <qiconset.h>

extern QString pathLib;

QTermWndMgr::QTermWndMgr()
{
	pWin.clear();
	pTab.clear();
}

QTermWndMgr::~QTermWndMgr()
{

}
int   QTermWndMgr::addWindow(QTermWindow * mw,QTab * qtab, QIconSet * icon)
{
  
	ASSERT(mw!=NULL);
	pWin.append(mw);
	ASSERT(qtab!=NULL);
	pTab.append(qtab);
	pIcon.append(icon);
	return pTab.count();

}
void QTermWndMgr::removeWindow(QTermWindow * mw)
{
//	printf(mw->caption()+"  removeWindow\n");
	int n=pWin.find(mw);
	QTab * qtab=pTab.at(n);
	QIconSet *qicon=pIcon.at(n);

	pTab.remove(qtab);
	pWin.remove(mw);
	pIcon.remove(qicon);
	
	((QTerm* )( qApp->mainWidget()))->tabBar->removeTab(qtab);

	
}

void QTermWndMgr::activateTheTab(QTermWindow * mw)
{
//	 printf(mw->caption()+"   activateTheTab\n");
	int n=pWin.find(mw);
	QTab * qtab=pTab.at(n);
	((QTerm* )( qApp->mainWidget()))->tabBar->setCurrentTab(qtab);

       }
void QTermWndMgr::activateTheWindow(QTab *qtab)
{
	int n=pTab.find(qtab);
	QTermWindow * mw=pWin.at(n);
//     	printf(mw->caption()+"   activateTheWindow\n");
	mw->setFocus();	
}

void QTermWndMgr::blinkTheTab(QTermWindow * mw,bool bVisible)
{
//	printf("blink the tab\n");
	int n=pWin.find(mw);
	QIconSet* icon=pIcon.at(n);
	if(bVisible)

		icon->setPixmap(pathLib+"pic/tabpic.bmp",QIconSet::Automatic);
		
	else
		icon->setPixmap(pathLib+"pic/blink.bmp",QIconSet::Automatic);	

	((QTerm* )( qApp->mainWidget()))->tabBar->update();
	
}


int QTermWndMgr::connectionCount()
{
	int num=0,n;
	n=pWin.count();
	for(int i=0;i<n;i++)
	{
		if(pWin.at(i)->bIsLogin)
			num++;
	}
//        printf("%d\n",num);
	return num;
}



