/***************************************************************************
                          tagmaildlg.cpp  -  description
                             -------------------
    begin                : Sat Nov 24 2001
    copyright            : (C) 2001 by Andras Mantia
    email                : amantia@freemail.hu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "tagmaildlg.h"
#include "listdlg.h"

//kde includes
#include <kapp.h>
#include <kabapi.h>
#include <klocale.h>
#include <kmessagebox.h>

//qt includes
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qstringlist.h>

TagMailDlg::TagMailDlg(QWidget *parent, const char *name)
	:TagMail(parent,name,true)
{
  setCaption(name);
	
  connect( buttonOk,     SIGNAL(clicked()), SLOT(accept()) );
  connect( buttonCancel, SIGNAL(clicked()), SLOT(reject()) );
  connect( buttonHelp,SIGNAL(clicked()),this,SLOT(slotShowHelp()));
  connect( buttonAddressSelect, SIGNAL(clicked()), SLOT(slotSelectAddress()) );
}

TagMailDlg::~TagMailDlg(){
}
/** Select a mail address, using the KabApi */
void TagMailDlg::slotSelectAddress()
{
 KabAPI kabapi(this);
 if(kabapi.init()!=AddressBook::NoError)
   {
     KMessageBox::error(this,i18n("Cannot access the address book!"),i18n("Error"));
     return;
   }
 AddressBook::Entry entry;
 KabKey key;
 QString emailString;

 if(kabapi.exec())
   {
     if(kabapi.getEntry(entry,key) == AddressBook::NoError)
     {
         if (entry.emails.count() >1 )
         {
            ListDlg listDlg(entry.emails);
            if (!listDlg.exec()) return;
			emailString = listDlg.getEntry();
         } else
         {
         	emailString =  entry.emails[0];
         }
         lineEmail->setText(emailString);
     } else
     {
//Actually this may mean also other erros, but the result is the same for us: cannot get the
//e-mail address
          KMessageBox::error(this,i18n("No addresses found!"),i18n("Error"));
     }
   }
}

void TagMailDlg::slotShowHelp()
{
//FIXME: "tag-mail" should be replaced with the real help section tag
   kapp->invokeHelp("tag-mail","quanta");
}
