

/*
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/

// $Id: Instruments.i,v 1.5 2002/01/16 14:51:30 nando Exp $

#ifndef quantlib_instruments_i
#define quantlib_instruments_i

%include MarketElements.i
%include String.i

%{
#include <cstdlib>
using QuantLib::Instrument;
using QuantLib::Handle;
typedef Handle<Instrument> InstrumentHandle;
%}

// Export Handle<Instrument>
%name(Instrument) class InstrumentHandle {
  private:
    // abstract class - no constructor exported
    InstrumentHandle();
  public:
	~InstrumentHandle();
};

// replicate the Instrument interface
%addmethods InstrumentHandle {
    void crash() {}
	String isinCode() {
		return (*self)->isinCode();
	}
	String description() {
		return (*self)->description();
	}
	double NPV() {
		return (*self)->NPV();
	}
	void recalculate() {
		(*self)->recalculate();
	}
	String __str__() {
	    if (self->isNull())
	        return "Null instrument";
    	std::string isin = (*self)->isinCode();
    	if (isin == "")
    		isin = "unknown";
    	std::string desc = (*self)->description();
    	if (desc == "")
    		desc = "no description available";
    	return ("Instrument: "+isin+" ("+desc+")");
	}
	int __cmp__(const InstrumentHandle& other) {
		return ((*self)->isinCode() == other->isinCode() ? 0 : 1);
	}
}


// actual instruments

%{
    using QuantLib::Instruments::Stock;
    typedef Handle<Stock> StockHandle;
%}

%name(Stock) class StockHandle : public InstrumentHandle {
  public:
    // constructor redefined below
    ~StockHandle();
};

%addmethods StockHandle {
    void crash() {}
    StockHandle(MarketElementRelinkableHandle quote,
      String isinCode, String description) {
        return new StockHandle(new Stock(quote,isinCode,description));
    }
}


#endif
