

/*
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/

// $Id: Solvers1D.i,v 1.7 2002/01/16 14:51:31 nando Exp $

#ifndef quantlib_solver1d_i
#define quantlib_solver1d_i

// Function to find root of

%{
using QuantLib::ObjectiveFunction;
%}

%{
// C++ container for Ruby block
class RubyObjectiveFunction : public ObjectiveFunction {
  public:
    double operator()(double x) const {
        return NUM2DBL(rb_yield(rb_float_new(x)));
    }
};
%}


// 1D Solver interface

%{
using QuantLib::Solver1D;
using QuantLib::Solvers1D::Brent;
%}

class Solver1D {
  private:
    // abstract class - no constructor exported
    Solver1D();
  public:
    ~Solver1D();
    void setMaxEvaluations(int evaluations);
    void setLowBound(double lowBound);
    %pragma(ruby) alias = "lowBound= setLowBound";
    void setHiBound(double hiBound);
    %pragma(ruby) alias = "hiBound= setHiBound";
};

%addmethods Solver1D {
    void crash() {}
    double solve(double xAccuracy, double guess, double step) {
        RubyObjectiveFunction f;
        return self->solve(f, xAccuracy, guess, step);
    }
    double bracketedSolve(double xAccuracy, double guess,
      double xMin, double xMax) {
        RubyObjectiveFunction f;
        return self->solve(f, xAccuracy, guess, xMin, xMax);
    }
}

// Actual solvers

class Brent : public Solver1D {
  public:
    Brent();
    ~Brent();
};


#endif
