

/*
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/

// $Id: TermStructures.i,v 1.6 2002/01/16 14:51:31 nando Exp $

#ifndef quantlib_term_structures_i
#define quantlib_term_structures_i

%include Date.i
%include Calendars.i
%include DayCounters.i
%include Currencies.i
%include MarketElements.i
%include Types.i

%{
using QuantLib::TermStructure;
using QuantLib::Handle;
using QuantLib::RelinkableHandle;
typedef Handle<TermStructure> TermStructureHandle;
typedef RelinkableHandle<TermStructure> TermStructureRelinkableHandle;
%}

// export Handle<TermStructure>
%name(TermStructure) class TermStructureHandle {
  private:
    // abstract class - no constructor exported
    TermStructureHandle();
  public:
	~TermStructureHandle();
};

// replicate the TermStructure interface
%addmethods TermStructureHandle {
    void crash() {}
	Currency currency() {
		return (*self)->currency();
	}
	Date todaysDate() {
		return (*self)->todaysDate();
	}
	Calendar calendar() {
		return (*self)->calendar();
	}
	DayCounter dayCounter() {
		return (*self)->dayCounter();
	}
	int settlementDays() {
		return (*self)->settlementDays();
	}
	Date settlementDate() {
		return (*self)->settlementDate();
	}
	Date maxDate() {
		return (*self)->maxDate();
	}
	Date minDate() {
		return (*self)->minDate();
	}
	Rate _zeroYieldVsDate(const Date& d, bool extrapolate) {
		return (*self)->zeroYield(d, extrapolate);
	}
	Rate _zeroYieldVsTime(Time t, bool extrapolate) {
		return (*self)->zeroYield(t, extrapolate);
	}
	DiscountFactor _discountVsDate(const Date& d, bool extrapolate) {
		return (*self)->discount(d, extrapolate);
	}
	DiscountFactor _discountVsTime(Time t, bool extrapolate) {
		return (*self)->discount(t, extrapolate);
	}
	Rate _forwardVsDate(const Date& d, bool extrapolate) {
		return (*self)->forward(d, extrapolate);
	}
	Rate _forwardVsTime(Time t, bool extrapolate) {
		return (*self)->forward(t, extrapolate);
	}
}


// export RelinkableHandle<TermStructure>
%name(TermStructureHandle) class TermStructureRelinkableHandle {
  public:
    TermStructureRelinkableHandle();
	~TermStructureRelinkableHandle();
	void linkTo(TermStructureHandle);
};


// implied term structure

%{
using QuantLib::ImpliedTermStructure;
typedef Handle<ImpliedTermStructure> ImpliedTermStructureHandle;
%}

%name(ImpliedTermStructure) class ImpliedTermStructureHandle
: public TermStructureHandle {
  public:
    // constructor redefined below
    ~ImpliedTermStructureHandle();
};

%addmethods ImpliedTermStructureHandle {
    void crash() {}
    ImpliedTermStructureHandle(TermStructureRelinkableHandle curveHandle,
        Date todaysDate) {
	        return new ImpliedTermStructureHandle(
	            new ImpliedTermStructure(curveHandle,todaysDate));
    }
}

// spreaded term structures

%{
using QuantLib::ZeroSpreadedTermStructure;
typedef Handle<ZeroSpreadedTermStructure> ZeroSpreadedTermStructureHandle;
using QuantLib::ForwardSpreadedTermStructure;
typedef Handle<ForwardSpreadedTermStructure> ForwardSpreadedTermStructureHandle;
%}

%name(ZeroSpreadedTermStructure) class ZeroSpreadedTermStructureHandle
: public TermStructureHandle {
  public:
    // constructor redefined below
    ~ZeroSpreadedTermStructureHandle();
};

%addmethods ZeroSpreadedTermStructureHandle {
    void crash() {}
    ZeroSpreadedTermStructureHandle(TermStructureRelinkableHandle curveHandle,
        MarketElementRelinkableHandle spread) {
	        return new ZeroSpreadedTermStructureHandle(
	            new ZeroSpreadedTermStructure(curveHandle,spread));
    }
}

%name(ForwardSpreadedTermStructure) class ForwardSpreadedTermStructureHandle
: public TermStructureHandle {
  public:
    // constructor redefined below
    ~ForwardSpreadedTermStructureHandle();
};

%addmethods ForwardSpreadedTermStructureHandle {
    void crash() {}
    ForwardSpreadedTermStructureHandle(TermStructureRelinkableHandle curveHandle,
        MarketElementRelinkableHandle spread) {
	        return new ForwardSpreadedTermStructureHandle(
	            new ForwardSpreadedTermStructure(curveHandle,spread));
    }
}


// flat forward curve

%{
using QuantLib::TermStructures::FlatForward;
typedef Handle<FlatForward> FlatForwardHandle;
%}

%name(FlatForward) class FlatForwardHandle
: public TermStructureHandle {
  public:
    // constructor redefined below
    ~FlatForwardHandle();
};

%addmethods FlatForwardHandle {
    void crash() {}
    FlatForwardHandle(Currency currency, DayCounter dayCounter,
        Date todaysDate, Calendar calendar, int settlementDays,
        Rate forward) {
	        return new FlatForwardHandle(
	            new FlatForward(currency,dayCounter,todaysDate,
	                calendar,settlementDays,forward));
    }
}


#endif
