=begin
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
=end

# $Id: random_generators.rb,v 1.6 2002/01/16 15:17:06 nando Exp $

require 'QuantLib'
require 'runit/testcase'
require 'runit/cui/testrunner'

class RNGTest < RUNIT::TestCase
    def name
        "Testing random number generators..."
    end
    def test
        seed = 576919
        samples = 1000000
        [QuantLib::UniformRandomGenerator,
         QuantLib::GaussianRandomGenerator].each { |rng|
            rn = rng.new(seed)
            s = QuantLib::Statistics.new
            samples.times { s.add(rn.next.value) }
            # add some meaningful test here
        }
    end
end

if $0 == __FILE__
    RUNIT::CUI::TestRunner.run(RNGTest.suite)
end

