

/*
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/
/*! \file valueatcenter.hpp
    \brief compute value, first, and second derivatives at grid center

    \fullpath
    ql/FiniteDifferences/%valueatcenter.hpp
*/

// $Id: valueatcenter.hpp,v 1.5 2002/01/16 14:43:25 nando Exp $

#ifndef quantlib_finite_difference_value_at_center_h
#define quantlib_finite_difference_value_at_center_h

#include <ql/array.hpp>

namespace QuantLib {

    namespace FiniteDifferences {

        //! mid-point value
        double valueAtCenter(const Array& a);

        //! mid-point first derivative
        double firstDerivativeAtCenter(const Array& a,
            const Array& g);

        //! mid-point second derivative
        double secondDerivativeAtCenter(const Array& a,
            const Array& g);

    }

}


#endif
