/*
 Copyright (C) 2001, 2002 Sadruddin Rejeb

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/
/*! \file jamshidianswaption.hpp
    \brief Swaption pricer using Jamshidian's decomposition

    \fullpath
    ql/Pricers/%jamshidianswaption.hpp
*/

// $Id: jamshidianswaption.hpp,v 1.7 2002/03/06 07:16:06 sadrejeb Exp $

#ifndef quantlib_pricers_jamshidian_swaption_h
#define quantlib_pricers_jamshidian_swaption_h

#include "ql/Instruments/swaption.hpp"
#include "ql/InterestRateModelling/onefactormodel.hpp"

namespace QuantLib {

    namespace Pricers {

        //! Jamshidian swaption pricer
        class JamshidianSwaption : public 
            SwaptionPricingEngine<InterestRateModelling::OneFactorAffineModel> {
          public:
            JamshidianSwaption(
                const Handle<InterestRateModelling::OneFactorAffineModel>& modl)
            : SwaptionPricingEngine<InterestRateModelling::OneFactorAffineModel>
                (modl) {} 
            void calculate() const;
          private:
            class rStarFinder;
            friend class rStarFinder;
        };

    }
}

#endif
