// Copyright (C) 1999-2012
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#include "alloc.h"

FitsAlloc::FitsAlloc(const char* fn)
{
  parse(fn);

  if (!strncmp(pName_, "stdin", 5) || 
      !strncmp(pName_, "STDIN", 5) || 
      !strncmp(pName_, "-", 1))
    stream_ = stdin;
  else 
    // we need the 'b' for windows...
    stream_ = fopen(pName_, "rb");

  if (stream_)
    valid_ = 1;
}


