// =============================================================================
// Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2010 - INRIA - Serge Steer
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================

// <-- CLI SHELL MODE -->

// <-- Non-regression test for bug 3688 -->
//
// <-- Bugzilla URL -->
// http://bugzilla.scilab.org/show_bug.cgi?id=3688
//
// <-- Short Description -->
// The assignment using ":" subscript for a dimension that does not exist
// does not work for hypermatrices

A=[];A(1,1,:) = [-1 3]; 
if or(size(A)<>[1 1 2])|or(matrix(A(1,1,:),1,-1)<>[-1 3]) then pause,end

A=[];A(1,1,:) = [-1;3]; 
if or(size(A)<>[1 1 2])|or(matrix(A(1,1,:),1,-1)<>[-1 3]) then pause,end

A=[];A(1,2,:) = [-1 3]; 
if or(size(A)<>[1 2 2])|or(matrix(A(1,:,:),2,-1)<>[0 0;-1 3]) then pause,end

A=[];A(1,2,:) = [-1;3]; 
if or(size(A)<>[1 2 2])|or(matrix(A(1,:,:),2,-1)<>[0 0;-1 3]) then pause,end

A=[];A(2,1,:) = [-1 3]; 
if or(size(A)<>[2 1 2])|or(matrix(A(:,1,:),2,-1)<>[0 0;-1 3]) then pause,end



A=[];A(1,:,1) = [-1 3]; 
if or(A<>[-1 3]) then pause,end

A=[];A(1,:,1) = [-1;3]; 
if or(A<>[-1 3]) then pause,end

A=[];A(:,1,1) = [-1 3]; 
if or(A<>[-1;3]) then pause,end

A=[];A(:,1,1) = [-1;3]; 
if or(A<>[-1;3]) then pause,end

A=[];A(1,:,:) = [-1 3;5 7]; 
if or(size(A)<>[1 2 2])|or(matrix(A(1,:,:),2,-1)<>[-1 3;5 7]) then pause,end

A=[];A(:,1,:) = [-1 3;5 7]; 
if or(size(A)<>[2 1 2])|or(matrix(A(:,1,:),2,-1)<>[-1 3;5 7]) then pause,end

A=[];A(1,:,:) = [-1 3 5 7];
if or(size(A)<>[1 1 4])|or(matrix(A(1,1,:),1,-1)<>[-1 3 5 7]) then pause,end

if execstr("A=[];A(1,1:2,:) = [-1 3 5 7];","errcatch")==0 then pause,end

A=[];A(1,1,2)=3;A(1,1,1,:)=[-1 3]; 
if or(size(A)<>[1 1 2 2])|or(matrix(A(1,1,1,:),1,-1)<>[-1 3]) then pause,end

A=[];A(1,1,2)=3;A(1,1,1,:)=[-1;3]; 
if or(size(A)<>[1 1 2 2])|or(matrix(A(1,1,1,:),1,-1)<>[-1 3]) then pause,end

A=[];A(1,1,2)=3;A(2,1,1,:)=[-1;3]; 
if or(size(A)<>[2 1 2 2])|or(matrix(A(2,1,1,:),1,-1)<>[-1 3]) then pause,end

//insertion of integer
A=[];A(1,1,:) = int32([-1 3]); 
if or(size(A)<>[1 1 2])|or(matrix(A(1,1,:),1,-1)<>int32([-1 3])) then pause,end

A=[];A(1,1,:) = int32([-1;3]); 
if or(size(A)<>[1 1 2])|or(matrix(A(1,1,:),1,-1)<>int32([-1 3])) then pause,end

A=[];A(1,2,:) = int32([-1 3]); 
if or(size(A)<>[1 2 2])|or(matrix(A(1,:,:),2,-1)<>int32([0 0;-1 3])) then pause,end

A=[];A(1,2,:) = int32([-1;3]); 
if or(size(A)<>[1 2 2])|or(matrix(A(1,:,:),2,-1)<>int32([0 0;-1 3])) then pause,end

A=[];A(2,1,:) = int32([-1 3]); 
if or(size(A)<>[2 1 2])|or(matrix(A(:,1,:),2,-1)<>int32([0 0;-1 3])) then pause,end

A=[];A(1,:,1) = int32([-1 3]); 
if or(A<>int32([-1 3])) then pause,end

A=[];A(1,:,1) = int32([-1;3]); 
if or(A<>int32([-1 3])) then pause,end

A=[];A(:,1,1) = int32([-1 3]); 
if or(A<>int32([-1;3])) then pause,end

A=[];A(:,1,1) = int32([-1;3]); 
if or(A<>int32([-1;3])) then pause,end


A=[];A(1,:,:) = int32([-1 3;5 7]); 
if or(size(A)<>[1 2 2])|or(matrix(A(1,:,:),2,-1)<>int32([-1 3;5 7])) then pause,end

A=[];A(:,1,:) = int32([-1 3;5 7]); 
if or(size(A)<>[2 1 2])|or(matrix(A(:,1,:),2,-1)<>int32([-1 3;5 7])) then pause,end

A=[];A(1,:,:) = int32([-1 3 5 7]);
if or(size(A)<>[1 1 4])|or(matrix(A(1,1,:),1,-1)<>int32([-1 3 5 7])) then pause,end

if execstr("A=[];A(1,1:2,:) = int32([-1 3 5 7];","errcatch")==0 then pause,end

A=[];A(1,1,2)=int32(3);A(1,1,1,:)=int32([-1 3]); 
if or(size(A)<>[1 1 2 2])|or(matrix(A(1,1,1,:),1,-1)<>int32([-1 3])) then pause,end

A=[];A(1,1,2)=int32(3);A(1,1,1,:)=int32([-1;3]); 
if or(size(A)<>[1 1 2 2])|or(matrix(A(1,1,1,:),1,-1)<>int32([-1 3])) then pause,end

A=[];A(1,1,2)=int32(3);A(2,1,1,:)=int32([-1;3]); 
if or(size(A)<>[2 1 2 2])|or(matrix(A(2,1,1,:),1,-1)<>int32([-1 3])) then pause,end

//same should work for other types that uses the same algorithm (generic_i_hm)
//polynomials
A=[];A(1,1,:) = [-1 3]+%s;
if or(size(A)<>[1 1 2])|or(matrix(A(1,1,:),1,-1)<>[-1 3]+%s) then pause,end

A=[];A(1,1,2)=3;A(2,1,1,:)=[-1;3]+%s; 
if or(size(A)<>[2 1 2 2])|or(matrix(A(2,1,1,:),1,-1)<>[-1 3]+%s) then pause,end

//booleans
A=[];A(1,1,:) = [%t %f];
if or(size(A)<>[1 1 2])|or(matrix(A(1,1,:),1,-1)<>[%t %f]) then pause,end

A=[];A(1,1,2)=%t;A(2,1,1,:)= [%t; %f]; 
if or(size(A)<>[2 1 2 2])|or(matrix(A(2,1,1,:),1,-1)<>[%t %f]) then pause,end

//added because a bug found in %b_i_b.sci
A=%t;A(2,1,1,:)= [%t; %f]; 
if or(size(A)<>[2 1 1 2])|or(matrix(A(2,1,1,:),1,-1)<>[%t %f]) then pause,end
