/*							-- DO NOT EDIT --
 * This file has been generated by smidump
 * version 0.3.1 for the scli package.
 *
 * Derived from MAU-MIB:
 *   Management information for 802.3 MAUs.
 *   
 *   The following reference is used throughout
 *   this MIB module:
 *   
 *   [IEEE 802.3 Std] refers to
 *      IEEE Std 802.3, 1998 Edition: 'Information
 *      technology - Telecommunications and
 *      information exchange between systems -
 *      Local and metropolitan area networks -
 *      Specific requirements - Part 3: Carrier
 *      sense multiple access with collision
 *      detection (CSMA/CD) access method and
 *      physical layer specifications',
 *      September 1998.
 *   
 *   Of particular interest is Clause 30, '10Mb/s,
 *   100Mb/s and 1000Mb/s Management'.
 *
 * Revision 1999-08-24 04:00:
 *   This version published as RFC 2668. Updated
 *   to include support for 1000 Mb/sec
 *   MAUs and flow control negotiation.
 *
 * Revision 1997-10-31 00:00:
 *   This version published as RFC 2239.
 *
 * Revision 1993-09-30 00:00:
 *   Initial version, published as RFC 1515.
 *
 * $Id: mau-mib.c,v 1.11 2002/03/27 13:48:21 schoenw Exp $
 */

#include "mau-mib.h"

GSnmpEnum const mau_mib_enums_rpMauStatus[] = {
    { MAU_MIB_RPMAUSTATUS_OTHER,       "other" },
    { MAU_MIB_RPMAUSTATUS_UNKNOWN,     "unknown" },
    { MAU_MIB_RPMAUSTATUS_OPERATIONAL, "operational" },
    { MAU_MIB_RPMAUSTATUS_STANDBY,     "standby" },
    { MAU_MIB_RPMAUSTATUS_SHUTDOWN,    "shutdown" },
    { MAU_MIB_RPMAUSTATUS_RESET,       "reset" },
    { 0, NULL }
};

GSnmpEnum const mau_mib_enums_rpMauMediaAvailable[] = {
    { MAU_MIB_RPMAUMEDIAAVAILABLE_OTHER,          "other" },
    { MAU_MIB_RPMAUMEDIAAVAILABLE_UNKNOWN,        "unknown" },
    { MAU_MIB_RPMAUMEDIAAVAILABLE_AVAILABLE,      "available" },
    { MAU_MIB_RPMAUMEDIAAVAILABLE_NOTAVAILABLE,   "notAvailable" },
    { MAU_MIB_RPMAUMEDIAAVAILABLE_REMOTEFAULT,    "remoteFault" },
    { MAU_MIB_RPMAUMEDIAAVAILABLE_INVALIDSIGNAL,  "invalidSignal" },
    { MAU_MIB_RPMAUMEDIAAVAILABLE_REMOTEJABBER,   "remoteJabber" },
    { MAU_MIB_RPMAUMEDIAAVAILABLE_REMOTELINKLOSS, "remoteLinkLoss" },
    { MAU_MIB_RPMAUMEDIAAVAILABLE_REMOTETEST,     "remoteTest" },
    { MAU_MIB_RPMAUMEDIAAVAILABLE_OFFLINE,        "offline" },
    { MAU_MIB_RPMAUMEDIAAVAILABLE_AUTONEGERROR,   "autoNegError" },
    { 0, NULL }
};

GSnmpEnum const mau_mib_enums_rpMauJabberState[] = {
    { MAU_MIB_RPMAUJABBERSTATE_OTHER,     "other" },
    { MAU_MIB_RPMAUJABBERSTATE_UNKNOWN,   "unknown" },
    { MAU_MIB_RPMAUJABBERSTATE_NOJABBER,  "noJabber" },
    { MAU_MIB_RPMAUJABBERSTATE_JABBERING, "jabbering" },
    { 0, NULL }
};

GSnmpEnum const mau_mib_enums_rpJackType[] = {
    { MAU_MIB_RPJACKTYPE_OTHER,    "other" },
    { MAU_MIB_RPJACKTYPE_RJ45,     "rj45" },
    { MAU_MIB_RPJACKTYPE_RJ45S,    "rj45S" },
    { MAU_MIB_RPJACKTYPE_DB9,      "db9" },
    { MAU_MIB_RPJACKTYPE_BNC,      "bnc" },
    { MAU_MIB_RPJACKTYPE_FAUI,     "fAUI" },
    { MAU_MIB_RPJACKTYPE_MAUI,     "mAUI" },
    { MAU_MIB_RPJACKTYPE_FIBERSC,  "fiberSC" },
    { MAU_MIB_RPJACKTYPE_FIBERMIC, "fiberMIC" },
    { MAU_MIB_RPJACKTYPE_FIBERST,  "fiberST" },
    { MAU_MIB_RPJACKTYPE_TELCO,    "telco" },
    { MAU_MIB_RPJACKTYPE_MTRJ,     "mtrj" },
    { MAU_MIB_RPJACKTYPE_HSSDC,    "hssdc" },
    { 0, NULL }
};

GSnmpEnum const mau_mib_enums_ifMauStatus[] = {
    { MAU_MIB_IFMAUSTATUS_OTHER,       "other" },
    { MAU_MIB_IFMAUSTATUS_UNKNOWN,     "unknown" },
    { MAU_MIB_IFMAUSTATUS_OPERATIONAL, "operational" },
    { MAU_MIB_IFMAUSTATUS_STANDBY,     "standby" },
    { MAU_MIB_IFMAUSTATUS_SHUTDOWN,    "shutdown" },
    { MAU_MIB_IFMAUSTATUS_RESET,       "reset" },
    { 0, NULL }
};

GSnmpEnum const mau_mib_enums_ifMauMediaAvailable[] = {
    { MAU_MIB_IFMAUMEDIAAVAILABLE_OTHER,          "other" },
    { MAU_MIB_IFMAUMEDIAAVAILABLE_UNKNOWN,        "unknown" },
    { MAU_MIB_IFMAUMEDIAAVAILABLE_AVAILABLE,      "available" },
    { MAU_MIB_IFMAUMEDIAAVAILABLE_NOTAVAILABLE,   "notAvailable" },
    { MAU_MIB_IFMAUMEDIAAVAILABLE_REMOTEFAULT,    "remoteFault" },
    { MAU_MIB_IFMAUMEDIAAVAILABLE_INVALIDSIGNAL,  "invalidSignal" },
    { MAU_MIB_IFMAUMEDIAAVAILABLE_REMOTEJABBER,   "remoteJabber" },
    { MAU_MIB_IFMAUMEDIAAVAILABLE_REMOTELINKLOSS, "remoteLinkLoss" },
    { MAU_MIB_IFMAUMEDIAAVAILABLE_REMOTETEST,     "remoteTest" },
    { MAU_MIB_IFMAUMEDIAAVAILABLE_OFFLINE,        "offline" },
    { MAU_MIB_IFMAUMEDIAAVAILABLE_AUTONEGERROR,   "autoNegError" },
    { 0, NULL }
};

GSnmpEnum const mau_mib_enums_ifMauJabberState[] = {
    { MAU_MIB_IFMAUJABBERSTATE_OTHER,     "other" },
    { MAU_MIB_IFMAUJABBERSTATE_UNKNOWN,   "unknown" },
    { MAU_MIB_IFMAUJABBERSTATE_NOJABBER,  "noJabber" },
    { MAU_MIB_IFMAUJABBERSTATE_JABBERING, "jabbering" },
    { 0, NULL }
};

GSnmpEnum const mau_mib_enums_ifMauAutoNegSupported[] = {
    { MAU_MIB_IFMAUAUTONEGSUPPORTED_TRUE,  "true" },
    { MAU_MIB_IFMAUAUTONEGSUPPORTED_FALSE, "false" },
    { 0, NULL }
};

GSnmpEnum const mau_mib_enums_ifJackType[] = {
    { MAU_MIB_IFJACKTYPE_OTHER,    "other" },
    { MAU_MIB_IFJACKTYPE_RJ45,     "rj45" },
    { MAU_MIB_IFJACKTYPE_RJ45S,    "rj45S" },
    { MAU_MIB_IFJACKTYPE_DB9,      "db9" },
    { MAU_MIB_IFJACKTYPE_BNC,      "bnc" },
    { MAU_MIB_IFJACKTYPE_FAUI,     "fAUI" },
    { MAU_MIB_IFJACKTYPE_MAUI,     "mAUI" },
    { MAU_MIB_IFJACKTYPE_FIBERSC,  "fiberSC" },
    { MAU_MIB_IFJACKTYPE_FIBERMIC, "fiberMIC" },
    { MAU_MIB_IFJACKTYPE_FIBERST,  "fiberST" },
    { MAU_MIB_IFJACKTYPE_TELCO,    "telco" },
    { MAU_MIB_IFJACKTYPE_MTRJ,     "mtrj" },
    { MAU_MIB_IFJACKTYPE_HSSDC,    "hssdc" },
    { 0, NULL }
};

GSnmpEnum const mau_mib_enums_broadMauXmtRcvSplitType[] = {
    { MAU_MIB_BROADMAUXMTRCVSPLITTYPE_OTHER,  "other" },
    { MAU_MIB_BROADMAUXMTRCVSPLITTYPE_SINGLE, "single" },
    { MAU_MIB_BROADMAUXMTRCVSPLITTYPE_DUAL,   "dual" },
    { 0, NULL }
};

GSnmpEnum const mau_mib_enums_ifMauAutoNegAdminStatus[] = {
    { MAU_MIB_IFMAUAUTONEGADMINSTATUS_ENABLED,  "enabled" },
    { MAU_MIB_IFMAUAUTONEGADMINSTATUS_DISABLED, "disabled" },
    { 0, NULL }
};

GSnmpEnum const mau_mib_enums_ifMauAutoNegRemoteSignaling[] = {
    { MAU_MIB_IFMAUAUTONEGREMOTESIGNALING_DETECTED,    "detected" },
    { MAU_MIB_IFMAUAUTONEGREMOTESIGNALING_NOTDETECTED, "notdetected" },
    { 0, NULL }
};

GSnmpEnum const mau_mib_enums_ifMauAutoNegConfig[] = {
    { MAU_MIB_IFMAUAUTONEGCONFIG_OTHER,              "other" },
    { MAU_MIB_IFMAUAUTONEGCONFIG_CONFIGURING,        "configuring" },
    { MAU_MIB_IFMAUAUTONEGCONFIG_COMPLETE,           "complete" },
    { MAU_MIB_IFMAUAUTONEGCONFIG_DISABLED,           "disabled" },
    { MAU_MIB_IFMAUAUTONEGCONFIG_PARALLELDETECTFAIL, "parallelDetectFail" },
    { 0, NULL }
};

GSnmpEnum const mau_mib_enums_ifMauAutoNegRestart[] = {
    { MAU_MIB_IFMAUAUTONEGRESTART_RESTART,   "restart" },
    { MAU_MIB_IFMAUAUTONEGRESTART_NORESTART, "norestart" },
    { 0, NULL }
};

GSnmpEnum const mau_mib_enums_ifMauAutoNegRemoteFaultAdvertised[] = {
    { MAU_MIB_IFMAUAUTONEGREMOTEFAULTADVERTISED_NOERROR,      "noError" },
    { MAU_MIB_IFMAUAUTONEGREMOTEFAULTADVERTISED_OFFLINE,      "offline" },
    { MAU_MIB_IFMAUAUTONEGREMOTEFAULTADVERTISED_LINKFAILURE,  "linkFailure" },
    { MAU_MIB_IFMAUAUTONEGREMOTEFAULTADVERTISED_AUTONEGERROR, "autoNegError" },
    { 0, NULL }
};

GSnmpEnum const mau_mib_enums_ifMauAutoNegRemoteFaultReceived[] = {
    { MAU_MIB_IFMAUAUTONEGREMOTEFAULTRECEIVED_NOERROR,      "noError" },
    { MAU_MIB_IFMAUAUTONEGREMOTEFAULTRECEIVED_OFFLINE,      "offline" },
    { MAU_MIB_IFMAUAUTONEGREMOTEFAULTRECEIVED_LINKFAILURE,  "linkFailure" },
    { MAU_MIB_IFMAUAUTONEGREMOTEFAULTRECEIVED_AUTONEGERROR, "autoNegError" },
    { 0, NULL }
};


static guint32 const dot3MauTypeAUI[]
	= { MAU_MIB_DOT3MAUTYPEAUI };
static guint32 const dot3MauType10Base5[]
	= { MAU_MIB_DOT3MAUTYPE10BASE5 };
static guint32 const dot3MauTypeFoirl[]
	= { MAU_MIB_DOT3MAUTYPEFOIRL };
static guint32 const dot3MauType10Base2[]
	= { MAU_MIB_DOT3MAUTYPE10BASE2 };
static guint32 const dot3MauType10BaseT[]
	= { MAU_MIB_DOT3MAUTYPE10BASET };
static guint32 const dot3MauType10BaseFP[]
	= { MAU_MIB_DOT3MAUTYPE10BASEFP };
static guint32 const dot3MauType10BaseFB[]
	= { MAU_MIB_DOT3MAUTYPE10BASEFB };
static guint32 const dot3MauType10BaseFL[]
	= { MAU_MIB_DOT3MAUTYPE10BASEFL };
static guint32 const dot3MauType10Broad36[]
	= { MAU_MIB_DOT3MAUTYPE10BROAD36 };
static guint32 const dot3MauType10BaseTHD[]
	= { MAU_MIB_DOT3MAUTYPE10BASETHD };
static guint32 const dot3MauType10BaseTFD[]
	= { MAU_MIB_DOT3MAUTYPE10BASETFD };
static guint32 const dot3MauType10BaseFLHD[]
	= { MAU_MIB_DOT3MAUTYPE10BASEFLHD };
static guint32 const dot3MauType10BaseFLFD[]
	= { MAU_MIB_DOT3MAUTYPE10BASEFLFD };
static guint32 const dot3MauType100BaseT4[]
	= { MAU_MIB_DOT3MAUTYPE100BASET4 };
static guint32 const dot3MauType100BaseTXHD[]
	= { MAU_MIB_DOT3MAUTYPE100BASETXHD };
static guint32 const dot3MauType100BaseTXFD[]
	= { MAU_MIB_DOT3MAUTYPE100BASETXFD };
static guint32 const dot3MauType100BaseFXHD[]
	= { MAU_MIB_DOT3MAUTYPE100BASEFXHD };
static guint32 const dot3MauType100BaseFXFD[]
	= { MAU_MIB_DOT3MAUTYPE100BASEFXFD };
static guint32 const dot3MauType100BaseT2HD[]
	= { MAU_MIB_DOT3MAUTYPE100BASET2HD };
static guint32 const dot3MauType100BaseT2FD[]
	= { MAU_MIB_DOT3MAUTYPE100BASET2FD };
static guint32 const dot3MauType1000BaseXHD[]
	= { MAU_MIB_DOT3MAUTYPE1000BASEXHD };
static guint32 const dot3MauType1000BaseXFD[]
	= { MAU_MIB_DOT3MAUTYPE1000BASEXFD };
static guint32 const dot3MauType1000BaseLXHD[]
	= { MAU_MIB_DOT3MAUTYPE1000BASELXHD };
static guint32 const dot3MauType1000BaseLXFD[]
	= { MAU_MIB_DOT3MAUTYPE1000BASELXFD };
static guint32 const dot3MauType1000BaseSXHD[]
	= { MAU_MIB_DOT3MAUTYPE1000BASESXHD };
static guint32 const dot3MauType1000BaseSXFD[]
	= { MAU_MIB_DOT3MAUTYPE1000BASESXFD };
static guint32 const dot3MauType1000BaseCXHD[]
	= { MAU_MIB_DOT3MAUTYPE1000BASECXHD };
static guint32 const dot3MauType1000BaseCXFD[]
	= { MAU_MIB_DOT3MAUTYPE1000BASECXFD };
static guint32 const dot3MauType1000BaseTHD[]
	= { MAU_MIB_DOT3MAUTYPE1000BASETHD };
static guint32 const dot3MauType1000BaseTFD[]
	= { MAU_MIB_DOT3MAUTYPE1000BASETFD };

GSnmpIdentity const mau_mib_identities[] = {
    { dot3MauTypeAUI,
      sizeof(dot3MauTypeAUI)/sizeof(guint32),
      "dot3MauTypeAUI" },
    { dot3MauType10Base5,
      sizeof(dot3MauType10Base5)/sizeof(guint32),
      "dot3MauType10Base5" },
    { dot3MauTypeFoirl,
      sizeof(dot3MauTypeFoirl)/sizeof(guint32),
      "dot3MauTypeFoirl" },
    { dot3MauType10Base2,
      sizeof(dot3MauType10Base2)/sizeof(guint32),
      "dot3MauType10Base2" },
    { dot3MauType10BaseT,
      sizeof(dot3MauType10BaseT)/sizeof(guint32),
      "dot3MauType10BaseT" },
    { dot3MauType10BaseFP,
      sizeof(dot3MauType10BaseFP)/sizeof(guint32),
      "dot3MauType10BaseFP" },
    { dot3MauType10BaseFB,
      sizeof(dot3MauType10BaseFB)/sizeof(guint32),
      "dot3MauType10BaseFB" },
    { dot3MauType10BaseFL,
      sizeof(dot3MauType10BaseFL)/sizeof(guint32),
      "dot3MauType10BaseFL" },
    { dot3MauType10Broad36,
      sizeof(dot3MauType10Broad36)/sizeof(guint32),
      "dot3MauType10Broad36" },
    { dot3MauType10BaseTHD,
      sizeof(dot3MauType10BaseTHD)/sizeof(guint32),
      "dot3MauType10BaseTHD" },
    { dot3MauType10BaseTFD,
      sizeof(dot3MauType10BaseTFD)/sizeof(guint32),
      "dot3MauType10BaseTFD" },
    { dot3MauType10BaseFLHD,
      sizeof(dot3MauType10BaseFLHD)/sizeof(guint32),
      "dot3MauType10BaseFLHD" },
    { dot3MauType10BaseFLFD,
      sizeof(dot3MauType10BaseFLFD)/sizeof(guint32),
      "dot3MauType10BaseFLFD" },
    { dot3MauType100BaseT4,
      sizeof(dot3MauType100BaseT4)/sizeof(guint32),
      "dot3MauType100BaseT4" },
    { dot3MauType100BaseTXHD,
      sizeof(dot3MauType100BaseTXHD)/sizeof(guint32),
      "dot3MauType100BaseTXHD" },
    { dot3MauType100BaseTXFD,
      sizeof(dot3MauType100BaseTXFD)/sizeof(guint32),
      "dot3MauType100BaseTXFD" },
    { dot3MauType100BaseFXHD,
      sizeof(dot3MauType100BaseFXHD)/sizeof(guint32),
      "dot3MauType100BaseFXHD" },
    { dot3MauType100BaseFXFD,
      sizeof(dot3MauType100BaseFXFD)/sizeof(guint32),
      "dot3MauType100BaseFXFD" },
    { dot3MauType100BaseT2HD,
      sizeof(dot3MauType100BaseT2HD)/sizeof(guint32),
      "dot3MauType100BaseT2HD" },
    { dot3MauType100BaseT2FD,
      sizeof(dot3MauType100BaseT2FD)/sizeof(guint32),
      "dot3MauType100BaseT2FD" },
    { dot3MauType1000BaseXHD,
      sizeof(dot3MauType1000BaseXHD)/sizeof(guint32),
      "dot3MauType1000BaseXHD" },
    { dot3MauType1000BaseXFD,
      sizeof(dot3MauType1000BaseXFD)/sizeof(guint32),
      "dot3MauType1000BaseXFD" },
    { dot3MauType1000BaseLXHD,
      sizeof(dot3MauType1000BaseLXHD)/sizeof(guint32),
      "dot3MauType1000BaseLXHD" },
    { dot3MauType1000BaseLXFD,
      sizeof(dot3MauType1000BaseLXFD)/sizeof(guint32),
      "dot3MauType1000BaseLXFD" },
    { dot3MauType1000BaseSXHD,
      sizeof(dot3MauType1000BaseSXHD)/sizeof(guint32),
      "dot3MauType1000BaseSXHD" },
    { dot3MauType1000BaseSXFD,
      sizeof(dot3MauType1000BaseSXFD)/sizeof(guint32),
      "dot3MauType1000BaseSXFD" },
    { dot3MauType1000BaseCXHD,
      sizeof(dot3MauType1000BaseCXHD)/sizeof(guint32),
      "dot3MauType1000BaseCXHD" },
    { dot3MauType1000BaseCXFD,
      sizeof(dot3MauType1000BaseCXFD)/sizeof(guint32),
      "dot3MauType1000BaseCXFD" },
    { dot3MauType1000BaseTHD,
      sizeof(dot3MauType1000BaseTHD)/sizeof(guint32),
      "dot3MauType1000BaseTHD" },
    { dot3MauType1000BaseTFD,
      sizeof(dot3MauType1000BaseTFD)/sizeof(guint32),
      "dot3MauType1000BaseTFD" },
    { 0, 0, NULL }
};


static guint32 const rpMauEntry_oid[] = {1, 3, 6, 1, 2, 1, 26, 1, 1, 1};

static GSnmpAttribute rpMauEntry_attr[] = {
    { 4, G_SNMP_OBJECTID,
      MAU_MIB_RPMAUTYPE, "rpMauType",
       NULL,
      G_STRUCT_OFFSET(mau_mib_rpMauEntry_t, rpMauType),
      G_STRUCT_OFFSET(mau_mib_rpMauEntry_t, _rpMauTypeLength),
      0 },
    { 5, G_SNMP_INTEGER32,
      MAU_MIB_RPMAUSTATUS, "rpMauStatus",
       NULL,
      G_STRUCT_OFFSET(mau_mib_rpMauEntry_t, rpMauStatus),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 6, G_SNMP_INTEGER32,
      MAU_MIB_RPMAUMEDIAAVAILABLE, "rpMauMediaAvailable",
       NULL,
      G_STRUCT_OFFSET(mau_mib_rpMauEntry_t, rpMauMediaAvailable),
      0,
      0 },
    { 7, G_SNMP_COUNTER32,
      MAU_MIB_RPMAUMEDIAAVAILABLESTATEEXITS, "rpMauMediaAvailableStateExits",
       NULL,
      G_STRUCT_OFFSET(mau_mib_rpMauEntry_t, rpMauMediaAvailableStateExits),
      0,
      0 },
    { 8, G_SNMP_INTEGER32,
      MAU_MIB_RPMAUJABBERSTATE, "rpMauJabberState",
       NULL,
      G_STRUCT_OFFSET(mau_mib_rpMauEntry_t, rpMauJabberState),
      0,
      0 },
    { 9, G_SNMP_COUNTER32,
      MAU_MIB_RPMAUJABBERINGSTATEENTERS, "rpMauJabberingStateEnters",
       NULL,
      G_STRUCT_OFFSET(mau_mib_rpMauEntry_t, rpMauJabberingStateEnters),
      0,
      0 },
    { 10, G_SNMP_COUNTER32,
      MAU_MIB_RPMAUFALSECARRIERS, "rpMauFalseCarriers",
       NULL,
      G_STRUCT_OFFSET(mau_mib_rpMauEntry_t, rpMauFalseCarriers),
      0,
      0 },
    { 0, 0, 0, NULL }
};

static guint32 const rpJackEntry_oid[] = {1, 3, 6, 1, 2, 1, 26, 1, 2, 1};

static GSnmpAttribute rpJackEntry_attr[] = {
    { 2, G_SNMP_INTEGER32,
      MAU_MIB_RPJACKTYPE, "rpJackType",
       NULL,
      G_STRUCT_OFFSET(mau_mib_rpJackEntry_t, rpJackType),
      0,
      0 },
    { 0, 0, 0, NULL }
};

static guint32 const ifMauEntry_oid[] = {1, 3, 6, 1, 2, 1, 26, 2, 1, 1};

static GSnmpAttribute ifMauEntry_attr[] = {
    { 3, G_SNMP_OBJECTID,
      MAU_MIB_IFMAUTYPE, "ifMauType",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauEntry_t, ifMauType),
      G_STRUCT_OFFSET(mau_mib_ifMauEntry_t, _ifMauTypeLength),
      0 },
    { 4, G_SNMP_INTEGER32,
      MAU_MIB_IFMAUSTATUS, "ifMauStatus",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauEntry_t, ifMauStatus),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 5, G_SNMP_INTEGER32,
      MAU_MIB_IFMAUMEDIAAVAILABLE, "ifMauMediaAvailable",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauEntry_t, ifMauMediaAvailable),
      0,
      0 },
    { 6, G_SNMP_COUNTER32,
      MAU_MIB_IFMAUMEDIAAVAILABLESTATEEXITS, "ifMauMediaAvailableStateExits",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauEntry_t, ifMauMediaAvailableStateExits),
      0,
      0 },
    { 7, G_SNMP_INTEGER32,
      MAU_MIB_IFMAUJABBERSTATE, "ifMauJabberState",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauEntry_t, ifMauJabberState),
      0,
      0 },
    { 8, G_SNMP_COUNTER32,
      MAU_MIB_IFMAUJABBERINGSTATEENTERS, "ifMauJabberingStateEnters",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauEntry_t, ifMauJabberingStateEnters),
      0,
      0 },
    { 9, G_SNMP_COUNTER32,
      MAU_MIB_IFMAUFALSECARRIERS, "ifMauFalseCarriers",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauEntry_t, ifMauFalseCarriers),
      0,
      0 },
    { 10, G_SNMP_INTEGER32,
      MAU_MIB_IFMAUTYPELIST, "ifMauTypeList",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauEntry_t, ifMauTypeList),
      0,
      0 },
    { 11, G_SNMP_OBJECTID,
      MAU_MIB_IFMAUDEFAULTTYPE, "ifMauDefaultType",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauEntry_t, ifMauDefaultType),
      G_STRUCT_OFFSET(mau_mib_ifMauEntry_t, _ifMauDefaultTypeLength),
      GSNMP_ATTR_FLAG_WRITABLE },
    { 12, G_SNMP_INTEGER32,
      MAU_MIB_IFMAUAUTONEGSUPPORTED, "ifMauAutoNegSupported",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauEntry_t, ifMauAutoNegSupported),
      0,
      0 },
    { 13, G_SNMP_OCTETSTRING,
      MAU_MIB_IFMAUTYPELISTBITS, "ifMauTypeListBits",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauEntry_t, ifMauTypeListBits),
      G_STRUCT_OFFSET(mau_mib_ifMauEntry_t, _ifMauTypeListBitsLength),
      0 },
    { 0, 0, 0, NULL }
};

static guint32 const ifJackEntry_oid[] = {1, 3, 6, 1, 2, 1, 26, 2, 2, 1};

static GSnmpAttribute ifJackEntry_attr[] = {
    { 2, G_SNMP_INTEGER32,
      MAU_MIB_IFJACKTYPE, "ifJackType",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifJackEntry_t, ifJackType),
      0,
      0 },
    { 0, 0, 0, NULL }
};

static guint32 const broadMauBasicEntry_oid[] = {1, 3, 6, 1, 2, 1, 26, 3, 1, 1};

static GSnmpAttribute broadMauBasicEntry_attr[] = {
    { 3, G_SNMP_INTEGER32,
      MAU_MIB_BROADMAUXMTRCVSPLITTYPE, "broadMauXmtRcvSplitType",
       NULL,
      G_STRUCT_OFFSET(mau_mib_broadMauBasicEntry_t, broadMauXmtRcvSplitType),
      0,
      0 },
    { 4, G_SNMP_INTEGER32,
      MAU_MIB_BROADMAUXMTCARRIERFREQ, "broadMauXmtCarrierFreq",
       NULL,
      G_STRUCT_OFFSET(mau_mib_broadMauBasicEntry_t, broadMauXmtCarrierFreq),
      0,
      0 },
    { 5, G_SNMP_INTEGER32,
      MAU_MIB_BROADMAUTRANSLATIONFREQ, "broadMauTranslationFreq",
       NULL,
      G_STRUCT_OFFSET(mau_mib_broadMauBasicEntry_t, broadMauTranslationFreq),
      0,
      0 },
    { 0, 0, 0, NULL }
};

static guint32 const ifMauAutoNegEntry_oid[] = {1, 3, 6, 1, 2, 1, 26, 5, 1, 1};

static GSnmpAttribute ifMauAutoNegEntry_attr[] = {
    { 1, G_SNMP_INTEGER32,
      MAU_MIB_IFMAUAUTONEGADMINSTATUS, "ifMauAutoNegAdminStatus",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauAutoNegEntry_t, ifMauAutoNegAdminStatus),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 2, G_SNMP_INTEGER32,
      MAU_MIB_IFMAUAUTONEGREMOTESIGNALING, "ifMauAutoNegRemoteSignaling",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauAutoNegEntry_t, ifMauAutoNegRemoteSignaling),
      0,
      0 },
    { 4, G_SNMP_INTEGER32,
      MAU_MIB_IFMAUAUTONEGCONFIG, "ifMauAutoNegConfig",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauAutoNegEntry_t, ifMauAutoNegConfig),
      0,
      0 },
    { 5, G_SNMP_INTEGER32,
      MAU_MIB_IFMAUAUTONEGCAPABILITY, "ifMauAutoNegCapability",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauAutoNegEntry_t, ifMauAutoNegCapability),
      0,
      0 },
    { 6, G_SNMP_INTEGER32,
      MAU_MIB_IFMAUAUTONEGCAPADVERTISED, "ifMauAutoNegCapAdvertised",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauAutoNegEntry_t, ifMauAutoNegCapAdvertised),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 7, G_SNMP_INTEGER32,
      MAU_MIB_IFMAUAUTONEGCAPRECEIVED, "ifMauAutoNegCapReceived",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauAutoNegEntry_t, ifMauAutoNegCapReceived),
      0,
      0 },
    { 8, G_SNMP_INTEGER32,
      MAU_MIB_IFMAUAUTONEGRESTART, "ifMauAutoNegRestart",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauAutoNegEntry_t, ifMauAutoNegRestart),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 9, G_SNMP_OCTETSTRING,
      MAU_MIB_IFMAUAUTONEGCAPABILITYBITS, "ifMauAutoNegCapabilityBits",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauAutoNegEntry_t, ifMauAutoNegCapabilityBits),
      G_STRUCT_OFFSET(mau_mib_ifMauAutoNegEntry_t, _ifMauAutoNegCapabilityBitsLength),
      0 },
    { 10, G_SNMP_OCTETSTRING,
      MAU_MIB_IFMAUAUTONEGCAPADVERTISEDBITS, "ifMauAutoNegCapAdvertisedBits",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauAutoNegEntry_t, ifMauAutoNegCapAdvertisedBits),
      G_STRUCT_OFFSET(mau_mib_ifMauAutoNegEntry_t, _ifMauAutoNegCapAdvertisedBitsLength),
      GSNMP_ATTR_FLAG_WRITABLE },
    { 11, G_SNMP_OCTETSTRING,
      MAU_MIB_IFMAUAUTONEGCAPRECEIVEDBITS, "ifMauAutoNegCapReceivedBits",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauAutoNegEntry_t, ifMauAutoNegCapReceivedBits),
      G_STRUCT_OFFSET(mau_mib_ifMauAutoNegEntry_t, _ifMauAutoNegCapReceivedBitsLength),
      0 },
    { 12, G_SNMP_INTEGER32,
      MAU_MIB_IFMAUAUTONEGREMOTEFAULTADVERTISED, "ifMauAutoNegRemoteFaultAdvertised",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauAutoNegEntry_t, ifMauAutoNegRemoteFaultAdvertised),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 13, G_SNMP_INTEGER32,
      MAU_MIB_IFMAUAUTONEGREMOTEFAULTRECEIVED, "ifMauAutoNegRemoteFaultReceived",
       NULL,
      G_STRUCT_OFFSET(mau_mib_ifMauAutoNegEntry_t, ifMauAutoNegRemoteFaultReceived),
      0,
      0 },
    { 0, 0, 0, NULL }
};


mau_mib_rpMauEntry_t *
mau_mib_new_rpMauEntry()
{
    mau_mib_rpMauEntry_t *rpMauEntry;

    rpMauEntry = (mau_mib_rpMauEntry_t *) g_malloc0(sizeof(mau_mib_rpMauEntry_t) + sizeof(gpointer));
    return rpMauEntry;
}

static int
unpack_rpMauEntry(GSnmpVarBind *vb, mau_mib_rpMauEntry_t *rpMauEntry)
{
    guint8 idx = 11;

    if (vb->id_len < idx) return -1;
    rpMauEntry->rpMauGroupIndex = vb->id[idx++];
    if (vb->id_len < idx) return -1;
    rpMauEntry->rpMauPortIndex = vb->id[idx++];
    if (vb->id_len < idx) return -1;
    rpMauEntry->rpMauIndex = vb->id[idx++];
    if (vb->id_len > idx) return -1;
    return 0;
}

static int
pack_rpMauEntry(guint32 *base, gint32 rpMauGroupIndex, gint32 rpMauPortIndex, gint32 rpMauIndex)
{
    guint8 idx = 11;

    base[idx++] = rpMauGroupIndex;
    base[idx++] = rpMauPortIndex;
    base[idx++] = rpMauIndex;
    return idx;
}

static mau_mib_rpMauEntry_t *
assign_rpMauEntry(GSList *vbl)
{
    mau_mib_rpMauEntry_t *rpMauEntry;
    char *p;

    rpMauEntry = mau_mib_new_rpMauEntry();
    if (! rpMauEntry) {
        return NULL;
    }

    p = (char *) rpMauEntry + sizeof(mau_mib_rpMauEntry_t);
    * (GSList **) p = vbl;

    if (unpack_rpMauEntry((GSnmpVarBind *) vbl->data, rpMauEntry) < 0) {
        g_warning("%s: invalid instance identifier", "rpMauEntry");
        g_free(rpMauEntry);
        return NULL;
    }

    gsnmp_attr_assign(vbl, rpMauEntry_oid, sizeof(rpMauEntry_oid)/sizeof(guint32),
                      rpMauEntry_attr, rpMauEntry);

    return rpMauEntry;
}

void
mau_mib_get_rpMauTable(GSnmpSession *s, mau_mib_rpMauEntry_t ***rpMauEntry, gint mask)
{
    GSList *in = NULL, *out = NULL;
    GSList *row;
    int i;
    static guint32 base[] = {1, 3, 6, 1, 2, 1, 26, 1, 1, 1, 0};

    *rpMauEntry = NULL;

    gsnmp_attr_get(s, &in, base, 11, 10, rpMauEntry_attr, mask);

    out = gsnmp_gettable(s, in);
    /* g_snmp_vbl_free(in); */

    if (out) {
        *rpMauEntry = (mau_mib_rpMauEntry_t **) g_malloc0((g_slist_length(out) + 1) * sizeof(mau_mib_rpMauEntry_t *));
        if (! *rpMauEntry) {
            s->error_status = G_SNMP_ERR_INTERNAL;
            g_snmp_vbl_free(out);
            return;
        }
        for (row = out, i = 0; row; row = g_slist_next(row), i++) {
            (*rpMauEntry)[i] = assign_rpMauEntry(row->data);
        }
    }
}

void
mau_mib_get_rpMauEntry(GSnmpSession *s, mau_mib_rpMauEntry_t **rpMauEntry, gint32 rpMauGroupIndex, gint32 rpMauPortIndex, gint32 rpMauIndex, gint mask)
{
    GSList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memset(base, 0, sizeof(base));
    memcpy(base, rpMauEntry_oid, sizeof(rpMauEntry_oid));
    len = pack_rpMauEntry(base, rpMauGroupIndex, rpMauPortIndex, rpMauIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "rpMauEntry");
        s->error_status = G_SNMP_ERR_INTERNAL;
        return;
    }

    *rpMauEntry = NULL;

    gsnmp_attr_get(s, &in, base, len, 10, rpMauEntry_attr, mask);

    out = g_snmp_session_sync_get(s, in);
    g_snmp_vbl_free(in);
    if (out) {
        if (s->error_status != G_SNMP_ERR_NOERROR) {
            g_snmp_vbl_free(out);
            return;
        }
        *rpMauEntry = assign_rpMauEntry(out);
    }
}

void
mau_mib_set_rpMauEntry(GSnmpSession *s, mau_mib_rpMauEntry_t *rpMauEntry, gint mask)
{
    GSList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memset(base, 0, sizeof(base));
    memcpy(base, rpMauEntry_oid, sizeof(rpMauEntry_oid));
    len = pack_rpMauEntry(base, rpMauEntry->rpMauGroupIndex, rpMauEntry->rpMauPortIndex, rpMauEntry->rpMauIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "rpMauEntry");
        s->error_status = G_SNMP_ERR_INTERNAL;
        return;
    }

    gsnmp_attr_set(s, &in, base, len, 10, rpMauEntry_attr, mask, rpMauEntry);

    out = g_snmp_session_sync_set(s, in);
    g_snmp_vbl_free(in);
    if (out) {
        g_snmp_vbl_free(out);
    }
}

void
mau_mib_free_rpMauEntry(mau_mib_rpMauEntry_t *rpMauEntry)
{
    GSList *vbl;
    char *p;

    if (rpMauEntry) {
        p = (char *) rpMauEntry + sizeof(mau_mib_rpMauEntry_t);
        vbl = * (GSList **) p;
        g_snmp_vbl_free(vbl);
        g_free(rpMauEntry);
    }
}

void
mau_mib_free_rpMauTable(mau_mib_rpMauEntry_t **rpMauEntry)
{
    int i;

    if (rpMauEntry) {
        for (i = 0; rpMauEntry[i]; i++) {
            mau_mib_free_rpMauEntry(rpMauEntry[i]);
        }
        g_free(rpMauEntry);
    }
}

mau_mib_rpJackEntry_t *
mau_mib_new_rpJackEntry()
{
    mau_mib_rpJackEntry_t *rpJackEntry;

    rpJackEntry = (mau_mib_rpJackEntry_t *) g_malloc0(sizeof(mau_mib_rpJackEntry_t) + sizeof(gpointer));
    return rpJackEntry;
}

static int
unpack_rpJackEntry(GSnmpVarBind *vb, mau_mib_rpJackEntry_t *rpJackEntry)
{
    guint8 idx = 11;

    if (vb->id_len < idx) return -1;
    rpJackEntry->rpMauGroupIndex = vb->id[idx++];
    if (vb->id_len < idx) return -1;
    rpJackEntry->rpMauPortIndex = vb->id[idx++];
    if (vb->id_len < idx) return -1;
    rpJackEntry->rpMauIndex = vb->id[idx++];
    if (vb->id_len < idx) return -1;
    rpJackEntry->rpJackIndex = vb->id[idx++];
    if (vb->id_len > idx) return -1;
    return 0;
}

static int
pack_rpJackEntry(guint32 *base, gint32 rpMauGroupIndex, gint32 rpMauPortIndex, gint32 rpMauIndex, gint32 rpJackIndex)
{
    guint8 idx = 11;

    base[idx++] = rpMauGroupIndex;
    base[idx++] = rpMauPortIndex;
    base[idx++] = rpMauIndex;
    base[idx++] = rpJackIndex;
    return idx;
}

static mau_mib_rpJackEntry_t *
assign_rpJackEntry(GSList *vbl)
{
    mau_mib_rpJackEntry_t *rpJackEntry;
    char *p;

    rpJackEntry = mau_mib_new_rpJackEntry();
    if (! rpJackEntry) {
        return NULL;
    }

    p = (char *) rpJackEntry + sizeof(mau_mib_rpJackEntry_t);
    * (GSList **) p = vbl;

    if (unpack_rpJackEntry((GSnmpVarBind *) vbl->data, rpJackEntry) < 0) {
        g_warning("%s: invalid instance identifier", "rpJackEntry");
        g_free(rpJackEntry);
        return NULL;
    }

    gsnmp_attr_assign(vbl, rpJackEntry_oid, sizeof(rpJackEntry_oid)/sizeof(guint32),
                      rpJackEntry_attr, rpJackEntry);

    return rpJackEntry;
}

void
mau_mib_get_rpJackTable(GSnmpSession *s, mau_mib_rpJackEntry_t ***rpJackEntry, gint mask)
{
    GSList *in = NULL, *out = NULL;
    GSList *row;
    int i;
    static guint32 base[] = {1, 3, 6, 1, 2, 1, 26, 1, 2, 1, 0};

    *rpJackEntry = NULL;

    gsnmp_attr_get(s, &in, base, 11, 10, rpJackEntry_attr, mask);

    out = gsnmp_gettable(s, in);
    /* g_snmp_vbl_free(in); */

    if (out) {
        *rpJackEntry = (mau_mib_rpJackEntry_t **) g_malloc0((g_slist_length(out) + 1) * sizeof(mau_mib_rpJackEntry_t *));
        if (! *rpJackEntry) {
            s->error_status = G_SNMP_ERR_INTERNAL;
            g_snmp_vbl_free(out);
            return;
        }
        for (row = out, i = 0; row; row = g_slist_next(row), i++) {
            (*rpJackEntry)[i] = assign_rpJackEntry(row->data);
        }
    }
}

void
mau_mib_get_rpJackEntry(GSnmpSession *s, mau_mib_rpJackEntry_t **rpJackEntry, gint32 rpMauGroupIndex, gint32 rpMauPortIndex, gint32 rpMauIndex, gint32 rpJackIndex, gint mask)
{
    GSList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memset(base, 0, sizeof(base));
    memcpy(base, rpJackEntry_oid, sizeof(rpJackEntry_oid));
    len = pack_rpJackEntry(base, rpMauGroupIndex, rpMauPortIndex, rpMauIndex, rpJackIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "rpJackEntry");
        s->error_status = G_SNMP_ERR_INTERNAL;
        return;
    }

    *rpJackEntry = NULL;

    gsnmp_attr_get(s, &in, base, len, 10, rpJackEntry_attr, mask);

    out = g_snmp_session_sync_get(s, in);
    g_snmp_vbl_free(in);
    if (out) {
        if (s->error_status != G_SNMP_ERR_NOERROR) {
            g_snmp_vbl_free(out);
            return;
        }
        *rpJackEntry = assign_rpJackEntry(out);
    }
}

void
mau_mib_free_rpJackEntry(mau_mib_rpJackEntry_t *rpJackEntry)
{
    GSList *vbl;
    char *p;

    if (rpJackEntry) {
        p = (char *) rpJackEntry + sizeof(mau_mib_rpJackEntry_t);
        vbl = * (GSList **) p;
        g_snmp_vbl_free(vbl);
        g_free(rpJackEntry);
    }
}

void
mau_mib_free_rpJackTable(mau_mib_rpJackEntry_t **rpJackEntry)
{
    int i;

    if (rpJackEntry) {
        for (i = 0; rpJackEntry[i]; i++) {
            mau_mib_free_rpJackEntry(rpJackEntry[i]);
        }
        g_free(rpJackEntry);
    }
}

mau_mib_ifMauEntry_t *
mau_mib_new_ifMauEntry()
{
    mau_mib_ifMauEntry_t *ifMauEntry;

    ifMauEntry = (mau_mib_ifMauEntry_t *) g_malloc0(sizeof(mau_mib_ifMauEntry_t) + sizeof(gpointer));
    return ifMauEntry;
}

static int
unpack_ifMauEntry(GSnmpVarBind *vb, mau_mib_ifMauEntry_t *ifMauEntry)
{
    guint8 idx = 11;

    if (vb->id_len < idx) return -1;
    ifMauEntry->ifMauIfIndex = vb->id[idx++];
    if (vb->id_len < idx) return -1;
    ifMauEntry->ifMauIndex = vb->id[idx++];
    if (vb->id_len > idx) return -1;
    return 0;
}

static int
pack_ifMauEntry(guint32 *base, gint32 ifMauIfIndex, gint32 ifMauIndex)
{
    guint8 idx = 11;

    base[idx++] = ifMauIfIndex;
    base[idx++] = ifMauIndex;
    return idx;
}

static mau_mib_ifMauEntry_t *
assign_ifMauEntry(GSList *vbl)
{
    mau_mib_ifMauEntry_t *ifMauEntry;
    char *p;

    ifMauEntry = mau_mib_new_ifMauEntry();
    if (! ifMauEntry) {
        return NULL;
    }

    p = (char *) ifMauEntry + sizeof(mau_mib_ifMauEntry_t);
    * (GSList **) p = vbl;

    if (unpack_ifMauEntry((GSnmpVarBind *) vbl->data, ifMauEntry) < 0) {
        g_warning("%s: invalid instance identifier", "ifMauEntry");
        g_free(ifMauEntry);
        return NULL;
    }

    gsnmp_attr_assign(vbl, ifMauEntry_oid, sizeof(ifMauEntry_oid)/sizeof(guint32),
                      ifMauEntry_attr, ifMauEntry);

    return ifMauEntry;
}

void
mau_mib_get_ifMauTable(GSnmpSession *s, mau_mib_ifMauEntry_t ***ifMauEntry, gint mask)
{
    GSList *in = NULL, *out = NULL;
    GSList *row;
    int i;
    static guint32 base[] = {1, 3, 6, 1, 2, 1, 26, 2, 1, 1, 0};

    *ifMauEntry = NULL;

    gsnmp_attr_get(s, &in, base, 11, 10, ifMauEntry_attr, mask);

    out = gsnmp_gettable(s, in);
    /* g_snmp_vbl_free(in); */

    if (out) {
        *ifMauEntry = (mau_mib_ifMauEntry_t **) g_malloc0((g_slist_length(out) + 1) * sizeof(mau_mib_ifMauEntry_t *));
        if (! *ifMauEntry) {
            s->error_status = G_SNMP_ERR_INTERNAL;
            g_snmp_vbl_free(out);
            return;
        }
        for (row = out, i = 0; row; row = g_slist_next(row), i++) {
            (*ifMauEntry)[i] = assign_ifMauEntry(row->data);
        }
    }
}

void
mau_mib_get_ifMauEntry(GSnmpSession *s, mau_mib_ifMauEntry_t **ifMauEntry, gint32 ifMauIfIndex, gint32 ifMauIndex, gint mask)
{
    GSList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memset(base, 0, sizeof(base));
    memcpy(base, ifMauEntry_oid, sizeof(ifMauEntry_oid));
    len = pack_ifMauEntry(base, ifMauIfIndex, ifMauIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "ifMauEntry");
        s->error_status = G_SNMP_ERR_INTERNAL;
        return;
    }

    *ifMauEntry = NULL;

    gsnmp_attr_get(s, &in, base, len, 10, ifMauEntry_attr, mask);

    out = g_snmp_session_sync_get(s, in);
    g_snmp_vbl_free(in);
    if (out) {
        if (s->error_status != G_SNMP_ERR_NOERROR) {
            g_snmp_vbl_free(out);
            return;
        }
        *ifMauEntry = assign_ifMauEntry(out);
    }
}

void
mau_mib_set_ifMauEntry(GSnmpSession *s, mau_mib_ifMauEntry_t *ifMauEntry, gint mask)
{
    GSList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memset(base, 0, sizeof(base));
    memcpy(base, ifMauEntry_oid, sizeof(ifMauEntry_oid));
    len = pack_ifMauEntry(base, ifMauEntry->ifMauIfIndex, ifMauEntry->ifMauIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "ifMauEntry");
        s->error_status = G_SNMP_ERR_INTERNAL;
        return;
    }

    gsnmp_attr_set(s, &in, base, len, 10, ifMauEntry_attr, mask, ifMauEntry);

    out = g_snmp_session_sync_set(s, in);
    g_snmp_vbl_free(in);
    if (out) {
        g_snmp_vbl_free(out);
    }
}

void
mau_mib_free_ifMauEntry(mau_mib_ifMauEntry_t *ifMauEntry)
{
    GSList *vbl;
    char *p;

    if (ifMauEntry) {
        p = (char *) ifMauEntry + sizeof(mau_mib_ifMauEntry_t);
        vbl = * (GSList **) p;
        g_snmp_vbl_free(vbl);
        g_free(ifMauEntry);
    }
}

void
mau_mib_free_ifMauTable(mau_mib_ifMauEntry_t **ifMauEntry)
{
    int i;

    if (ifMauEntry) {
        for (i = 0; ifMauEntry[i]; i++) {
            mau_mib_free_ifMauEntry(ifMauEntry[i]);
        }
        g_free(ifMauEntry);
    }
}

mau_mib_ifJackEntry_t *
mau_mib_new_ifJackEntry()
{
    mau_mib_ifJackEntry_t *ifJackEntry;

    ifJackEntry = (mau_mib_ifJackEntry_t *) g_malloc0(sizeof(mau_mib_ifJackEntry_t) + sizeof(gpointer));
    return ifJackEntry;
}

static int
unpack_ifJackEntry(GSnmpVarBind *vb, mau_mib_ifJackEntry_t *ifJackEntry)
{
    guint8 idx = 11;

    if (vb->id_len < idx) return -1;
    ifJackEntry->ifMauIfIndex = vb->id[idx++];
    if (vb->id_len < idx) return -1;
    ifJackEntry->ifMauIndex = vb->id[idx++];
    if (vb->id_len < idx) return -1;
    ifJackEntry->ifJackIndex = vb->id[idx++];
    if (vb->id_len > idx) return -1;
    return 0;
}

static int
pack_ifJackEntry(guint32 *base, gint32 ifMauIfIndex, gint32 ifMauIndex, gint32 ifJackIndex)
{
    guint8 idx = 11;

    base[idx++] = ifMauIfIndex;
    base[idx++] = ifMauIndex;
    base[idx++] = ifJackIndex;
    return idx;
}

static mau_mib_ifJackEntry_t *
assign_ifJackEntry(GSList *vbl)
{
    mau_mib_ifJackEntry_t *ifJackEntry;
    char *p;

    ifJackEntry = mau_mib_new_ifJackEntry();
    if (! ifJackEntry) {
        return NULL;
    }

    p = (char *) ifJackEntry + sizeof(mau_mib_ifJackEntry_t);
    * (GSList **) p = vbl;

    if (unpack_ifJackEntry((GSnmpVarBind *) vbl->data, ifJackEntry) < 0) {
        g_warning("%s: invalid instance identifier", "ifJackEntry");
        g_free(ifJackEntry);
        return NULL;
    }

    gsnmp_attr_assign(vbl, ifJackEntry_oid, sizeof(ifJackEntry_oid)/sizeof(guint32),
                      ifJackEntry_attr, ifJackEntry);

    return ifJackEntry;
}

void
mau_mib_get_ifJackTable(GSnmpSession *s, mau_mib_ifJackEntry_t ***ifJackEntry, gint mask)
{
    GSList *in = NULL, *out = NULL;
    GSList *row;
    int i;
    static guint32 base[] = {1, 3, 6, 1, 2, 1, 26, 2, 2, 1, 0};

    *ifJackEntry = NULL;

    gsnmp_attr_get(s, &in, base, 11, 10, ifJackEntry_attr, mask);

    out = gsnmp_gettable(s, in);
    /* g_snmp_vbl_free(in); */

    if (out) {
        *ifJackEntry = (mau_mib_ifJackEntry_t **) g_malloc0((g_slist_length(out) + 1) * sizeof(mau_mib_ifJackEntry_t *));
        if (! *ifJackEntry) {
            s->error_status = G_SNMP_ERR_INTERNAL;
            g_snmp_vbl_free(out);
            return;
        }
        for (row = out, i = 0; row; row = g_slist_next(row), i++) {
            (*ifJackEntry)[i] = assign_ifJackEntry(row->data);
        }
    }
}

void
mau_mib_get_ifJackEntry(GSnmpSession *s, mau_mib_ifJackEntry_t **ifJackEntry, gint32 ifMauIfIndex, gint32 ifMauIndex, gint32 ifJackIndex, gint mask)
{
    GSList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memset(base, 0, sizeof(base));
    memcpy(base, ifJackEntry_oid, sizeof(ifJackEntry_oid));
    len = pack_ifJackEntry(base, ifMauIfIndex, ifMauIndex, ifJackIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "ifJackEntry");
        s->error_status = G_SNMP_ERR_INTERNAL;
        return;
    }

    *ifJackEntry = NULL;

    gsnmp_attr_get(s, &in, base, len, 10, ifJackEntry_attr, mask);

    out = g_snmp_session_sync_get(s, in);
    g_snmp_vbl_free(in);
    if (out) {
        if (s->error_status != G_SNMP_ERR_NOERROR) {
            g_snmp_vbl_free(out);
            return;
        }
        *ifJackEntry = assign_ifJackEntry(out);
    }
}

void
mau_mib_free_ifJackEntry(mau_mib_ifJackEntry_t *ifJackEntry)
{
    GSList *vbl;
    char *p;

    if (ifJackEntry) {
        p = (char *) ifJackEntry + sizeof(mau_mib_ifJackEntry_t);
        vbl = * (GSList **) p;
        g_snmp_vbl_free(vbl);
        g_free(ifJackEntry);
    }
}

void
mau_mib_free_ifJackTable(mau_mib_ifJackEntry_t **ifJackEntry)
{
    int i;

    if (ifJackEntry) {
        for (i = 0; ifJackEntry[i]; i++) {
            mau_mib_free_ifJackEntry(ifJackEntry[i]);
        }
        g_free(ifJackEntry);
    }
}

mau_mib_broadMauBasicEntry_t *
mau_mib_new_broadMauBasicEntry()
{
    mau_mib_broadMauBasicEntry_t *broadMauBasicEntry;

    broadMauBasicEntry = (mau_mib_broadMauBasicEntry_t *) g_malloc0(sizeof(mau_mib_broadMauBasicEntry_t) + sizeof(gpointer));
    return broadMauBasicEntry;
}

static int
unpack_broadMauBasicEntry(GSnmpVarBind *vb, mau_mib_broadMauBasicEntry_t *broadMauBasicEntry)
{
    guint8 idx = 11;

    if (vb->id_len < idx) return -1;
    broadMauBasicEntry->broadMauIfIndex = vb->id[idx++];
    if (vb->id_len < idx) return -1;
    broadMauBasicEntry->broadMauIndex = vb->id[idx++];
    if (vb->id_len > idx) return -1;
    return 0;
}

static int
pack_broadMauBasicEntry(guint32 *base, gint32 broadMauIfIndex, gint32 broadMauIndex)
{
    guint8 idx = 11;

    base[idx++] = broadMauIfIndex;
    base[idx++] = broadMauIndex;
    return idx;
}

static mau_mib_broadMauBasicEntry_t *
assign_broadMauBasicEntry(GSList *vbl)
{
    mau_mib_broadMauBasicEntry_t *broadMauBasicEntry;
    char *p;

    broadMauBasicEntry = mau_mib_new_broadMauBasicEntry();
    if (! broadMauBasicEntry) {
        return NULL;
    }

    p = (char *) broadMauBasicEntry + sizeof(mau_mib_broadMauBasicEntry_t);
    * (GSList **) p = vbl;

    if (unpack_broadMauBasicEntry((GSnmpVarBind *) vbl->data, broadMauBasicEntry) < 0) {
        g_warning("%s: invalid instance identifier", "broadMauBasicEntry");
        g_free(broadMauBasicEntry);
        return NULL;
    }

    gsnmp_attr_assign(vbl, broadMauBasicEntry_oid, sizeof(broadMauBasicEntry_oid)/sizeof(guint32),
                      broadMauBasicEntry_attr, broadMauBasicEntry);

    return broadMauBasicEntry;
}

void
mau_mib_get_broadMauBasicTable(GSnmpSession *s, mau_mib_broadMauBasicEntry_t ***broadMauBasicEntry, gint mask)
{
    GSList *in = NULL, *out = NULL;
    GSList *row;
    int i;
    static guint32 base[] = {1, 3, 6, 1, 2, 1, 26, 3, 1, 1, 0};

    *broadMauBasicEntry = NULL;

    gsnmp_attr_get(s, &in, base, 11, 10, broadMauBasicEntry_attr, mask);

    out = gsnmp_gettable(s, in);
    /* g_snmp_vbl_free(in); */

    if (out) {
        *broadMauBasicEntry = (mau_mib_broadMauBasicEntry_t **) g_malloc0((g_slist_length(out) + 1) * sizeof(mau_mib_broadMauBasicEntry_t *));
        if (! *broadMauBasicEntry) {
            s->error_status = G_SNMP_ERR_INTERNAL;
            g_snmp_vbl_free(out);
            return;
        }
        for (row = out, i = 0; row; row = g_slist_next(row), i++) {
            (*broadMauBasicEntry)[i] = assign_broadMauBasicEntry(row->data);
        }
    }
}

void
mau_mib_get_broadMauBasicEntry(GSnmpSession *s, mau_mib_broadMauBasicEntry_t **broadMauBasicEntry, gint32 broadMauIfIndex, gint32 broadMauIndex, gint mask)
{
    GSList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memset(base, 0, sizeof(base));
    memcpy(base, broadMauBasicEntry_oid, sizeof(broadMauBasicEntry_oid));
    len = pack_broadMauBasicEntry(base, broadMauIfIndex, broadMauIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "broadMauBasicEntry");
        s->error_status = G_SNMP_ERR_INTERNAL;
        return;
    }

    *broadMauBasicEntry = NULL;

    gsnmp_attr_get(s, &in, base, len, 10, broadMauBasicEntry_attr, mask);

    out = g_snmp_session_sync_get(s, in);
    g_snmp_vbl_free(in);
    if (out) {
        if (s->error_status != G_SNMP_ERR_NOERROR) {
            g_snmp_vbl_free(out);
            return;
        }
        *broadMauBasicEntry = assign_broadMauBasicEntry(out);
    }
}

void
mau_mib_free_broadMauBasicEntry(mau_mib_broadMauBasicEntry_t *broadMauBasicEntry)
{
    GSList *vbl;
    char *p;

    if (broadMauBasicEntry) {
        p = (char *) broadMauBasicEntry + sizeof(mau_mib_broadMauBasicEntry_t);
        vbl = * (GSList **) p;
        g_snmp_vbl_free(vbl);
        g_free(broadMauBasicEntry);
    }
}

void
mau_mib_free_broadMauBasicTable(mau_mib_broadMauBasicEntry_t **broadMauBasicEntry)
{
    int i;

    if (broadMauBasicEntry) {
        for (i = 0; broadMauBasicEntry[i]; i++) {
            mau_mib_free_broadMauBasicEntry(broadMauBasicEntry[i]);
        }
        g_free(broadMauBasicEntry);
    }
}

mau_mib_ifMauAutoNegEntry_t *
mau_mib_new_ifMauAutoNegEntry()
{
    mau_mib_ifMauAutoNegEntry_t *ifMauAutoNegEntry;

    ifMauAutoNegEntry = (mau_mib_ifMauAutoNegEntry_t *) g_malloc0(sizeof(mau_mib_ifMauAutoNegEntry_t) + sizeof(gpointer));
    return ifMauAutoNegEntry;
}

static int
unpack_ifMauAutoNegEntry(GSnmpVarBind *vb, mau_mib_ifMauAutoNegEntry_t *ifMauAutoNegEntry)
{
    guint8 idx = 11;

    if (vb->id_len < idx) return -1;
    ifMauAutoNegEntry->ifMauIfIndex = vb->id[idx++];
    if (vb->id_len < idx) return -1;
    ifMauAutoNegEntry->ifMauIndex = vb->id[idx++];
    if (vb->id_len > idx) return -1;
    return 0;
}

static int
pack_ifMauAutoNegEntry(guint32 *base, gint32 ifMauIfIndex, gint32 ifMauIndex)
{
    guint8 idx = 11;

    base[idx++] = ifMauIfIndex;
    base[idx++] = ifMauIndex;
    return idx;
}

static mau_mib_ifMauAutoNegEntry_t *
assign_ifMauAutoNegEntry(GSList *vbl)
{
    mau_mib_ifMauAutoNegEntry_t *ifMauAutoNegEntry;
    char *p;

    ifMauAutoNegEntry = mau_mib_new_ifMauAutoNegEntry();
    if (! ifMauAutoNegEntry) {
        return NULL;
    }

    p = (char *) ifMauAutoNegEntry + sizeof(mau_mib_ifMauAutoNegEntry_t);
    * (GSList **) p = vbl;

    if (unpack_ifMauAutoNegEntry((GSnmpVarBind *) vbl->data, ifMauAutoNegEntry) < 0) {
        g_warning("%s: invalid instance identifier", "ifMauAutoNegEntry");
        g_free(ifMauAutoNegEntry);
        return NULL;
    }

    gsnmp_attr_assign(vbl, ifMauAutoNegEntry_oid, sizeof(ifMauAutoNegEntry_oid)/sizeof(guint32),
                      ifMauAutoNegEntry_attr, ifMauAutoNegEntry);

    return ifMauAutoNegEntry;
}

void
mau_mib_get_ifMauAutoNegTable(GSnmpSession *s, mau_mib_ifMauAutoNegEntry_t ***ifMauAutoNegEntry, gint mask)
{
    GSList *in = NULL, *out = NULL;
    GSList *row;
    int i;
    static guint32 base[] = {1, 3, 6, 1, 2, 1, 26, 5, 1, 1, 0};

    *ifMauAutoNegEntry = NULL;

    gsnmp_attr_get(s, &in, base, 11, 10, ifMauAutoNegEntry_attr, mask);

    out = gsnmp_gettable(s, in);
    /* g_snmp_vbl_free(in); */

    if (out) {
        *ifMauAutoNegEntry = (mau_mib_ifMauAutoNegEntry_t **) g_malloc0((g_slist_length(out) + 1) * sizeof(mau_mib_ifMauAutoNegEntry_t *));
        if (! *ifMauAutoNegEntry) {
            s->error_status = G_SNMP_ERR_INTERNAL;
            g_snmp_vbl_free(out);
            return;
        }
        for (row = out, i = 0; row; row = g_slist_next(row), i++) {
            (*ifMauAutoNegEntry)[i] = assign_ifMauAutoNegEntry(row->data);
        }
    }
}

void
mau_mib_get_ifMauAutoNegEntry(GSnmpSession *s, mau_mib_ifMauAutoNegEntry_t **ifMauAutoNegEntry, gint32 ifMauIfIndex, gint32 ifMauIndex, gint mask)
{
    GSList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memset(base, 0, sizeof(base));
    memcpy(base, ifMauAutoNegEntry_oid, sizeof(ifMauAutoNegEntry_oid));
    len = pack_ifMauAutoNegEntry(base, ifMauIfIndex, ifMauIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "ifMauAutoNegEntry");
        s->error_status = G_SNMP_ERR_INTERNAL;
        return;
    }

    *ifMauAutoNegEntry = NULL;

    gsnmp_attr_get(s, &in, base, len, 10, ifMauAutoNegEntry_attr, mask);

    out = g_snmp_session_sync_get(s, in);
    g_snmp_vbl_free(in);
    if (out) {
        if (s->error_status != G_SNMP_ERR_NOERROR) {
            g_snmp_vbl_free(out);
            return;
        }
        *ifMauAutoNegEntry = assign_ifMauAutoNegEntry(out);
    }
}

void
mau_mib_set_ifMauAutoNegEntry(GSnmpSession *s, mau_mib_ifMauAutoNegEntry_t *ifMauAutoNegEntry, gint mask)
{
    GSList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memset(base, 0, sizeof(base));
    memcpy(base, ifMauAutoNegEntry_oid, sizeof(ifMauAutoNegEntry_oid));
    len = pack_ifMauAutoNegEntry(base, ifMauAutoNegEntry->ifMauIfIndex, ifMauAutoNegEntry->ifMauIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "ifMauAutoNegEntry");
        s->error_status = G_SNMP_ERR_INTERNAL;
        return;
    }

    gsnmp_attr_set(s, &in, base, len, 10, ifMauAutoNegEntry_attr, mask, ifMauAutoNegEntry);

    out = g_snmp_session_sync_set(s, in);
    g_snmp_vbl_free(in);
    if (out) {
        g_snmp_vbl_free(out);
    }
}

void
mau_mib_free_ifMauAutoNegEntry(mau_mib_ifMauAutoNegEntry_t *ifMauAutoNegEntry)
{
    GSList *vbl;
    char *p;

    if (ifMauAutoNegEntry) {
        p = (char *) ifMauAutoNegEntry + sizeof(mau_mib_ifMauAutoNegEntry_t);
        vbl = * (GSList **) p;
        g_snmp_vbl_free(vbl);
        g_free(ifMauAutoNegEntry);
    }
}

void
mau_mib_free_ifMauAutoNegTable(mau_mib_ifMauAutoNegEntry_t **ifMauAutoNegEntry)
{
    int i;

    if (ifMauAutoNegEntry) {
        for (i = 0; ifMauAutoNegEntry[i]; i++) {
            mau_mib_free_ifMauAutoNegEntry(ifMauAutoNegEntry[i]);
        }
        g_free(ifMauAutoNegEntry);
    }
}


