/*							-- DO NOT EDIT --
 * Generated by smidump version 0.4.3:
 *   smidump -f scli UDP-MIB
 *
 * Derived from UDP-MIB:
 *   The MIB module for managing UDP implementations.
 *   Copyright (C) The Internet Society (2005).  This
 *   version of this MIB module is part of RFC 4113;
 *   see the RFC itself for full legal notices.
 *
 * Revision 2005-05-20 00:00:
 *   IP version neutral revision, incorporating the
 *   following revisions:
 *   
 *   - Added udpHCInDatagrams and udpHCOutDatagrams in order
 *     to provide high-capacity counters for fast networks.
 *   - Added text to the descriptions of all counter objects
 *     to indicate how discontinuities are detected.
 *   - Deprecated the IPv4-specific udpTable and replaced it
 *     with the version neutral udpEndpointTable.  This
 *     table includes support for connected UDP endpoints
 *     and support for identification of the operating
 *     system process associated with a UDP endpoint.
 *   - Deprecated the udpGroup and replaced it with object
 *     groups representing the current set of objects.
 *   - Deprecated udpMIBCompliance and replaced it with
 *     udpMIBCompliance2, which includes the compliance
 *     information for the new object groups.
 *   
 *   This version published as RFC 4113.
 *
 * Revision 1994-11-01 00:00:
 *   Initial SMIv2 version, published as RFC 2013.
 *
 * Revision 1991-03-31 00:00:
 *   The initial revision of this MIB module was part of
 *   MIB-II, published as RFC 1213.
 *
 * $Id: udp-mib.c 1788 2006-02-21 20:47:18Z schoenw $
 */

#include "udp-mib.h"

static guint16 udpLocalAddress_constraints[] = {4U, 4U, 0, 0};
static gint32 udpLocalPort_constraints[] = {0L, 65535L, 0, 0};


static guint32 const udp_oid[] = {1, 3, 6, 1, 2, 1, 7};

static GNetSnmpAttribute udp_attr[] = {
    { 1, GNET_SNMP_VARBIND_TYPE_COUNTER32,
      UDP_MIB_UDPINDATAGRAMS, "udpInDatagrams",
       NULL,
      G_STRUCT_OFFSET(udp_mib_udp_t, udpInDatagrams),
      0,
      0 },
    { 2, GNET_SNMP_VARBIND_TYPE_COUNTER32,
      UDP_MIB_UDPNOPORTS, "udpNoPorts",
       NULL,
      G_STRUCT_OFFSET(udp_mib_udp_t, udpNoPorts),
      0,
      0 },
    { 3, GNET_SNMP_VARBIND_TYPE_COUNTER32,
      UDP_MIB_UDPINERRORS, "udpInErrors",
       NULL,
      G_STRUCT_OFFSET(udp_mib_udp_t, udpInErrors),
      0,
      0 },
    { 4, GNET_SNMP_VARBIND_TYPE_COUNTER32,
      UDP_MIB_UDPOUTDATAGRAMS, "udpOutDatagrams",
       NULL,
      G_STRUCT_OFFSET(udp_mib_udp_t, udpOutDatagrams),
      0,
      0 },
    { 8, GNET_SNMP_VARBIND_TYPE_COUNTER64,
      UDP_MIB_UDPHCINDATAGRAMS, "udpHCInDatagrams",
       NULL,
      G_STRUCT_OFFSET(udp_mib_udp_t, udpHCInDatagrams),
      0,
      0 },
    { 9, GNET_SNMP_VARBIND_TYPE_COUNTER64,
      UDP_MIB_UDPHCOUTDATAGRAMS, "udpHCOutDatagrams",
       NULL,
      G_STRUCT_OFFSET(udp_mib_udp_t, udpHCOutDatagrams),
      0,
      0 },
    { 0, 0, 0, NULL }
};

static guint32 const udpEntry_oid[] = {1, 3, 6, 1, 2, 1, 7, 5, 1};

static GNetSnmpAttribute udpEntry_attr[] = {
    { 1, GNET_SNMP_VARBIND_TYPE_IPADDRESS,
      UDP_MIB_UDPLOCALADDRESS, "udpLocalAddress",
       udpLocalAddress_constraints,
      -1,
      0,
      0 },
    { 2, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      UDP_MIB_UDPLOCALPORT, "udpLocalPort",
       udpLocalPort_constraints,
      -1,
      0,
      0 },
    { 0, 0, 0, NULL }
};

static guint32 const udpEndpointEntry_oid[] = {1, 3, 6, 1, 2, 1, 7, 7, 1};

static GNetSnmpAttribute udpEndpointEntry_attr[] = {
    { 8, GNET_SNMP_VARBIND_TYPE_UNSIGNED32,
      UDP_MIB_UDPENDPOINTPROCESS, "udpEndpointProcess",
       NULL,
      G_STRUCT_OFFSET(udp_mib_udpEndpointEntry_t, udpEndpointProcess),
      0,
      0 },
    { 0, 0, 0, NULL }
};


udp_mib_udp_t *
udp_mib_new_udp()
{
    udp_mib_udp_t *udp;

    udp = (udp_mib_udp_t *) g_malloc0(sizeof(udp_mib_udp_t) + sizeof(gpointer));
    return udp;
}

static inline udp_mib_udp_t *
assign_udp(GList *vbl)
{
    udp_mib_udp_t *udp;
    char *p;

    udp = udp_mib_new_udp();
    p = (char *) udp + sizeof(udp_mib_udp_t);
    * (GList **) p = vbl;

    gnet_snmp_attr_assign(vbl, udp_oid, G_N_ELEMENTS(udp_oid),
                      udp_attr, udp);

    return udp;
}

void
udp_mib_get_udp(GNetSnmp *s, udp_mib_udp_t **udp, gint64 mask)
{
    GList *in = NULL, *out = NULL;
    static guint32 base[] = {1, 3, 6, 1, 2, 1, 7, 0};

    *udp = NULL;

    gnet_snmp_attr_get(s, &in, base, 8, 7, udp_attr, mask);

    out = gnet_snmp_sync_getnext(s, in);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *udp = assign_udp(out);
    }
}

void
udp_mib_free_udp(udp_mib_udp_t *udp)
{
    GList *vbl;
    char *p;

    if (udp) {
        p = (char *) udp + sizeof(udp_mib_udp_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(udp);
    }
}

udp_mib_udpEntry_t *
udp_mib_new_udpEntry()
{
    udp_mib_udpEntry_t *udpEntry;

    udpEntry = (udp_mib_udpEntry_t *) g_malloc0(sizeof(udp_mib_udpEntry_t) + sizeof(gpointer));
    return udpEntry;
}

static inline int
unpack_udpEntry(GNetSnmpVarBind *vb, udp_mib_udpEntry_t *udpEntry)
{
    guint8 idx = 10;
    guint16 i, len;

    len = 4;
    if (vb->oid_len < idx + len) return -1;
    for (i = 0; i < len; i++) {
        udpEntry->udpLocalAddress[i] = vb->oid[idx++];
    }
    if (vb->oid_len < idx) return -1;
    udpEntry->udpLocalPort = vb->oid[idx++];
    if ((udpEntry->udpLocalPort < 0 || udpEntry->udpLocalPort > 65535)) {
         return -1;
    }
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_udpEntry(guint32 *base, guchar *udpLocalAddress, gint32 udpLocalPort)
{
    guint8 idx = 10;
    guint16 i, len;

    len = 4;
    if (len != 4) return -1;
    for (i = 0; i < len; i++) {
        base[idx++] = udpLocalAddress[i];
        if (idx >= 128) return -1;
    }
    base[idx++] = udpLocalPort;
    return idx;
}

static inline udp_mib_udpEntry_t *
assign_udpEntry(GList *vbl)
{
    udp_mib_udpEntry_t *udpEntry;
    char *p;

    udpEntry = udp_mib_new_udpEntry();
    p = (char *) udpEntry + sizeof(udp_mib_udpEntry_t);
    * (GList **) p = vbl;

    if (unpack_udpEntry((GNetSnmpVarBind *) vbl->data, udpEntry) < 0) {
        g_warning("%s: invalid instance identifier", "udpEntry");
        g_free(udpEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, udpEntry_oid, G_N_ELEMENTS(udpEntry_oid),
                      udpEntry_attr, udpEntry);

    return udpEntry;
}

void
udp_mib_get_udpTable(GNetSnmp *s, udp_mib_udpEntry_t ***udpEntry, gint64 mask)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 base[] = {1, 3, 6, 1, 2, 1, 7, 5, 1, 0};

    *udpEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, 10, 9, udpEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *udpEntry = (udp_mib_udpEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(udp_mib_udpEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*udpEntry)[i] = assign_udpEntry(row->data);
        }
    }
}

void
udp_mib_get_udpEntry(GNetSnmp *s, udp_mib_udpEntry_t **udpEntry, guchar *udpLocalAddress, gint32 udpLocalPort, gint64 mask)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, udpEntry_oid, sizeof(udpEntry_oid));
    len = pack_udpEntry(base, udpLocalAddress, udpLocalPort);
    if (len < 0) {
        g_warning("%s: invalid index values", "udpEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *udpEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 9, udpEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *udpEntry = assign_udpEntry(out);
    }
}

void
udp_mib_free_udpEntry(udp_mib_udpEntry_t *udpEntry)
{
    GList *vbl;
    char *p;

    if (udpEntry) {
        p = (char *) udpEntry + sizeof(udp_mib_udpEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(udpEntry);
    }
}

void
udp_mib_free_udpTable(udp_mib_udpEntry_t **udpEntry)
{
    int i;

    if (udpEntry) {
        for (i = 0; udpEntry[i]; i++) {
            udp_mib_free_udpEntry(udpEntry[i]);
        }
        g_free(udpEntry);
    }
}

udp_mib_udpEndpointEntry_t *
udp_mib_new_udpEndpointEntry()
{
    udp_mib_udpEndpointEntry_t *udpEndpointEntry;

    udpEndpointEntry = (udp_mib_udpEndpointEntry_t *) g_malloc0(sizeof(udp_mib_udpEndpointEntry_t) + sizeof(gpointer));
    return udpEndpointEntry;
}

static inline int
unpack_udpEndpointEntry(GNetSnmpVarBind *vb, udp_mib_udpEndpointEntry_t *udpEndpointEntry)
{
    guint8 idx = 10;
    guint16 i, len;

    if (vb->oid_len < idx) return -1;
    udpEndpointEntry->udpEndpointLocalAddressType = vb->oid[idx++];
    if (vb->oid_len < idx) return -1;
    len = vb->oid[idx++];
    if (len > 118) return -1;
    if (vb->oid_len < idx + len) return -1;
    for (i = 0; i < len; i++) {
        udpEndpointEntry->udpEndpointLocalAddress[i] = vb->oid[idx++];
    }
    udpEndpointEntry->_udpEndpointLocalAddressLength = len;
    if (vb->oid_len < idx) return -1;
    udpEndpointEntry->udpEndpointLocalPort = vb->oid[idx++];
     if ((udpEndpointEntry->udpEndpointLocalPort > 65535)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    udpEndpointEntry->udpEndpointRemoteAddressType = vb->oid[idx++];
    if (vb->oid_len < idx) return -1;
    len = vb->oid[idx++];
    if (len > 118) return -1;
    if (vb->oid_len < idx + len) return -1;
    for (i = 0; i < len; i++) {
        udpEndpointEntry->udpEndpointRemoteAddress[i] = vb->oid[idx++];
    }
    udpEndpointEntry->_udpEndpointRemoteAddressLength = len;
    if (vb->oid_len < idx) return -1;
    udpEndpointEntry->udpEndpointRemotePort = vb->oid[idx++];
     if ((udpEndpointEntry->udpEndpointRemotePort > 65535)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    udpEndpointEntry->udpEndpointInstance = vb->oid[idx++];
     if ((udpEndpointEntry->udpEndpointInstance < 1)) {
         return -1;
    }
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_udpEndpointEntry(guint32 *base, gint32 udpEndpointLocalAddressType, guchar *udpEndpointLocalAddress, guint16 _udpEndpointLocalAddressLength, guint32 udpEndpointLocalPort, gint32 udpEndpointRemoteAddressType, guchar *udpEndpointRemoteAddress, guint16 _udpEndpointRemoteAddressLength, guint32 udpEndpointRemotePort, guint32 udpEndpointInstance)
{
    guint8 idx = 10;
    guint16 i, len;

    base[idx++] = udpEndpointLocalAddressType;
    len = _udpEndpointLocalAddressLength;
    base[idx++] = len;
    if (len > 118) return -1;
    for (i = 0; i < len; i++) {
        base[idx++] = udpEndpointLocalAddress[i];
        if (idx >= 128) return -1;
    }
    base[idx++] = udpEndpointLocalPort;
    base[idx++] = udpEndpointRemoteAddressType;
    len = _udpEndpointRemoteAddressLength;
    base[idx++] = len;
    if (len > 118) return -1;
    for (i = 0; i < len; i++) {
        base[idx++] = udpEndpointRemoteAddress[i];
        if (idx >= 128) return -1;
    }
    base[idx++] = udpEndpointRemotePort;
    base[idx++] = udpEndpointInstance;
    return idx;
}

static inline udp_mib_udpEndpointEntry_t *
assign_udpEndpointEntry(GList *vbl)
{
    udp_mib_udpEndpointEntry_t *udpEndpointEntry;
    char *p;

    udpEndpointEntry = udp_mib_new_udpEndpointEntry();
    p = (char *) udpEndpointEntry + sizeof(udp_mib_udpEndpointEntry_t);
    * (GList **) p = vbl;

    if (unpack_udpEndpointEntry((GNetSnmpVarBind *) vbl->data, udpEndpointEntry) < 0) {
        g_warning("%s: invalid instance identifier", "udpEndpointEntry");
        g_free(udpEndpointEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, udpEndpointEntry_oid, G_N_ELEMENTS(udpEndpointEntry_oid),
                      udpEndpointEntry_attr, udpEndpointEntry);

    return udpEndpointEntry;
}

void
udp_mib_get_udpEndpointTable(GNetSnmp *s, udp_mib_udpEndpointEntry_t ***udpEndpointEntry, gint64 mask)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 base[] = {1, 3, 6, 1, 2, 1, 7, 7, 1, 0};

    *udpEndpointEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, 10, 9, udpEndpointEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *udpEndpointEntry = (udp_mib_udpEndpointEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(udp_mib_udpEndpointEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*udpEndpointEntry)[i] = assign_udpEndpointEntry(row->data);
        }
    }
}

void
udp_mib_get_udpEndpointEntry(GNetSnmp *s, udp_mib_udpEndpointEntry_t **udpEndpointEntry, gint32 udpEndpointLocalAddressType, guchar *udpEndpointLocalAddress, guint16 _udpEndpointLocalAddressLength, guint32 udpEndpointLocalPort, gint32 udpEndpointRemoteAddressType, guchar *udpEndpointRemoteAddress, guint16 _udpEndpointRemoteAddressLength, guint32 udpEndpointRemotePort, guint32 udpEndpointInstance, gint64 mask)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, udpEndpointEntry_oid, sizeof(udpEndpointEntry_oid));
    len = pack_udpEndpointEntry(base, udpEndpointLocalAddressType, udpEndpointLocalAddress, _udpEndpointLocalAddressLength, udpEndpointLocalPort, udpEndpointRemoteAddressType, udpEndpointRemoteAddress, _udpEndpointRemoteAddressLength, udpEndpointRemotePort, udpEndpointInstance);
    if (len < 0) {
        g_warning("%s: invalid index values", "udpEndpointEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *udpEndpointEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 9, udpEndpointEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *udpEndpointEntry = assign_udpEndpointEntry(out);
    }
}

void
udp_mib_free_udpEndpointEntry(udp_mib_udpEndpointEntry_t *udpEndpointEntry)
{
    GList *vbl;
    char *p;

    if (udpEndpointEntry) {
        p = (char *) udpEndpointEntry + sizeof(udp_mib_udpEndpointEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(udpEndpointEntry);
    }
}

void
udp_mib_free_udpEndpointTable(udp_mib_udpEndpointEntry_t **udpEndpointEntry)
{
    int i;

    if (udpEndpointEntry) {
        for (i = 0; udpEndpointEntry[i]; i++) {
            udp_mib_free_udpEndpointEntry(udpEndpointEntry[i]);
        }
        g_free(udpEndpointEntry);
    }
}


