/*							-- DO NOT EDIT --
 * Generated by smidump version 0.4.8:
 *   smidump -f scli \
 *     --scli-exclude='ipForwardEntry' IP-FORWARD-MIB
 *
 * Derived from IP-FORWARD-MIB:
 *   The MIB module for the management of CIDR multipath IP
 *   Routes.
 *   
 *   Copyright (C) The Internet Society (2006).  This version
 *   of this MIB module is a part of RFC 4292; see the RFC
 *   itself for full legal notices.
 *
 * Revision 2006-02-01 00:00:
 *   IPv4/v6 version-independent revision.  Minimal changes
 *   were made to the original RFC 2096 MIB to allow easy
 *   upgrade of existing IPv4 implementations to the
 *   version-independent MIB.  These changes include:
 *   
 *   Adding inetCidrRouteDiscards as a replacement for the
 *   deprecated ipRoutingDiscards and ipv6DiscardedRoutes
 *   objects.
 *   
 *   Adding a new conformance statement to support the
 *   implementation of the IP Forwarding MIB in a
 *   read-only mode.
 *   
 *   
 *   
 *   
 *   The inetCidrRouteTable replaces the IPv4-specific
 *   ipCidrRouteTable, its related objects, and related
 *   conformance statements.
 *   
 *   Published as RFC 4292.
 *
 * Revision 1996-09-19 00:00:
 *   Revised to support CIDR routes.
 *   Published as RFC 2096.
 *
 * Revision 1992-07-02 21:56:
 *   Initial version, published as RFC 1354.
 *
 * $Id: ip-forward-mib.c 3180 2009-07-29 22:36:13Z schoenw $
 */

#include "ip-forward-mib.h"

GNetSnmpEnum const ip_forward_mib_enums_ipCidrRouteType[] = {
    { IP_FORWARD_MIB_IPCIDRROUTETYPE_OTHER,  "other" },
    { IP_FORWARD_MIB_IPCIDRROUTETYPE_REJECT, "reject" },
    { IP_FORWARD_MIB_IPCIDRROUTETYPE_LOCAL,  "local" },
    { IP_FORWARD_MIB_IPCIDRROUTETYPE_REMOTE, "remote" },
    { 0, NULL }
};

GNetSnmpEnum const ip_forward_mib_enums_ipCidrRouteProto[] = {
    { IP_FORWARD_MIB_IPCIDRROUTEPROTO_OTHER,      "other" },
    { IP_FORWARD_MIB_IPCIDRROUTEPROTO_LOCAL,      "local" },
    { IP_FORWARD_MIB_IPCIDRROUTEPROTO_NETMGMT,    "netmgmt" },
    { IP_FORWARD_MIB_IPCIDRROUTEPROTO_ICMP,       "icmp" },
    { IP_FORWARD_MIB_IPCIDRROUTEPROTO_EGP,        "egp" },
    { IP_FORWARD_MIB_IPCIDRROUTEPROTO_GGP,        "ggp" },
    { IP_FORWARD_MIB_IPCIDRROUTEPROTO_HELLO,      "hello" },
    { IP_FORWARD_MIB_IPCIDRROUTEPROTO_RIP,        "rip" },
    { IP_FORWARD_MIB_IPCIDRROUTEPROTO_ISIS,       "isIs" },
    { IP_FORWARD_MIB_IPCIDRROUTEPROTO_ESIS,       "esIs" },
    { IP_FORWARD_MIB_IPCIDRROUTEPROTO_CISCOIGRP,  "ciscoIgrp" },
    { IP_FORWARD_MIB_IPCIDRROUTEPROTO_BBNSPFIGP,  "bbnSpfIgp" },
    { IP_FORWARD_MIB_IPCIDRROUTEPROTO_OSPF,       "ospf" },
    { IP_FORWARD_MIB_IPCIDRROUTEPROTO_BGP,        "bgp" },
    { IP_FORWARD_MIB_IPCIDRROUTEPROTO_IDPR,       "idpr" },
    { IP_FORWARD_MIB_IPCIDRROUTEPROTO_CISCOEIGRP, "ciscoEigrp" },
    { 0, NULL }
};

GNetSnmpEnum const ip_forward_mib_enums_inetCidrRouteType[] = {
    { IP_FORWARD_MIB_INETCIDRROUTETYPE_OTHER,     "other" },
    { IP_FORWARD_MIB_INETCIDRROUTETYPE_REJECT,    "reject" },
    { IP_FORWARD_MIB_INETCIDRROUTETYPE_LOCAL,     "local" },
    { IP_FORWARD_MIB_INETCIDRROUTETYPE_REMOTE,    "remote" },
    { IP_FORWARD_MIB_INETCIDRROUTETYPE_BLACKHOLE, "blackhole" },
    { 0, NULL }
};


static gint32 inetCidrRouteIfIndex_constraints[] = {0L, 2147483647L, 0, 0};


static guint32 const ipForward_oid[] = {1, 3, 6, 1, 2, 1, 4, 24};

static GNetSnmpAttribute ipForward_attr[] = {
    { 1, GNET_SNMP_VARBIND_TYPE_UNSIGNED32,
      IP_FORWARD_MIB_IPFORWARDNUMBER, "ipForwardNumber",
       NULL,
      G_STRUCT_OFFSET(ip_forward_mib_ipForward_t, ipForwardNumber),
      0,
      0 },
    { 3, GNET_SNMP_VARBIND_TYPE_UNSIGNED32,
      IP_FORWARD_MIB_IPCIDRROUTENUMBER, "ipCidrRouteNumber",
       NULL,
      G_STRUCT_OFFSET(ip_forward_mib_ipForward_t, ipCidrRouteNumber),
      0,
      0 },
    { 6, GNET_SNMP_VARBIND_TYPE_UNSIGNED32,
      IP_FORWARD_MIB_INETCIDRROUTENUMBER, "inetCidrRouteNumber",
       NULL,
      G_STRUCT_OFFSET(ip_forward_mib_ipForward_t, inetCidrRouteNumber),
      0,
      0 },
    { 8, GNET_SNMP_VARBIND_TYPE_COUNTER32,
      IP_FORWARD_MIB_INETCIDRROUTEDISCARDS, "inetCidrRouteDiscards",
       NULL,
      G_STRUCT_OFFSET(ip_forward_mib_ipForward_t, inetCidrRouteDiscards),
      0,
      0 },
    { 0, 0, 0, NULL }
};

static guint32 const ipCidrRouteEntry_oid[] = {1, 3, 6, 1, 2, 1, 4, 24, 4, 1};

static GNetSnmpAttribute ipCidrRouteEntry_attr[] = {
    { 5, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      IP_FORWARD_MIB_IPCIDRROUTEIFINDEX, "ipCidrRouteIfIndex",
       NULL,
      G_STRUCT_OFFSET(ip_forward_mib_ipCidrRouteEntry_t, ipCidrRouteIfIndex),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 6, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      IP_FORWARD_MIB_IPCIDRROUTETYPE, "ipCidrRouteType",
       NULL,
      G_STRUCT_OFFSET(ip_forward_mib_ipCidrRouteEntry_t, ipCidrRouteType),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 7, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      IP_FORWARD_MIB_IPCIDRROUTEPROTO, "ipCidrRouteProto",
       NULL,
      G_STRUCT_OFFSET(ip_forward_mib_ipCidrRouteEntry_t, ipCidrRouteProto),
      0,
      0 },
    { 8, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      IP_FORWARD_MIB_IPCIDRROUTEAGE, "ipCidrRouteAge",
       NULL,
      G_STRUCT_OFFSET(ip_forward_mib_ipCidrRouteEntry_t, ipCidrRouteAge),
      0,
      0 },
    { 9, GNET_SNMP_VARBIND_TYPE_OBJECTID,
      IP_FORWARD_MIB_IPCIDRROUTEINFO, "ipCidrRouteInfo",
       NULL,
      G_STRUCT_OFFSET(ip_forward_mib_ipCidrRouteEntry_t, ipCidrRouteInfo),
      G_STRUCT_OFFSET(ip_forward_mib_ipCidrRouteEntry_t, _ipCidrRouteInfoLength),
      GSNMP_ATTR_FLAG_WRITABLE },
    { 10, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      IP_FORWARD_MIB_IPCIDRROUTENEXTHOPAS, "ipCidrRouteNextHopAS",
       NULL,
      G_STRUCT_OFFSET(ip_forward_mib_ipCidrRouteEntry_t, ipCidrRouteNextHopAS),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 11, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      IP_FORWARD_MIB_IPCIDRROUTEMETRIC1, "ipCidrRouteMetric1",
       NULL,
      G_STRUCT_OFFSET(ip_forward_mib_ipCidrRouteEntry_t, ipCidrRouteMetric1),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 12, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      IP_FORWARD_MIB_IPCIDRROUTEMETRIC2, "ipCidrRouteMetric2",
       NULL,
      G_STRUCT_OFFSET(ip_forward_mib_ipCidrRouteEntry_t, ipCidrRouteMetric2),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 13, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      IP_FORWARD_MIB_IPCIDRROUTEMETRIC3, "ipCidrRouteMetric3",
       NULL,
      G_STRUCT_OFFSET(ip_forward_mib_ipCidrRouteEntry_t, ipCidrRouteMetric3),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 14, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      IP_FORWARD_MIB_IPCIDRROUTEMETRIC4, "ipCidrRouteMetric4",
       NULL,
      G_STRUCT_OFFSET(ip_forward_mib_ipCidrRouteEntry_t, ipCidrRouteMetric4),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 15, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      IP_FORWARD_MIB_IPCIDRROUTEMETRIC5, "ipCidrRouteMetric5",
       NULL,
      G_STRUCT_OFFSET(ip_forward_mib_ipCidrRouteEntry_t, ipCidrRouteMetric5),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 16, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      IP_FORWARD_MIB_IPCIDRROUTESTATUS, "ipCidrRouteStatus",
       NULL,
      G_STRUCT_OFFSET(ip_forward_mib_ipCidrRouteEntry_t, ipCidrRouteStatus),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 0, 0, 0, NULL }
};

static guint32 const inetCidrRouteEntry_oid[] = {1, 3, 6, 1, 2, 1, 4, 24, 7, 1};

static GNetSnmpAttribute inetCidrRouteEntry_attr[] = {
    { 7, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      IP_FORWARD_MIB_INETCIDRROUTEIFINDEX, "inetCidrRouteIfIndex",
       inetCidrRouteIfIndex_constraints,
      G_STRUCT_OFFSET(ip_forward_mib_inetCidrRouteEntry_t, inetCidrRouteIfIndex),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 8, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      IP_FORWARD_MIB_INETCIDRROUTETYPE, "inetCidrRouteType",
       NULL,
      G_STRUCT_OFFSET(ip_forward_mib_inetCidrRouteEntry_t, inetCidrRouteType),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 9, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      IP_FORWARD_MIB_INETCIDRROUTEPROTO, "inetCidrRouteProto",
       NULL,
      G_STRUCT_OFFSET(ip_forward_mib_inetCidrRouteEntry_t, inetCidrRouteProto),
      0,
      0 },
    { 10, GNET_SNMP_VARBIND_TYPE_UNSIGNED32,
      IP_FORWARD_MIB_INETCIDRROUTEAGE, "inetCidrRouteAge",
       NULL,
      G_STRUCT_OFFSET(ip_forward_mib_inetCidrRouteEntry_t, inetCidrRouteAge),
      0,
      0 },
    { 11, GNET_SNMP_VARBIND_TYPE_UNSIGNED32,
      IP_FORWARD_MIB_INETCIDRROUTENEXTHOPAS, "inetCidrRouteNextHopAS",
       NULL,
      G_STRUCT_OFFSET(ip_forward_mib_inetCidrRouteEntry_t, inetCidrRouteNextHopAS),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 12, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      IP_FORWARD_MIB_INETCIDRROUTEMETRIC1, "inetCidrRouteMetric1",
       NULL,
      G_STRUCT_OFFSET(ip_forward_mib_inetCidrRouteEntry_t, inetCidrRouteMetric1),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 13, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      IP_FORWARD_MIB_INETCIDRROUTEMETRIC2, "inetCidrRouteMetric2",
       NULL,
      G_STRUCT_OFFSET(ip_forward_mib_inetCidrRouteEntry_t, inetCidrRouteMetric2),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 14, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      IP_FORWARD_MIB_INETCIDRROUTEMETRIC3, "inetCidrRouteMetric3",
       NULL,
      G_STRUCT_OFFSET(ip_forward_mib_inetCidrRouteEntry_t, inetCidrRouteMetric3),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 15, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      IP_FORWARD_MIB_INETCIDRROUTEMETRIC4, "inetCidrRouteMetric4",
       NULL,
      G_STRUCT_OFFSET(ip_forward_mib_inetCidrRouteEntry_t, inetCidrRouteMetric4),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 16, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      IP_FORWARD_MIB_INETCIDRROUTEMETRIC5, "inetCidrRouteMetric5",
       NULL,
      G_STRUCT_OFFSET(ip_forward_mib_inetCidrRouteEntry_t, inetCidrRouteMetric5),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 17, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      IP_FORWARD_MIB_INETCIDRROUTESTATUS, "inetCidrRouteStatus",
       NULL,
      G_STRUCT_OFFSET(ip_forward_mib_inetCidrRouteEntry_t, inetCidrRouteStatus),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 0, 0, 0, NULL }
};


ip_forward_mib_ipForward_t *
ip_forward_mib_new_ipForward()
{
    ip_forward_mib_ipForward_t *ipForward;

    ipForward = (ip_forward_mib_ipForward_t *) g_malloc0(sizeof(ip_forward_mib_ipForward_t) + sizeof(gpointer));
    return ipForward;
}

static inline ip_forward_mib_ipForward_t *
assign_ipForward(GList *vbl)
{
    ip_forward_mib_ipForward_t *ipForward;
    char *p;

    ipForward = ip_forward_mib_new_ipForward();
    p = (char *) ipForward + sizeof(ip_forward_mib_ipForward_t);
    * (GList **) p = vbl;

    gnet_snmp_attr_assign(vbl, ipForward_oid, G_N_ELEMENTS(ipForward_oid),
                      ipForward_attr, ipForward);

    return ipForward;
}

void
ip_forward_mib_get_ipForward(GNetSnmp *s, ip_forward_mib_ipForward_t **ipForward, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    static const guint32 _base[] = {1, 3, 6, 1, 2, 1, 4, 24, 0};
    guint32 base[128];

    *ipForward = NULL;
    memcpy(base, _base, sizeof(_base));

    gnet_snmp_attr_get(s, &in, base, 9, 8, ipForward_attr, mask);

    out = gnet_snmp_sync_getnext(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if ((error && *error) || s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *ipForward = assign_ipForward(out);
    }
}

void
ip_forward_mib_free_ipForward(ip_forward_mib_ipForward_t *ipForward)
{
    GList *vbl;
    char *p;

    if (ipForward) {
        p = (char *) ipForward + sizeof(ip_forward_mib_ipForward_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(ipForward);
    }
}

ip_forward_mib_ipCidrRouteEntry_t *
ip_forward_mib_new_ipCidrRouteEntry()
{
    ip_forward_mib_ipCidrRouteEntry_t *ipCidrRouteEntry;

    ipCidrRouteEntry = (ip_forward_mib_ipCidrRouteEntry_t *) g_malloc0(sizeof(ip_forward_mib_ipCidrRouteEntry_t) + sizeof(gpointer));
    return ipCidrRouteEntry;
}

static inline int
unpack_ipCidrRouteEntry(GNetSnmpVarBind *vb, ip_forward_mib_ipCidrRouteEntry_t *ipCidrRouteEntry)
{
    guint8 idx = 11;
    guint16 i, len;

    len = 4;
    if (vb->oid_len < idx + len) return -1;
    for (i = 0; i < len; i++) {
        ipCidrRouteEntry->ipCidrRouteDest[i] = vb->oid[idx++];
    }
    len = 4;
    if (vb->oid_len < idx + len) return -1;
    for (i = 0; i < len; i++) {
        ipCidrRouteEntry->ipCidrRouteMask[i] = vb->oid[idx++];
    }
    if (vb->oid_len < idx) return -1;
    ipCidrRouteEntry->ipCidrRouteTos = vb->oid[idx++];
    if ((ipCidrRouteEntry->ipCidrRouteTos < 0)) {
         return -1;
    }
    len = 4;
    if (vb->oid_len < idx + len) return -1;
    for (i = 0; i < len; i++) {
        ipCidrRouteEntry->ipCidrRouteNextHop[i] = vb->oid[idx++];
    }
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_ipCidrRouteEntry(guint32 *base, guchar *ipCidrRouteDest, guchar *ipCidrRouteMask, gint32 ipCidrRouteTos, guchar *ipCidrRouteNextHop)
{
    guint8 idx = 11;
    guint16 i, len;

    len = 4;
    if (len != 4) return -1;
    for (i = 0; i < len; i++) {
        base[idx++] = ipCidrRouteDest[i];
        if (idx >= 128) return -1;
    }
    len = 4;
    if (len != 4) return -1;
    for (i = 0; i < len; i++) {
        base[idx++] = ipCidrRouteMask[i];
        if (idx >= 128) return -1;
    }
    base[idx++] = ipCidrRouteTos;
    len = 4;
    if (len != 4) return -1;
    for (i = 0; i < len; i++) {
        base[idx++] = ipCidrRouteNextHop[i];
        if (idx >= 128) return -1;
    }
    return idx;
}

static inline ip_forward_mib_ipCidrRouteEntry_t *
assign_ipCidrRouteEntry(GList *vbl)
{
    ip_forward_mib_ipCidrRouteEntry_t *ipCidrRouteEntry;
    char *p;

    ipCidrRouteEntry = ip_forward_mib_new_ipCidrRouteEntry();
    p = (char *) ipCidrRouteEntry + sizeof(ip_forward_mib_ipCidrRouteEntry_t);
    * (GList **) p = vbl;

    if (unpack_ipCidrRouteEntry((GNetSnmpVarBind *) vbl->data, ipCidrRouteEntry) < 0) {
        g_warning("%s: invalid instance identifier", "ipCidrRouteEntry");
        g_free(ipCidrRouteEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, ipCidrRouteEntry_oid, G_N_ELEMENTS(ipCidrRouteEntry_oid),
                      ipCidrRouteEntry_attr, ipCidrRouteEntry);

    return ipCidrRouteEntry;
}

void
ip_forward_mib_get_ipCidrRouteTable(GNetSnmp *s, ip_forward_mib_ipCidrRouteEntry_t ***ipCidrRouteEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 const _base[] = {1, 3, 6, 1, 2, 1, 4, 24, 4, 1, 0};
    guint32 base[128];

    *ipCidrRouteEntry = NULL;
    memcpy(base, _base, sizeof(_base));

    gnet_snmp_attr_get(s, &in, base, 11, 10, ipCidrRouteEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in, error);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *ipCidrRouteEntry = (ip_forward_mib_ipCidrRouteEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(ip_forward_mib_ipCidrRouteEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*ipCidrRouteEntry)[i] = assign_ipCidrRouteEntry(row->data);
        }
    }
}

void
ip_forward_mib_get_ipCidrRouteEntry(GNetSnmp *s, ip_forward_mib_ipCidrRouteEntry_t **ipCidrRouteEntry, guchar *ipCidrRouteDest, guchar *ipCidrRouteMask, gint32 ipCidrRouteTos, guchar *ipCidrRouteNextHop, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, ipCidrRouteEntry_oid, sizeof(ipCidrRouteEntry_oid));
    len = pack_ipCidrRouteEntry(base, ipCidrRouteDest, ipCidrRouteMask, ipCidrRouteTos, ipCidrRouteNextHop);
    if (len < 0) {
        g_warning("%s: invalid index values", "ipCidrRouteEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *ipCidrRouteEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 10, ipCidrRouteEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *ipCidrRouteEntry = assign_ipCidrRouteEntry(out);
    }
}

void
ip_forward_mib_set_ipCidrRouteEntry(GNetSnmp *s, ip_forward_mib_ipCidrRouteEntry_t *ipCidrRouteEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, ipCidrRouteEntry_oid, sizeof(ipCidrRouteEntry_oid));
    len = pack_ipCidrRouteEntry(base, ipCidrRouteEntry->ipCidrRouteDest, ipCidrRouteEntry->ipCidrRouteMask, ipCidrRouteEntry->ipCidrRouteTos, ipCidrRouteEntry->ipCidrRouteNextHop);
    if (len < 0) {
        g_warning("%s: invalid index values", "ipCidrRouteEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    gnet_snmp_attr_set(s, &in, base, len, 10, ipCidrRouteEntry_attr, mask, ipCidrRouteEntry);

    out = gnet_snmp_sync_set(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(out);
    }
}

void
ip_forward_mib_free_ipCidrRouteEntry(ip_forward_mib_ipCidrRouteEntry_t *ipCidrRouteEntry)
{
    GList *vbl;
    char *p;

    if (ipCidrRouteEntry) {
        p = (char *) ipCidrRouteEntry + sizeof(ip_forward_mib_ipCidrRouteEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(ipCidrRouteEntry);
    }
}

void
ip_forward_mib_free_ipCidrRouteTable(ip_forward_mib_ipCidrRouteEntry_t **ipCidrRouteEntry)
{
    int i;

    if (ipCidrRouteEntry) {
        for (i = 0; ipCidrRouteEntry[i]; i++) {
            ip_forward_mib_free_ipCidrRouteEntry(ipCidrRouteEntry[i]);
        }
        g_free(ipCidrRouteEntry);
    }
}

ip_forward_mib_inetCidrRouteEntry_t *
ip_forward_mib_new_inetCidrRouteEntry()
{
    ip_forward_mib_inetCidrRouteEntry_t *inetCidrRouteEntry;

    inetCidrRouteEntry = (ip_forward_mib_inetCidrRouteEntry_t *) g_malloc0(sizeof(ip_forward_mib_inetCidrRouteEntry_t) + sizeof(gpointer));
    return inetCidrRouteEntry;
}

static inline int
unpack_inetCidrRouteEntry(GNetSnmpVarBind *vb, ip_forward_mib_inetCidrRouteEntry_t *inetCidrRouteEntry)
{
    guint8 idx = 11;
    guint16 i, len;

    if (vb->oid_len < idx) return -1;
    inetCidrRouteEntry->inetCidrRouteDestType = vb->oid[idx++];
    if (vb->oid_len < idx) return -1;
    len = vb->oid[idx++];
    if (len > 117) return -1;
    if (vb->oid_len < idx + len) return -1;
    for (i = 0; i < len; i++) {
        inetCidrRouteEntry->inetCidrRouteDest[i] = vb->oid[idx++];
    }
    inetCidrRouteEntry->_inetCidrRouteDestLength = len;
    if (vb->oid_len < idx) return -1;
    inetCidrRouteEntry->inetCidrRoutePfxLen = vb->oid[idx++];
     if ((inetCidrRouteEntry->inetCidrRoutePfxLen > 2040)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    len = vb->oid[idx++];
    if (vb->oid_len < idx + len) return -1;
    if (len > 117) return -1;
    for (i = 0; i < len; i++) {
        inetCidrRouteEntry->inetCidrRoutePolicy[i] = vb->oid[idx++];
    }
    inetCidrRouteEntry->_inetCidrRoutePolicyLength = len;
    if (vb->oid_len < idx) return -1;
    inetCidrRouteEntry->inetCidrRouteNextHopType = vb->oid[idx++];
    if (vb->oid_len < idx) return -1;
    len = vb->oid[idx++];
    if (len > 117) return -1;
    if (vb->oid_len < idx + len) return -1;
    for (i = 0; i < len; i++) {
        inetCidrRouteEntry->inetCidrRouteNextHop[i] = vb->oid[idx++];
    }
    inetCidrRouteEntry->_inetCidrRouteNextHopLength = len;
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_inetCidrRouteEntry(guint32 *base, gint32 inetCidrRouteDestType, guchar *inetCidrRouteDest, guint16 _inetCidrRouteDestLength, guint32 inetCidrRoutePfxLen, guint32 *inetCidrRoutePolicy, guint16 _inetCidrRoutePolicyLength, gint32 inetCidrRouteNextHopType, guchar *inetCidrRouteNextHop, guint16 _inetCidrRouteNextHopLength)
{
    guint8 idx = 11;
    guint16 i, len;

    base[idx++] = inetCidrRouteDestType;
    len = _inetCidrRouteDestLength;
    base[idx++] = len;
    if (len > 117) return -1;
    for (i = 0; i < len; i++) {
        base[idx++] = inetCidrRouteDest[i];
        if (idx >= 128) return -1;
    }
    base[idx++] = inetCidrRoutePfxLen;
    len = _inetCidrRoutePolicyLength;
    base[idx++] = len;
    if (len > 117) return -1;
    for (i = 0; i < len; i++) {
        base[idx++] = inetCidrRoutePolicy[i];
        if (idx >= 128) return -1;
    }
    base[idx++] = inetCidrRouteNextHopType;
    len = _inetCidrRouteNextHopLength;
    base[idx++] = len;
    if (len > 117) return -1;
    for (i = 0; i < len; i++) {
        base[idx++] = inetCidrRouteNextHop[i];
        if (idx >= 128) return -1;
    }
    return idx;
}

static inline ip_forward_mib_inetCidrRouteEntry_t *
assign_inetCidrRouteEntry(GList *vbl)
{
    ip_forward_mib_inetCidrRouteEntry_t *inetCidrRouteEntry;
    char *p;

    inetCidrRouteEntry = ip_forward_mib_new_inetCidrRouteEntry();
    p = (char *) inetCidrRouteEntry + sizeof(ip_forward_mib_inetCidrRouteEntry_t);
    * (GList **) p = vbl;

    if (unpack_inetCidrRouteEntry((GNetSnmpVarBind *) vbl->data, inetCidrRouteEntry) < 0) {
        g_warning("%s: invalid instance identifier", "inetCidrRouteEntry");
        g_free(inetCidrRouteEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, inetCidrRouteEntry_oid, G_N_ELEMENTS(inetCidrRouteEntry_oid),
                      inetCidrRouteEntry_attr, inetCidrRouteEntry);

    return inetCidrRouteEntry;
}

void
ip_forward_mib_get_inetCidrRouteTable(GNetSnmp *s, ip_forward_mib_inetCidrRouteEntry_t ***inetCidrRouteEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 const _base[] = {1, 3, 6, 1, 2, 1, 4, 24, 7, 1, 0};
    guint32 base[128];

    *inetCidrRouteEntry = NULL;
    memcpy(base, _base, sizeof(_base));

    gnet_snmp_attr_get(s, &in, base, 11, 10, inetCidrRouteEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in, error);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *inetCidrRouteEntry = (ip_forward_mib_inetCidrRouteEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(ip_forward_mib_inetCidrRouteEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*inetCidrRouteEntry)[i] = assign_inetCidrRouteEntry(row->data);
        }
    }
}

void
ip_forward_mib_get_inetCidrRouteEntry(GNetSnmp *s, ip_forward_mib_inetCidrRouteEntry_t **inetCidrRouteEntry, gint32 inetCidrRouteDestType, guchar *inetCidrRouteDest, guint16 _inetCidrRouteDestLength, guint32 inetCidrRoutePfxLen, guint32 *inetCidrRoutePolicy, guint16 _inetCidrRoutePolicyLength, gint32 inetCidrRouteNextHopType, guchar *inetCidrRouteNextHop, guint16 _inetCidrRouteNextHopLength, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, inetCidrRouteEntry_oid, sizeof(inetCidrRouteEntry_oid));
    len = pack_inetCidrRouteEntry(base, inetCidrRouteDestType, inetCidrRouteDest, _inetCidrRouteDestLength, inetCidrRoutePfxLen, inetCidrRoutePolicy, _inetCidrRoutePolicyLength, inetCidrRouteNextHopType, inetCidrRouteNextHop, _inetCidrRouteNextHopLength);
    if (len < 0) {
        g_warning("%s: invalid index values", "inetCidrRouteEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *inetCidrRouteEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 10, inetCidrRouteEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *inetCidrRouteEntry = assign_inetCidrRouteEntry(out);
    }
}

void
ip_forward_mib_set_inetCidrRouteEntry(GNetSnmp *s, ip_forward_mib_inetCidrRouteEntry_t *inetCidrRouteEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, inetCidrRouteEntry_oid, sizeof(inetCidrRouteEntry_oid));
    len = pack_inetCidrRouteEntry(base, inetCidrRouteEntry->inetCidrRouteDestType, inetCidrRouteEntry->inetCidrRouteDest, inetCidrRouteEntry->_inetCidrRouteDestLength, inetCidrRouteEntry->inetCidrRoutePfxLen, inetCidrRouteEntry->inetCidrRoutePolicy, inetCidrRouteEntry->_inetCidrRoutePolicyLength, inetCidrRouteEntry->inetCidrRouteNextHopType, inetCidrRouteEntry->inetCidrRouteNextHop, inetCidrRouteEntry->_inetCidrRouteNextHopLength);
    if (len < 0) {
        g_warning("%s: invalid index values", "inetCidrRouteEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    gnet_snmp_attr_set(s, &in, base, len, 10, inetCidrRouteEntry_attr, mask, inetCidrRouteEntry);

    out = gnet_snmp_sync_set(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(out);
    }
}

void
ip_forward_mib_free_inetCidrRouteEntry(ip_forward_mib_inetCidrRouteEntry_t *inetCidrRouteEntry)
{
    GList *vbl;
    char *p;

    if (inetCidrRouteEntry) {
        p = (char *) inetCidrRouteEntry + sizeof(ip_forward_mib_inetCidrRouteEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(inetCidrRouteEntry);
    }
}

void
ip_forward_mib_free_inetCidrRouteTable(ip_forward_mib_inetCidrRouteEntry_t **inetCidrRouteEntry)
{
    int i;

    if (inetCidrRouteEntry) {
        for (i = 0; inetCidrRouteEntry[i]; i++) {
            ip_forward_mib_free_inetCidrRouteEntry(inetCidrRouteEntry[i]);
        }
        g_free(inetCidrRouteEntry);
    }
}


