;*=====================================================================*/
;*    serrano/prgm/project/scribe/engine/cmdline.scm                   */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Sep 29 05:24:55 2001                          */
;*    Last change :  Fri Jan 11 10:47:19 2002 (serrano)                */
;*    Copyright   :  2001-02 Manuel Serrano                            */
;*    -------------------------------------------------------------    */
;*    Command line parsing                                             */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module scribe_cmdline
   (library scribeapi)
   (import  scribe_param)
   (export  (parse-env-variables)
	    (parse-cmdline ::pair)))

;*---------------------------------------------------------------------*/
;*    parse-env-variables ...                                          */
;*---------------------------------------------------------------------*/
(define (parse-env-variables)
   (let ((e (getenv "SCRIBEPATH")))
      (if (string? e)
	  (set! *scribe-path*
		(append (unix-path->list e) *scribe-path*))))
   (let ((e (getenv "SCRIBESTYLEPATH")))
      (if (string? e)
	  (set! *scribe-style-path*
		(append (unix-path->list e) *scribe-style-path*))))
   (let ((e (getenv "SCRIBELIBRARYPATH")))
      (if (string? e)
	  (set! *scribe-library-path*
		(append (unix-path->list e) *scribe-library-path*)))))

;*---------------------------------------------------------------------*/
;*    parse-cmdline ...                                                */
;*---------------------------------------------------------------------*/
(define (parse-cmdline args)
   (define (usage args-parse-usage)
      (print "usage: scribe [options] [input]")
      (newline)
      (args-parse-usage #f)
      (newline)
      (print "Rc file:")
      (newline)
      (print "   *rc-file* (searched in \".\" then $HOME)")
      (newline)
      (print "Shell Variables:")
      (newline)
      (for-each (lambda (var)
		   (print "   - " (car var) " " (cdr var)))
		'(("SCRIBEPATH" . "Scribe input path (all files)")
		  ("SCRIBESTYLEPATH" . "Scribe style path"))))
   (define (version)
      (print "scribe v" (scribe-version)))
   (define (query)
      (version)
      (newline)
      (print "Version          : " (scribe-version))
      (print "Url              : " (scribe-url))
      (print "Style directory  : " (scribe-style-directory))
      (print "Library directory: " (scribe-library-directory)))
   ;; we parse the command line
   (args-parse (cdr args)
      ((("-h" "--help") (help "This help message"))
       (usage args-parse-usage)
       (exit 0))
      ((("--options") (help "Display the scribe options and exit"))
       (args-parse-usage #t)
       (exit 0))
      (("--version" (help "The version of Scribe"))
       (version)
       (exit 0))
      ((("-v" "--verbose") (help "Increase the verbosity"))
       (set! *scribe-verbose* (+fx 1 *scribe-verbose*)))
      ((("-q" "--query") (help "Display informations about the Scribe configuration"))
       (query)
       (exit 0))
      ((("-t" "--target") ?fmt (help "The output target format"))
       (set! *scribe-format* (string->symbol fmt)))
      ((("-b" "--base") ?base (help "The base prefix to remove from links"))
       (set! *scribe-ref-base* base))
      (("-o" ?dst (help "Name the output file <dest>"))
       (set! *scribe-dest* dst))
      (("-I" ?path (help "Add <path> to scribe path"))
       (set! *scribe-path* (append *scribe-path* (list path))))
      (("-J" ?path (help "Add <path> to scribe style path"))
       (set! *scribe-style-path* (append *scribe-style-path* (list path))))
      (("-L" ?path (help "Add <path> to scribe library path"))
       (set! *scribe-library-path* (append *scribe-library-path* (list path))))
      (("-B" ?path (help "Add <path> to scribe bibliography path"))
       (set! *scribe-bib-path* (append *scribe-bib-path* (list path))))
      (("--eval" ?expr (help "Evaluate expression"))
       (with-input-from-string expr
	  (lambda ()
	     (eval (read)))))
      (else
       (if (string? *scribe-src*)
	   (warning "scribe" "-- ignoring argument: " else)
	   (set! *scribe-src* else))))
   ;; we have to configure according to the environment variables
   (set! *scribe-path*
	 (append (build-path-from-shell-variable "SCRIBEPATH")
		 *scribe-path*))
   (set! *scribe-style-path*
	 (append (build-path-from-shell-variable "SCRIBESTYLEPATH")
		 *scribe-style-path*))
   ;; we establish the output format
   (output-format-setup!))

;*---------------------------------------------------------------------*/
;*    build-path-from-shell-variable ...                               */
;*---------------------------------------------------------------------*/
(define (build-path-from-shell-variable var)
   (let ((val (getenv var)))
      (if (string? val)
	  (string-case val
	     ((+ (out #\:))
	      (let* ((str (the-string))
		     (res (ignore)))
		 (cons str res)))
	     (#\:
	      (ignore))
	     (else
	      '()))
	  '())))

;*---------------------------------------------------------------------*/
;*    output-format-setup! ...                                         */
;*---------------------------------------------------------------------*/
(define (output-format-setup!)
   (if (symbol? *scribe-format*)
       *scribe-format*
       (let ((default-format 'html))
	  (if (not (string? *scribe-dest*))
	      (set! *scribe-format* default-format)
	      (let ((s (suffix *scribe-dest*)))
		 (if (>fx (string-length s) 0)
		     (let ((cell (assoc s *scribe-auto-mode-alist*)))
			(if (pair? cell)
			    (set! *scribe-format* (cdr cell))
			    (set! *scribe-format* default-format)))))))))
