;*=====================================================================*/
;*    serrano/prgm/project/scribe/scribeapi/pxml.scm                   */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Sep 26 22:15:36 2001                          */
;*    Last change :  Wed Jan 16 11:42:54 2002 (serrano)                */
;*    Copyright   :  2001-02 Manuel Serrano                            */
;*    -------------------------------------------------------------    */
;*    The XML fontifier.                                               */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __scribeapi_pxml
   
   (import  __scribeapi_param
	    __scribeapi_ast)
   
   (eval    (export xml))
   
   (export  (xml ::bstring)))

;*---------------------------------------------------------------------*/
;*    xml ...                                                          */
;*---------------------------------------------------------------------*/
(define (xml obj)
   (parse-xml (open-input-string obj)))

;*---------------------------------------------------------------------*/
;*    parse-xml port ...                                               */
;*---------------------------------------------------------------------*/
(define (parse-xml port::input-port)
   (let ((g (regular-grammar ()
	       ((bol (: "%%" (* all)))
		;; a text inclusion
		(with-input-from-string (the-substring 2 (the-length))
		   (lambda ()
		      (let* ((file (read))
			     (def (read))
			     (start (read))
			     (stop (read)))
			 (append (xml-from-file file def start stop)
				 (ignore))))))
	       ((: #\; (in "<!--") (* (or all #\Newline)) "-->")
		;; italic comments
		(let ((str (the-string)))
		   (cons (if *scribe-prgm-color*
			     `(color :fg "#ffa600" (it ,str))
			     `(it ,str))
			 (ignore))))
	       ((+ #\Newline)
		;; separators
		(let ((str (the-string)))
		   (cons str (ignore))))
	       ((+ #\Space)
		;; separators
		(let ((str (the-string)))
		   (cons str (ignore))))
	       ((: #\< (+ (or (in ("AZ09")) (in "/!")))
		       (or #\> (: #\space (+ (out #\>)) #\>)))
		;; markup
		(let ((str (the-string)))
		   (let ((par (if *scribe-prgm-color*
				  `(color :fg "blue" (bold ,str))
				  str)))
		      (cons par (ignore)))))
	       ((: #\< (+ (out #\>)) #\>)
		;; markup
		(let ((str (the-string)))
		   (let ((par (if *scribe-prgm-color*
				  `(bold ,str)
				  str)))
		      (cons par (ignore)))))
	       ((+ (out #\< #\> #\Space #\Tab))
		;; regular text
		(let ((string (the-string)))
		   (cons string (ignore))))
	       ((or (: "\"" (* (or (out #a000 #\\ #\") (: #\\ all))) "\"")
		    (: "#\"" (* (or (out #a000 #\\ #\") (: #\\ all))) "\""))
		;; strings
		(let ((str (the-string)))
		   (cons (if *scribe-prgm-color*
			     `(color :fg "red" ,str)
			     str)
			 (ignore))))
	       (else
		(let ((c (the-failure)))
		   (if (eof-object? c)
		       '()
		       (error "prgm(xml)" "Unexpected character" c)))))))
      (read/rp g port)))

;*---------------------------------------------------------------------*/
;*    xml-from-file ...                                                */
;*---------------------------------------------------------------------*/
(define (xml-from-file file def start stop)
   (cond
      ((and (not def) (not start) (not stop))
       ;; the whole file
       (if (file-exists? file)
	   (let ((p (open-input-file file)))
	      (if (input-port? p)
		  (parse-xml p)
		  (error "prgm(xml)" "Can't open file" file)))
	   (error "prgm(xml)" "Can't find file" file)))
      ((or start stop)
       (xml-from-file-lines file start stop))
      (else
       '())))

;*---------------------------------------------------------------------*/
;*    xml-from-file-lines ...                                          */
;*---------------------------------------------------------------------*/
(define (xml-from-file-lines file start stop)
   (let* ((start (if (fixnum? start)
		     start
		     1))
	  (stop (if (fixnum? stop)
		    stop
		    -1))
	  (port (open-input-file/line file start)))
      (unwind-protect
	 (let loop ((line (read-line port))
		    (lines '())
		    (lnum start))
	    (cond
	       ((and (> stop 0) (> lnum stop))
		(cdr (reverse! lines)))
	       ((eof-object? line)
		(if (=fx stop -1)
		    (cdr (reverse! lines))
		    (error "prgm(xml)" "File too short" file)))
	       (else
		(loop (read-line port)
		      (cons* (untabify line) #"\n" lines)
		      (+fx lnum 1)))))
	 (close-input-port port))))

;*---------------------------------------------------------------------*/
;*    untabify ...                                                     */
;*---------------------------------------------------------------------*/
(define (untabify obj)
   ;; count the number of #\tab
   (let ((len (string-length obj))
	 (tabl 8))
      (let loop ((i 0)
		 (nl 0))
	 (cond
	    ((=fx i len)
	     (if (=fx nl len)
		 obj
		 ;; allocates a new string and fill it
		 (let ((new (make-string nl)))
		    (let loop ((r 0)
			       (w 0))
		       (cond
			  ((=fx r len)
			   new)
			  ((char=? (string-ref obj r) #\tab)
			   (let ((q (/fx r tabl)))
			      (let liip ((num (-fx (*fx tabl (+fx 1 q)) r))
					 (w w))
				 (if (=fx num 0)
				     (loop (+fx r 1) w)
				     (begin
					(string-set! new w #\space)
					(liip (-fx num 1) (+fx w 1)))))))
			  (else
			   (string-set! new w (string-ref obj r))
			   (loop (+fx r 1) (+fx w 1))))))))
	    ((char=? (string-ref obj i) #\tab)
	     (let* ((q (/fx i tabl))
		    (n (-fx (*fx tabl (+fx 1 q)) i)))
		(loop (+fx i 1) (+fx nl n))))
	    (else
	     (loop (+fx i 1) (+fx nl 1)))))))

;*---------------------------------------------------------------------*/
;*    open-input-file/line ...                                         */
;*---------------------------------------------------------------------*/
(define (open-input-file/line::input-port file line-num)
   (let ((iport (open-input-file file)))
      (if (not (input-port? iport))
	  (error "prgm(xml)" "Can't open file for input" file)
	  (if (=fx line-num 1)
	      iport
	      (let loop ((line (read-line iport))
			 (lnum 2))
		 (cond
		    ((eof-object? line)
		     (error "prgm(xml)"
			    "File too short"
			    (list file line-num lnum)))
		    ((>fx lnum line-num)
		     (error "prgm(xml)"
			    "Illegal file num"
			    (list file line-num lnum)))
		    ((=fx lnum line-num)
		     iport)
		    (else
		     (loop (read-line iport) (+fx lnum 1)))))))))

;*---------------------------------------------------------------------*/
;*    reader-current-line-number ...                                   */
;*    -------------------------------------------------------------    */
;*    This is a gross hack but to get the current reader line number   */
;*    we build a dummy expression that we read.                        */
;*---------------------------------------------------------------------*/
(define (reader-current-line-number)
   (let* ((port (open-input-string "(9)"))
	  (exp  (read port #t)))
      (close-input-port port)
      (line-number exp)))

;*---------------------------------------------------------------------*/
;*    line-number ...                                                  */
;*---------------------------------------------------------------------*/
(define (line-number expr)
   (and (epair? expr)
	(match-case (cer expr)
	   ((at ?- ?pos ?line)
	    line))))

