;*=====================================================================*/
;*    serrano/prgm/project/scribe/scribetext/info.scm                  */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Sep 23 14:03:53 2001                          */
;*    Last change :  Wed Jan  9 16:06:22 2002 (serrano)                */
;*    Copyright   :  2001-02 Manuel Serrano                            */
;*    -------------------------------------------------------------    */
;*    The translator scribe->text                                      */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __scribetext_info
   
   (library scribeapi)

   (import  __scribetext_justify
	    __scribetext_table)
   
   (export  (generic info obj::obj)))

;*---------------------------------------------------------------------*/
;*    info-dest ...                                                    */
;*---------------------------------------------------------------------*/
(define (info-dest)
   (if (string? *scribe-dest*)
       *scribe-dest*
       "anonymous.info"))

;*---------------------------------------------------------------------*/
;*    info-node ...                                                    */
;*---------------------------------------------------------------------*/
(define (info-node node next prev up)
   (print "")
   (print "File: " (info-dest)
	  ",  Node: " node
	  ",  Next: " next
	  ",  Prev: " prev
	  ",  Up: " up)
   (newline))

;*---------------------------------------------------------------------*/
;*    node-next+prev+top ::%container ...                              */
;*---------------------------------------------------------------------*/
(define-generic (node-next+prev+top obj::%container))

;*---------------------------------------------------------------------*/
;*    node-next+prev+top ::%document ...                               */
;*---------------------------------------------------------------------*/
(define-method (node-next+prev+top obj::%document)
   (with-access::%container obj (children)
      (let loop ((c children))
	 (cond
	    ((null? c)
	     (values "Top" "(dir)" "(dir)"))
	    ((or (%chapter? (car c)) (%section? (car c)))
	     (values (block-title (car c)) "(dir)" "(dir)"))
	    (else
	     (loop (cdr c)))))))

;*---------------------------------------------------------------------*/
;*    node-next+prev+top ...                                           */
;*---------------------------------------------------------------------*/
(define-method (node-next+prev+top obj::%block)
   (with-access::%block obj (parent)
      (let ((top (if (%document? parent)
		     "Top"
		     (block-title parent))))
	 (let loop ((els (%container-children parent))
		    (prev #f))
	    (cond
	       ((null? els)
		(values top top top))
	       ((eq? (car els) obj)
		(let ((p (if prev
			     (block-title prev)
			     top))
		      (n (if (null? (cdr els))
			     top
			     (block-title (cadr els)))))
		   (values p n top)))
	       (else
		(loop (cdr els) (car els))))))))

;*---------------------------------------------------------------------*/
;*    node-menu ...                                                    */
;*---------------------------------------------------------------------*/
(define (node-menu obj::%container)
   (with-access::%container obj (children)
      (if (pair? (filter (lambda (x) (or (%chapter? x) (%section? x)))
			 children))
	  (begin
	     (newline)
	     (print "* Menu:")
	     (newline)
	     (for-each (lambda (c)
			  (if (%block? c)
			      (print "* " (block-title c) "::")))
		       (reverse children))))
      (newline)))

;*---------------------------------------------------------------------*/
;*    block-title ::%block ...                                         */
;*---------------------------------------------------------------------*/
(define-generic (block-title obj::%block)
   "")

;*---------------------------------------------------------------------*/
;*    block-title ::%chapter ...                                       */
;*---------------------------------------------------------------------*/
(define-method (block-title obj::%chapter)
   (with-access::%chapter obj (title subtitle)
      (let ((title (if title title subtitle)))
	 (if (string? title)
	     title
	     (with-output-to-string 
		(lambda () (info title)))))))

;*---------------------------------------------------------------------*/
;*    block-title ::%section ...                                       */
;*---------------------------------------------------------------------*/
(define-method (block-title obj::%section)
   (with-access::%section obj (title)
      (if (string? title)
	  title
	  (with-output-to-string 
	     (lambda () (info title))))))

;*---------------------------------------------------------------------*/
;*    block-title ::%subsection ...                                    */
;*---------------------------------------------------------------------*/
(define-method (block-title obj::%subsection)
   (with-access::%subsection obj (title)
      (if (string? title)
	  title
	  (with-output-to-string 
	     (lambda () (info title))))))

;*---------------------------------------------------------------------*/
;*    block-title ::%subsection ...                                    */
;*---------------------------------------------------------------------*/
(define-method (block-title obj::%subsubsection)
   (with-access::%subsubsection obj (title)
      (if (string? title)
	  title
	  (with-output-to-string 
	     (lambda () (info title))))))

;*---------------------------------------------------------------------*/
;*    *text-string-processor* ...                                      */
;*---------------------------------------------------------------------*/
(define *text-string-processor*
   (lambda (x) x))

;*---------------------------------------------------------------------*/
;*    info ::obj ...                                                   */
;*---------------------------------------------------------------------*/
(define-generic (info obj::obj)
   (cond
      ((procedure? obj)
       (info (obj)))
      ((string? obj)
       (output (*text-string-processor* obj)))
      ((number? obj)
       (output (*text-string-processor* (number->string obj))))
      ((char? obj)
       (output (*text-string-processor* (string obj))))
      ((eq? obj #unspecified)
       obj)
      ((list? obj)
       (for-each info obj))
      ((or (symbol? obj) (boolean? obj))
       "")
      (else
       (with-access::%node obj (loc)
	  (error/location "info"
			  "Can't find method for node"
			  (find-runtime-type obj)
			  (car loc)
			  (cdr loc))))))

;*---------------------------------------------------------------------*/
;*    info ::%document ...                                             */
;*---------------------------------------------------------------------*/
(define-method (info obj::%document)
   (with-document
    obj
    (lambda ()
       (with-access::%document obj (title authors body footnotes)
	  (scribe-document->info obj title authors body)
	  (if (pair? footnotes)
	      (begin
		 (with-justification
		  (make-justifier *text-column-width* 'left)
		  (lambda ()
		     (newline)
		     (newline)
		     (print "-------------")
		     (for-each (lambda (fn)
				  (with-access::%footnote fn (number note id)
				     (output (string-append
					      "*"
					      (number->string number)
					      ": "))
				     (info note)
				     (output-newline)))
			       footnotes)))))))))

;*---------------------------------------------------------------------*/
;*     scribe-document->info ...                                       */
;*---------------------------------------------------------------------*/
(define (scribe-document->info obj title authors body)
   (define (info-authors1 author)
      (info author)
      (output-newline)
      (output-newline))
   (define (info-authorsN authors cols first)
      (define (make-row authors . opt)
	 (apply tr (map (lambda (v)
			   (apply td :align 'center :valign 'top v opt))
			authors)))
      (define (make-rows authors)
	 (let loop ((authors authors)
		    (rows '())
		    (row '())
		    (cnum 0))
	    (cond
	       ((null? authors)
		(reverse! (cons (make-row (reverse! row)) rows)))
	       ((= cnum cols)
		(loop authors
		      (cons (make-row (reverse! row)) rows)
		      '()
		      0))
	       (else
		(loop (cdr authors)
		      rows
		      (cons (car authors) row)
		      (+fx cnum 1))))))
      (info (apply table
		    (if first
			(cons (make-row (list (car authors)) :colspan cols)
			      (make-rows (cdr authors)))
			(make-rows authors)))))
   (define (info-authors authors)
      (if (pair? authors)
	  (begin
	     (output-newline)
	     (output "--o-0-o--")
	     (output-newline)
	     (output-newline)
	     (let ((len (length authors)))
		(case len
		   ((1)
		    (info-authors1 (car authors)))
		   ((2 3)
		    (info-authorsN authors len #f))
		   ((4)
		    (info-authorsN authors 2 #f))
		   (else
		    (info-authorsN authors 3 #t)))))))
   ;; display the title and the authors
   (define (info-title title authors)
      (with-justification
       (make-justifier (justification-width) 'center)
       (lambda ()
	  (output (make-string *text-column-width* #\=))
	  (output-newline)
	  (if (string? title)
	      (output (list->string
		       (apply append
			      (map (lambda (c) (list c #a008))
				   (string->list title)))))
	      (info title))
	  (output-newline)
	  (info-authors authors)
	  (output (make-string *text-column-width* #\=))
	  (output-newline)
	  (output-newline)
	  (output-flush *margin*))))
;; display the footer
   (define (info-footer)
      (if *scribe-footer* (info *scribe-footer*)))
   ;; the main node
   (multiple-value-bind (next prev top)
      (node-next+prev+top obj)
      (newline)
      (info-node "Top" next prev top))
   ;; the title
   (info-title title authors)
   (output-flush 0)
   ;; the main info menu
   (node-menu obj)
   ;; the body
   (info body)
   (output-flush 0)
   ;; the footer of the document
   (info-footer)
   (output-flush 0)
   ;; we are done
   (newline)
   (newline))

;*---------------------------------------------------------------------*/
;*    info ::%author ...                                               */
;*---------------------------------------------------------------------*/
(define-method (info obj::%author)
   (with-access::%author obj (name affiliation email url address phone)
      (if (or (pair? name) (string? name))
	  (info name))
      (if affiliation (begin (output-newline) (output affiliation)))
      (if (pair? address)
	  (for-each (lambda (x) (output-newline) (output x)) address))
      (if email (begin (output-newline) (output email)))
      (if url (begin (output-newline) (output url)))
      (if phone (begin (output-newline) (output phone)))
      (output-newline)))
   
;*---------------------------------------------------------------------*/
;*    scribe->html ::%toc ...                                          */
;*---------------------------------------------------------------------*/
(define-method (info obj::%toc)
   (node-menu (current-document)))

;*---------------------------------------------------------------------*/
;*    info ::%text ...                                                 */
;*---------------------------------------------------------------------*/
(define-method (info obj::%text)
   (info (%text-body obj)))

;*---------------------------------------------------------------------*/
;*    info ::%linebreak ...                                            */
;*---------------------------------------------------------------------*/
(define-method (info obj::%linebreak)
   (let loop ((num (%linebreak-repetition obj)))
      (output-newline)
      (if (>fx num 1)
	  (begin
	     (output-newline)
	     (loop (-fx num 1))))))

;*---------------------------------------------------------------------*/
;*    info ::%center ...                                               */
;*---------------------------------------------------------------------*/
(define-method (info obj::%center)
   (with-justification (make-justifier (justification-width) 'center)
		       (lambda ()
			  (info (%center-body obj)))))

;*---------------------------------------------------------------------*/
;*    info ::%flush ...                                                */
;*---------------------------------------------------------------------*/
(define-method (info obj::%flush)
   (with-access::%flush obj (side)
      (with-justification (make-justifier (justification-width) side)
			  (lambda ()
			     (info (%flush-body obj))))))

;*---------------------------------------------------------------------*/
;*    info ::%atom ...                                                 */
;*---------------------------------------------------------------------*/
(define-method (info obj::%atom)
   (output (%atom-value obj)))

;*---------------------------------------------------------------------*/
;*    info ::%emph ...                                                 */
;*---------------------------------------------------------------------*/
(define-method (info obj::%emph)
   (output "_")
   (info (%emph-body obj))
   (output "_"))

;*---------------------------------------------------------------------*/
;*    info ::%underline ...                                            */
;*---------------------------------------------------------------------*/
(define-method (info obj::%underline)
   (output "_")
   (info (%underline-body obj))
   (output "_"))

;*---------------------------------------------------------------------*/
;*    info ::%sup ...                                                  */
;*---------------------------------------------------------------------*/
(define-method (info obj::%sup)
   (with-access::%sup obj (body)
      (output "^")
      (info body)))

;*---------------------------------------------------------------------*/
;*    info ::%sub ...                                                  */
;*---------------------------------------------------------------------*/
(define-method (info obj::%sub)
   (with-access::%sub obj (body)
      (output "_")
      (info body)))

;*---------------------------------------------------------------------*/
;*    info ::%pre ...                                                  */
;*---------------------------------------------------------------------*/
(define-method (info obj::%pre)
   (with-justification (make-justifier *text-column-width* 'verbatim)
		       (lambda ()
			  (info (%pre-body obj))
			  (output-newline))))

;*---------------------------------------------------------------------*/
;*    info ::%code ...                                                 */
;*---------------------------------------------------------------------*/
(define-method (info obj::%code)
   (with-access::%code obj (body)
      (output "`")
      (info body)
      (output "'")))

;*---------------------------------------------------------------------*/
;*    info ::%samp ...                                                 */
;*---------------------------------------------------------------------*/
(define-method (info obj::%samp)
   (with-access::%samp obj (body)
      (output "`")
      (info body)
      (output "'")))

;*---------------------------------------------------------------------*/
;*    info ::%var ...                                                  */
;*---------------------------------------------------------------------*/
(define-method (info obj::%var)
   (with-access::%var obj (body)
      (let ((old *text-string-processor*))
	 (set! *text-string-processor* string-upcase)
	 (let ((res (info body)))
	    (set! *text-string-processor* old)
	    res))))

;*---------------------------------------------------------------------*/
;*    mark ...                                                         */
;*---------------------------------------------------------------------*/
(define-method (info obj::%mark)
   #unspecified)

;*---------------------------------------------------------------------*/
;*    reference ...                                                    */
;*---------------------------------------------------------------------*/
(define-method (info obj::%reference)
   (with-access::%reference obj (body anchor)
      (multiple-value-bind (file mark)
	 (find-reference obj (current-document))
	 (if (not mark)
	     (begin
		(warning "ref" "Can't find reference -- " anchor)
		(output "reference:???"))
	     (begin
		(output "*Note ")
		(info body)
		(output ":: "))))))

;*---------------------------------------------------------------------*/
;*    info ::%url-ref ...                                              */
;*---------------------------------------------------------------------*/
(define-method (info obj::%url-ref)
   (with-access::%url-ref obj (url anchor body)
      (output "*Note ")
      (info body)
      (output " (")
      (info url)
      (if anchor
	  (begin
	     (output "#")
	     (info anchor)))
      (output "):: ")))
   
;*---------------------------------------------------------------------*/
;*    info ::%chapter-ref ...                                          */
;*---------------------------------------------------------------------*/
(define-method (info obj::%chapter-ref)
   (multiple-value-bind (_ chapter)
      (find-reference obj (current-document))
      (if (not chapter)
	  (with-access::%chapter-ref obj (anchor)
	     (warning "ref" "Can't find chapter -- " anchor)
	     (output "chapter:???"))
	  (info-chapter-ref chapter))))

;*---------------------------------------------------------------------*/
;*    info-chapter-ref ...                                             */
;*---------------------------------------------------------------------*/
(define (info-chapter-ref obj::%chapter)
   (output "*Note ")
   (output (block-title obj))
   (output ":: "))

;*---------------------------------------------------------------------*/
;*    info ::%section-ref ...                                          */
;*---------------------------------------------------------------------*/
(define-method (info obj::%section-ref)
   (multiple-value-bind (_ section)
      (find-reference obj (current-document))
      (if (not (%section? section))
	  (with-access::%section-ref obj (anchor)
	     (warning "ref" "Can't find section -- " anchor)
	     (output "section:???"))
	  (info-section-ref section))))

;*---------------------------------------------------------------------*/
;*    info-section-ref ...                                             */
;*---------------------------------------------------------------------*/
(define (info-section-ref obj::%section)
   (with-access::%section obj (title)
      (output "*Note ")
      (output title)
      (output ":: ")))
   
;*---------------------------------------------------------------------*/
;*    info ::%subsection-ref ...                                       */
;*---------------------------------------------------------------------*/
(define-method (info obj::%subsection-ref)
   (multiple-value-bind (_ subsection)
      (find-reference obj (current-document))
      (if (not (%subsection? subsection))
	  (with-access::%subsection-ref obj (anchor)
	     (warning "ref" "Can't find subsection -- " anchor)
	     (output "subsection:???"))
	  (info-subsection-ref subsection))))

;*---------------------------------------------------------------------*/
;*    info-subsection-ref ...                                          */
;*---------------------------------------------------------------------*/
(define (info-subsection-ref obj::%subsection)
   (with-access::%subsection obj (title)
      (output "*Note ")
      (output title)
      (output ":: ")))
   
;*---------------------------------------------------------------------*/
;*    info ::%subsubsection-ref ...                                    */
;*---------------------------------------------------------------------*/
(define-method (info obj::%subsubsection-ref)
   (multiple-value-bind (_ subsubsection)
      (find-reference obj (current-document))
      (if (not (%subsubsection? subsubsection))
	  (with-access::%subsubsection-ref obj (anchor)
	     (warning "ref" "Can't find subsubsection -- " anchor)
	     (output "subsubsection:???"))
	  (info-subsubsection-ref subsubsection))))

;*---------------------------------------------------------------------*/
;*    info-subsubsection-ref ...                                       */
;*---------------------------------------------------------------------*/
(define (info-subsubsection-ref obj::%subsubsection)
   (with-access::%subsubsection obj (title)
      (output "*Note ")
      (output title)
      (output ":: ")))

;*---------------------------------------------------------------------*/
;*    mailto ...                                                       */
;*---------------------------------------------------------------------*/
(define-method (info obj::%mailto)
   (with-access::%mailto obj (email body)
      (if (pair? body)
	  (info body)
	  (output email))))

;*---------------------------------------------------------------------*/
;*    info ::%item ...                                                 */
;*---------------------------------------------------------------------*/
(define-method (info obj::%item)
   (with-access::%item obj (value body)
      (if (not (null? value))
	  (begin
	     (info value)
	     (display ": ")))
      (info body)))

;*---------------------------------------------------------------------*/
;*    info ::%itemize ...                                              */
;*---------------------------------------------------------------------*/
(define-method (info obj::%itemize)
   (with-access::%itemize obj (items)
      (for-each (lambda (item)
		   (with-justification (make-justifier
					(-fx (justification-width) 3)
					'left)
				       (lambda ()
					  (output "- ")
					  (info item))
				       3))
		items)))
      
;*---------------------------------------------------------------------*/
;*    info ::%enumerate ...                                            */
;*---------------------------------------------------------------------*/
(define-method (info obj::%enumerate)
   (with-access::%enumerate obj (items)
      (let loop ((num 1)
		 (items items))
	 (if (pair? items)
	     (let ((item (car items)))
		(with-justification (make-justifier
				     (-fx (justification-width) 3)
				     'left)
				    (lambda ()
				       (output (integer->string num))
				       (output " - ")
				       (info item))
				    3)
		(loop (+fx num 1) (cdr items)))))))
      
;*---------------------------------------------------------------------*/
;*    info ::%description ...                                          */
;*---------------------------------------------------------------------*/
(define-method (info obj::%description)
   (with-access::%description obj (items)
      (for-each (lambda (item)
		   (with-justification (make-justifier
					(-fx (justification-width) 3)
					'left)
				       (lambda ()
					  (with-access::%item item (value body)
					     (output "*")
					     (if (pair? value)
						 (let loop ((vs value))
						    (info (car vs))
						    (if (pair? (cdr vs))
							(begin
							   (output " ")
							   (loop (cdr vs)))))
						 (info value))
					     (output "* ")
					     (info body)))
				       3))
		items)))
      
;*---------------------------------------------------------------------*/
;*    info ::%section ...                                              */
;*---------------------------------------------------------------------*/
(define-method (info obj::%section)
   (with-access::%section obj (body title)
      (output-newline)
      (output-flush *margin*)
      (let ((t (block-title obj)))
	 (multiple-value-bind (next prev top)
	    (node-next+prev+top obj)
	    (info-node t next prev top)
	    (print t)
	    (print (make-string (string-length t) #\=))))
      (node-menu obj)
      (with-justification (make-justifier *text-column-width*
					  *text-justification*)
			  (lambda () (info body)))))

;*---------------------------------------------------------------------*/
;*    info ::%subsection ...                                           */
;*---------------------------------------------------------------------*/
(define-method (info obj::%subsection)
   (with-access::%subsection obj (body title)
      (output-flush *margin*)
      (let ((t (block-title obj)))
	 (multiple-value-bind (next prev top)
	    (node-next+prev+top obj)
	    (info-node t next prev top)
	    (print t)
	    (print (make-string (string-length t) #\-))))
      (info body)))

;*---------------------------------------------------------------------*/
;*    info ::%subsubsection ...                                        */
;*---------------------------------------------------------------------*/
(define-method (info obj::%subsubsection)
   (with-access::%subsubsection obj (body title)
      (output-flush *margin*)
      (let ((t (block-title obj)))
	 (multiple-value-bind (next prev top)
	    (node-next+prev+top obj)
	    (info-node t next prev top)
	    (print t)
	    (print (make-string (string-length t) #\~))))
      (info body)))

;*---------------------------------------------------------------------*/
;*    info ::%paragraph ...                                            */
;*---------------------------------------------------------------------*/
(define-method (info obj::%paragraph)
   (with-access::%paragraph obj (body)
      (output-newline)
      (output-flush *margin*)
      (info body)))

;*---------------------------------------------------------------------*/
;*    info ::%chapter ...                                              */
;*---------------------------------------------------------------------*/
(define-method (info obj::%chapter)
   (with-access::%chapter obj (body file title subtitle)
      (output-newline)
      (output-flush *margin*)
      (let ((t (block-title obj)))
	 (multiple-value-bind (next prev top)
	    (node-next+prev+top obj)
	    (info-node t next prev top)
	    (print t)
	    (print (make-string (string-length t) #\*))))
      (node-menu obj)
      (info body)))

;*---------------------------------------------------------------------*/
;*    info ::%hrule ...                                                */
;*---------------------------------------------------------------------*/
(define-method (info obj::%hrule)
   (with-access::%hrule obj (width)
      (let ((w (if (= width 100)
		   (justification-width)
		   (inexact->exact (* (exact->inexact (justification-width))
				      (/ (exact->inexact width) 100.))))))
	 (output (make-string w #\-)))))

;*---------------------------------------------------------------------*/
;*    info ::%font ...                                                 */
;*---------------------------------------------------------------------*/
(define-method (info obj::%font)
   (with-access::%font obj (body)
      (info body)))

;*---------------------------------------------------------------------*/
;*    info ::%image ...                                                */
;*---------------------------------------------------------------------*/
(define-method (info obj::%image)
   #unspecified)

;*---------------------------------------------------------------------*/
;*    info ::%table ...                                                */
;*---------------------------------------------------------------------*/
(define-method (info obj::%table)
   (with-access::%table obj (border loc)
      (output-flush *margin*)
      (if border
	  (border-table->info obj)
	  (table->ascii obj info))
      (output-flush *margin*)))

;*---------------------------------------------------------------------*/
;*    border-table->info ...                                           */
;*---------------------------------------------------------------------*/
(define (border-table->info table)
   (table->ascii table info))

;*---------------------------------------------------------------------*/
;*    info ::%character ...                                            */
;*---------------------------------------------------------------------*/
(define-method (info obj::%character)
   (case (%character-value obj)
      ((copyright)
       (display "(c)"))
      ((#\space)
       (display #\space))
      ((#\tab)
       (display #\tab))))

;*---------------------------------------------------------------------*/
;*    info ::%hook ...                                                 */
;*---------------------------------------------------------------------*/
(define-method (info obj::%hook)
   (with-access::%hook obj (body before after process)
      (if (procedure? before)
	  (let ((bef (before)))
	     (if process (info bef))))
      (call-next-method)
      (if (procedure? after)
	  (let ((af (after)))
	     (if process (info af))))))

;*---------------------------------------------------------------------*/
;*    info ::%figure ...                                               */
;*---------------------------------------------------------------------*/
(define-method (info obj::%figure)
   (with-access::%figure obj (body legend number)
      (output-newline)
      (info body)
      (output-newline)
      (output-newline)
      (output "Fig. ")
      (output (number->string number))
      (output ": ")
      (info legend)
      (output-newline)))

;*---------------------------------------------------------------------*/
;*    info ::%footnote ...                                             */
;*---------------------------------------------------------------------*/
(define-method (info obj::%footnote)
   (with-access::%footnote obj (number note body)
      (info body)
      (output (string-append "(*" (number->string number) ")"))))
