#!/usr/bin/env cwl-runner

# This CWL file was automatically generated using CTDConverter.
# Visit https://github.com/WorkflowConversion/CTDConverter for more information.

baseCommand: alf
class: CommandLineTool
cwlVersion: v1.0
doc: "Compute pairwise similarity of sequences using alignment-free methods in IN.FASTA\
  \ and write out tab-delimited matrix with pairwise scores to OUT.TXT.\n\n\n\nFor\
  \ more information, visit http://www.seqan.de"
inputs:
- default: 'false'
  doc: When given, details about the progress are printed to the screen.
  id: param_verbose
  inputBinding:
    prefix: -verbose
  label: When given, details about the progress are printed to the screen.
  type:
  - 'null'
  - string
- doc: Name of the multi-FASTA input file.
  id: param_input-file
  inputBinding:
    prefix: -input-file
  label: Name of the multi-FASTA input file.
  type: File
- doc: Filename for output-file output file
  id: param_output-file_filename
  inputBinding:
    prefix: -output-file
  label: Filename for output-file output file
  type:
  - 'null'
  - string
- default: N2
  doc: Select method to use.
  id: param_method
  inputBinding:
    prefix: -method
  label: Select method to use.
  type:
  - 'null'
  - string
- default: '4'
  doc: Size of the k-mers.
  id: param_k-mer-size
  inputBinding:
    prefix: -k-mer-size
  label: Size of the k-mers.
  type:
  - 'null'
  - int
- default: '1'
  doc: Order of background Markov Model.
  id: param_bg-model-order
  inputBinding:
    prefix: -bg-model-order
  label: Order of background Markov Model.
  type:
  - 'null'
  - int
- default: input
  doc: Which strand to score.  Use both_strands to score both strands simultaneously.
  id: param_reverse-complement
  inputBinding:
    prefix: -reverse-complement
  label: Which strand to score.  Use both_strands to score both strands simultaneously.
  type:
  - 'null'
  - string
- default: '0'
  doc: Number of mismatches, one of 0 and 1.  When 1 is used, N2 uses the k-mer-neighbour
    with one mismatch.
  id: param_mismatches
  inputBinding:
    prefix: -mismatches
  label: Number of mismatches, one of 0 and 1.  When 1 is used, N2 uses the k-mer-neighbour
    with one mismatch.
  type:
  - 'null'
  - int
- default: '0.1'
  doc: Real-valued weight of counts for words with mismatches.
  id: param_mismatch-weight
  inputBinding:
    prefix: -mismatch-weight
  label: Real-valued weight of counts for words with mismatches.
  type:
  - 'null'
  - double
- doc: Filename for k-mer-weights-file output file
  id: param_k-mer-weights-file_filename
  inputBinding:
    prefix: -k-mer-weights-file
  label: Filename for k-mer-weights-file output file
  type:
  - 'null'
  - string
label: Alignment free sequence comparison
outputs:
- doc: Name of the file to which the tab-delimtied matrix with pairwise scores will
    be written to.  Default is to write to stdout.
  id: param_output-file
  label: Name of the file to which the tab-delimtied matrix with pairwise scores will
    be written to.  Default is to write to stdout.
  outputBinding:
    glob: $(inputs.param_output-file_filename)
  type:
  - 'null'
  - File
- doc: Print k-mer weights for every sequence to this file if given.
  id: param_k-mer-weights-file
  label: Print k-mer weights for every sequence to this file if given.
  outputBinding:
    glob: $(inputs.param_k-mer-weights-file_filename)
  type:
  - 'null'
  - File
