/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.DatabaseMaximumSizeReachedException;
import com.db4o.config.Configuration;
import com.db4o.config.QueryEvaluationMode;
import com.db4o.ext.Db4oDatabase;
import com.db4o.ext.OldFormatException;
import com.db4o.ext.SystemInfo;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.Hashtable4;
import com.db4o.foundation.IntArrayList;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Tree;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.Buffer;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.Const4;
import com.db4o.internal.ExternalObjectContainer;
import com.db4o.internal.IDHandler;
import com.db4o.internal.InternalObjectContainer;
import com.db4o.internal.LocalTransaction;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.PersistentBase;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.SystemData;
import com.db4o.internal.SystemInfoFileImpl;
import com.db4o.internal.Transaction;
import com.db4o.internal.TransactionalReferenceSystem;
import com.db4o.internal.TreeInt;
import com.db4o.internal.TreeIntObject;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.convert.ConversionStage;
import com.db4o.internal.convert.Converter;
import com.db4o.internal.fileheader.FileHeader;
import com.db4o.internal.fileheader.FileHeader1;
import com.db4o.internal.freespace.AbstractFreespaceManager;
import com.db4o.internal.freespace.FreespaceManager;
import com.db4o.internal.query.processor.QQuery;
import com.db4o.internal.query.result.AbstractQueryResult;
import com.db4o.internal.query.result.HybridQueryResult;
import com.db4o.internal.query.result.IdListQueryResult;
import com.db4o.internal.query.result.QueryResult;
import com.db4o.internal.slots.Pointer4;
import com.db4o.internal.slots.ReferencedSlot;
import com.db4o.internal.slots.Slot;

public abstract class LocalObjectContainer
extends ExternalObjectContainer
implements InternalObjectContainer {
    private static final int DEFAULT_FREESPACE_ID = 0;
    protected FileHeader _fileHeader;
    private Collection4 i_dirty;
    private FreespaceManager _freespaceManager;
    private boolean i_isServer = false;
    private Tree i_prefetchedIDs;
    private Hashtable4 i_semaphores;
    private int _blockEndAddress;
    private Tree _freeOnCommit;
    private SystemData _systemData;

    LocalObjectContainer(Configuration configuration, ObjectContainerBase objectContainerBase) {
        super(configuration, objectContainerBase);
    }

    public Transaction newTransaction(Transaction transaction, TransactionalReferenceSystem transactionalReferenceSystem) {
        return new LocalTransaction(this, transaction, transactionalReferenceSystem);
    }

    public FreespaceManager freespaceManager() {
        return this._freespaceManager;
    }

    public abstract void blockSize(int var1);

    public void blockSizeReadFromFile(int n) {
        this.blockSize(n);
        this.setRegularEndAddress(this.fileLength());
    }

    public void setRegularEndAddress(long l) {
        this._blockEndAddress = this.bytesToBlocks(l);
    }

    protected final void close2() {
        if (!this._config.isReadOnly()) {
            this.freeInternalResources();
            this.commitTransaction();
            this.shutdown();
        }
        this.shutdownObjectContainer();
    }

    protected abstract void freeInternalResources();

    public void commit1(Transaction transaction) {
        transaction.commit();
    }

    void configureNewFile() {
        this.newSystemData(this.configImpl().freespaceSystem());
        this.systemData().converterVersion(6);
        this.createStringIO(this._systemData.stringEncoding());
        this.generateNewIdentity();
        this._freespaceManager = AbstractFreespaceManager.createNew(this);
        this.blockSize(this.configImpl().blockSize());
        this._fileHeader = new FileHeader1();
        this.setRegularEndAddress(this._fileHeader.length());
        this.initNewClassCollection();
        this.initializeEssentialClasses();
        this._fileHeader.initNew(this);
        this._freespaceManager.onNew(this);
        this._freespaceManager.start(this._systemData.freespaceAddress());
    }

    private void newSystemData(byte by) {
        this._systemData = new SystemData();
        this._systemData.stringEncoding(this.configImpl().encoding());
        this._systemData.freespaceSystem(by);
    }

    public int converterVersion() {
        return this._systemData.converterVersion();
    }

    public abstract void copy(int var1, int var2, int var3, int var4, int var5);

    public long currentVersion() {
        return this._timeStampIdGenerator.lastTimeStampId();
    }

    void initNewClassCollection() {
        this.classCollection().initTables(1);
    }

    public final BTree createBTreeClassIndex(int n) {
        return new BTree(this._transaction, n, new IDHandler(this));
    }

    public final AbstractQueryResult newQueryResult(Transaction transaction) {
        return this.newQueryResult(transaction, this.config().queryEvaluationMode());
    }

    public final AbstractQueryResult newQueryResult(Transaction transaction, QueryEvaluationMode queryEvaluationMode) {
        if (queryEvaluationMode == QueryEvaluationMode.IMMEDIATE) {
            return new IdListQueryResult(transaction);
        }
        return new HybridQueryResult(transaction, queryEvaluationMode);
    }

    public final boolean delete4(Transaction transaction, ObjectReference objectReference, int n, boolean bl) {
        int n2 = objectReference.getID();
        StatefulBuffer statefulBuffer = this.readWriterByID(transaction, n2);
        if (statefulBuffer != null) {
            Object object = objectReference.getObject();
            if (object != null && !this.showInternalClasses() && Const4.CLASS_INTERNAL.isAssignableFrom(object.getClass())) {
                return false;
            }
            statefulBuffer.setCascadeDeletes(n);
            statefulBuffer.slotDelete();
            ClassMetadata classMetadata = objectReference.classMetadata();
            classMetadata.delete(statefulBuffer, object);
            return true;
        }
        return false;
    }

    public abstract long fileLength();

    public abstract String fileName();

    public void free(Slot slot) {
        if (slot.address() == 0) {
            return;
        }
        if (this._freespaceManager == null) {
            return;
        }
        Slot slot2 = this.toBlockedLength(slot);
        this._freespaceManager.free(slot2);
    }

    public Slot toBlockedLength(Slot slot) {
        return new Slot(slot.address(), this.bytesToBlocks(slot.length()));
    }

    public Slot toNonBlockedLength(Slot slot) {
        return new Slot(slot.address(), this.blocksToBytes(slot.length()));
    }

    public void free(int n, int n2) {
        this.free(new Slot(n, n2));
    }

    final void freePrefetchedPointers() {
        if (this.i_prefetchedIDs != null) {
            this.i_prefetchedIDs.traverse(new Visitor4(){

                public void visit(Object object) {
                    LocalObjectContainer.this.free(((TreeInt)object)._key, 8);
                }
            });
        }
        this.i_prefetchedIDs = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateNewIdentity() {
        Object object = this._lock;
        synchronized (object) {
            this.setIdentity(Db4oDatabase.generate());
        }
    }

    public AbstractQueryResult getAll(Transaction transaction) {
        return this.getAll(transaction, this.config().queryEvaluationMode());
    }

    public AbstractQueryResult getAll(Transaction transaction, QueryEvaluationMode queryEvaluationMode) {
        AbstractQueryResult abstractQueryResult = this.newQueryResult(transaction, queryEvaluationMode);
        abstractQueryResult.loadFromClassIndexes(this.classCollection().iterator());
        return abstractQueryResult;
    }

    public final int getPointerSlot() {
        int n = this.getSlot(8).address();
        ((LocalTransaction)this.systemTransaction()).writeZeroPointer(n);
        if (this._handlers.isSystemHandler(n)) {
            return this.getPointerSlot();
        }
        return n;
    }

    public Slot getSlot(int n) {
        int n2 = this.bytesToBlocks(n);
        Slot slot = this.getBlockedSlot(n2);
        return this.toNonBlockedLength(slot);
    }

    private final Slot getBlockedSlot(int n) {
        Slot slot;
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        if (this._freespaceManager != null && (slot = this._freespaceManager.getSlot(n)) != null) {
            return slot;
        }
        return this.appendBlocks(n);
    }

    protected final Slot appendBlocks(int n) {
        int n2 = this._blockEndAddress;
        int n3 = this._blockEndAddress + n;
        this.checkBlockedAddress(n3);
        this._blockEndAddress = n3;
        Slot slot = new Slot(n2, n);
        return slot;
    }

    final Slot appendBytes(long l) {
        Slot slot = this.appendBlocks(this.bytesToBlocks(l));
        return this.toNonBlockedLength(slot);
    }

    private void checkBlockedAddress(int n) {
        if (n < 0) {
            this.switchToReadOnlyMode();
            throw new DatabaseMaximumSizeReachedException();
        }
    }

    private void switchToReadOnlyMode() {
        this._config.readOnly(true);
    }

    void ensureLastSlotWritten() {
        if (this._blockEndAddress > this.bytesToBlocks(this.fileLength())) {
            StatefulBuffer statefulBuffer = this.getWriter(this.systemTransaction(), this._blockEndAddress - 1, this.blockSize());
            statefulBuffer.write();
        }
    }

    public Db4oDatabase identity() {
        return this._systemData.identity();
    }

    public void setIdentity(Db4oDatabase db4oDatabase) {
        this._systemData.identity(db4oDatabase);
        this._timeStampIdGenerator.next();
    }

    void initialize2() {
        this.i_dirty = new Collection4();
        super.initialize2();
    }

    boolean isServer() {
        return this.i_isServer;
    }

    public final Pointer4 newSlot(int n) {
        return new Pointer4(this.getPointerSlot(), this.getSlot(n));
    }

    public final int newUserObject() {
        return this.getPointerSlot();
    }

    public void prefetchedIDConsumed(int n) {
        this.i_prefetchedIDs = this.i_prefetchedIDs.removeLike(new TreeIntObject(n));
    }

    public int prefetchID() {
        int n = this.getPointerSlot();
        this.i_prefetchedIDs = Tree.add(this.i_prefetchedIDs, new TreeInt(n));
        return n;
    }

    public ReferencedSlot produceFreeOnCommitEntry(int n) {
        TreeInt treeInt = TreeInt.find(this._freeOnCommit, n);
        if (treeInt != null) {
            return (ReferencedSlot)treeInt;
        }
        ReferencedSlot referencedSlot = new ReferencedSlot(n);
        this._freeOnCommit = Tree.add(this._freeOnCommit, referencedSlot);
        return referencedSlot;
    }

    public void reduceFreeOnCommitReferences(ReferencedSlot referencedSlot) {
        if (referencedSlot.removeReferenceIsLast()) {
            this._freeOnCommit = this._freeOnCommit.removeNode(referencedSlot);
        }
    }

    public void freeDuringCommit(ReferencedSlot referencedSlot, Slot slot) {
        this._freeOnCommit = referencedSlot.free(this, this._freeOnCommit, slot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void raiseVersion(long l) {
        Object object = this.lock();
        synchronized (object) {
            this._timeStampIdGenerator.setMinimumNext(l);
        }
    }

    public StatefulBuffer readWriterByID(Transaction transaction, int n) {
        return (StatefulBuffer)this.readReaderOrWriterByID(transaction, n, false);
    }

    public StatefulBuffer[] readWritersByIDs(Transaction transaction, int[] nArray) {
        StatefulBuffer[] statefulBufferArray = new StatefulBuffer[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            statefulBufferArray[i] = nArray[i] == 0 ? null : (StatefulBuffer)this.readReaderOrWriterByID(transaction, nArray[i], false);
        }
        return statefulBufferArray;
    }

    public Buffer readReaderByID(Transaction transaction, int n) {
        return this.readReaderOrWriterByID(transaction, n, true);
    }

    private final Buffer readReaderOrWriterByID(Transaction transaction, int n, boolean bl) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        Slot slot = ((LocalTransaction)transaction).getCurrentSlotOfID(n);
        if (slot == null) {
            return null;
        }
        if (slot.address() == 0) {
            return null;
        }
        Buffer buffer = null;
        if (bl) {
            buffer = new Buffer(slot.length());
        } else {
            buffer = this.getWriter(transaction, slot.address(), slot.length());
            ((StatefulBuffer)buffer).setID(n);
        }
        buffer.readEncrypt(this, slot.address());
        return buffer;
    }

    protected boolean doFinalize() {
        return this._fileHeader != null;
    }

    void readThis() throws OldFormatException {
        this.newSystemData((byte)1);
        this.blockSizeReadFromFile(1);
        this._fileHeader = FileHeader.readFixedPart(this);
        this.createStringIO(this._systemData.stringEncoding());
        this.classCollection().setID(this._systemData.classCollectionID());
        this.classCollection().read(this.systemTransaction());
        Converter.convert(new ConversionStage.ClassCollectionAvailableStage(this));
        this.readHeaderVariablePart();
        if (!this._config.isReadOnly()) {
            this._freespaceManager = AbstractFreespaceManager.createNew(this, this._systemData.freespaceSystem());
            this._freespaceManager.read(this._systemData.freespaceID());
            this._freespaceManager.start(this._systemData.freespaceAddress());
        }
        if (this.needFreespaceMigration()) {
            this.migrateFreespace();
        }
        if (this._config.isReadOnly()) {
            return;
        }
        this.writeHeader(true, false);
        LocalTransaction localTransaction = (LocalTransaction)this._fileHeader.interruptedTransaction();
        if (localTransaction != null && !this.configImpl().commitRecoveryDisabled()) {
            localTransaction.writeOld();
        }
        if (Converter.convert(new ConversionStage.SystemUpStage(this))) {
            this._systemData.converterVersion(6);
            this._fileHeader.writeVariablePart(this, 1);
            this.transaction().commit();
        }
    }

    private boolean needFreespaceMigration() {
        byte by = this._systemData.freespaceSystem();
        byte by2 = this.configImpl().freespaceSystem();
        return (by2 != 0 || by == 1) && this._freespaceManager.systemType() != by2;
    }

    private void migrateFreespace() {
        FreespaceManager freespaceManager = this._freespaceManager;
        this._freespaceManager = AbstractFreespaceManager.createNew(this, this.configImpl().freespaceSystem());
        this.systemData().freespaceAddress(0);
        this.systemData().freespaceSystem(this.configImpl().freespaceSystem());
        this._freespaceManager.start(this._freespaceManager.onNew(this));
        AbstractFreespaceManager.migrate(freespaceManager, this._freespaceManager);
        this._fileHeader.writeVariablePart(this, 1);
    }

    private void readHeaderVariablePart() {
        this._fileHeader.readVariablePart(this);
        this.setNextTimeStampId(this.systemData().lastTimeStampID());
    }

    public final int createFreespaceSlot(byte by) {
        this._systemData.freespaceAddress(AbstractFreespaceManager.initSlot(this));
        this._systemData.freespaceSystem(by);
        return this._systemData.freespaceAddress();
    }

    public int ensureFreespaceSlot() {
        int n = this.systemData().freespaceAddress();
        if (n == 0) {
            return this.createFreespaceSlot(this.systemData().freespaceSystem());
        }
        return n;
    }

    public final void releaseSemaphore(String string) {
        this.releaseSemaphore(null, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void releaseSemaphore(Transaction transaction, String string) {
        Object object = this._lock;
        synchronized (object) {
            if (this.i_semaphores == null) {
                return;
            }
        }
        object = this.i_semaphores;
        synchronized (object) {
            transaction = this.checkTransaction(transaction);
            if (this.i_semaphores != null && transaction == this.i_semaphores.get(string)) {
                this.i_semaphores.remove(string);
                this.i_semaphores.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSemaphores(Transaction transaction) {
        if (this.i_semaphores != null) {
            Hashtable4 hashtable4;
            Hashtable4 hashtable42 = hashtable4 = this.i_semaphores;
            synchronized (hashtable42) {
                hashtable4.forEachKeyForIdentity(new Visitor4(){

                    public void visit(Object object) {
                        hashtable4.remove(object);
                    }
                }, transaction);
                hashtable4.notifyAll();
            }
        }
    }

    public final void rollback1(Transaction transaction) {
        transaction.rollback();
    }

    public final void setDirtyInSystemTransaction(PersistentBase persistentBase) {
        persistentBase.setStateDirty();
        persistentBase.cacheDirty(this.i_dirty);
    }

    public final boolean setSemaphore(String string, int n) {
        return this.setSemaphore(null, string, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean setSemaphore(Transaction transaction, String string, int n) {
        if (string == null) {
            throw new NullPointerException();
        }
        Object object = this._lock;
        synchronized (object) {
            if (this.i_semaphores == null) {
                this.i_semaphores = new Hashtable4(10);
            }
        }
        object = this.i_semaphores;
        synchronized (object) {
            transaction = this.checkTransaction(transaction);
            Object object2 = this.i_semaphores.get(string);
            if (object2 == null) {
                this.i_semaphores.put(string, (Object)transaction);
                return true;
            }
            if (transaction == object2) {
                return true;
            }
            long l = System.currentTimeMillis() + (long)n;
            long l2 = n;
            while (l2 > 0L) {
                try {
                    this.i_semaphores.wait(l2);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.classCollection() == null) {
                    return false;
                }
                object2 = this.i_semaphores.get(string);
                if (object2 == null) {
                    this.i_semaphores.put(string, (Object)transaction);
                    return true;
                }
                l2 = l - System.currentTimeMillis();
            }
            return false;
        }
    }

    public void setServer(boolean bl) {
        this.i_isServer = bl;
    }

    public abstract void syncFiles();

    public String toString() {
        return this.fileName();
    }

    public void shutdown() {
        this.writeHeader(false, true);
    }

    public final void commitTransaction() {
        this._transaction.commit();
    }

    public abstract void writeBytes(Buffer var1, int var2, int var3);

    public final void writeDirty() {
        this.writeCachedDirty();
        this.writeVariableHeader();
    }

    private void writeCachedDirty() {
        Iterator4 iterator4 = this.i_dirty.iterator();
        while (iterator4.moveNext()) {
            PersistentBase persistentBase = (PersistentBase)iterator4.current();
            persistentBase.write(this.systemTransaction());
            persistentBase.notCachedDirty();
        }
        this.i_dirty.clear();
    }

    public final void writeEncrypt(Buffer buffer, int n, int n2) {
        this._handlers.encrypt(buffer);
        this.writeBytes(buffer, n, n2);
        this._handlers.decrypt(buffer);
    }

    protected void writeVariableHeader() {
        if (!this._timeStampIdGenerator.isDirty()) {
            return;
        }
        this._systemData.lastTimeStampID(this._timeStampIdGenerator.lastTimeStampId());
        this._fileHeader.writeVariablePart(this, 2);
        this._timeStampIdGenerator.setClean();
    }

    void writeHeader(boolean bl, boolean bl2) {
        int n = 0;
        if (bl2) {
            n = this._freespaceManager.write();
            this._freespaceManager = null;
        }
        StatefulBuffer statefulBuffer = this.getWriter(this.systemTransaction(), 0, this._fileHeader.length());
        this._fileHeader.writeFixedPart(this, bl, bl2, statefulBuffer, this.blockSize(), n);
        if (bl2) {
            this.ensureLastSlotWritten();
        }
        this.syncFiles();
    }

    public final void writeNew(Transaction transaction, Pointer4 pointer4, ClassMetadata classMetadata, Buffer buffer) {
        this.writeEncrypt(buffer, pointer4.address(), 0);
        if (classMetadata == null) {
            return;
        }
        if (this.maintainsIndices()) {
            classMetadata.addToIndex(this, transaction, pointer4.id());
        }
    }

    public abstract void overwriteDeletedBytes(int var1, int var2);

    public void overwriteDeletedBlockedSlot(Slot slot) {
        this.overwriteDeletedBytes(slot.address(), this.blocksToBytes(slot.length()));
    }

    public final void writeTransactionPointer(int n) {
        this._fileHeader.writeTransactionPointer(this.systemTransaction(), n);
    }

    public final void getSlotForUpdate(StatefulBuffer statefulBuffer) {
        Slot slot = this.getSlotForUpdate(statefulBuffer.getTransaction(), statefulBuffer.getID(), statefulBuffer.length());
        statefulBuffer.address(slot.address());
    }

    public final Slot getSlotForUpdate(Transaction transaction, int n, int n2) {
        Slot slot = this.getSlot(n2);
        transaction.produceUpdateSlotChange(n, slot);
        return slot;
    }

    public final void writeUpdate(Transaction transaction, Pointer4 pointer4, ClassMetadata classMetadata, Buffer buffer) {
        int n = pointer4.address();
        if (n == 0) {
            n = this.getSlotForUpdate(transaction, pointer4.id(), pointer4.length()).address();
        }
        this.writeEncrypt(buffer, n, 0);
    }

    public void setNextTimeStampId(long l) {
        this._timeStampIdGenerator.setMinimumNext(l);
        this._timeStampIdGenerator.setClean();
    }

    public SystemInfo systemInfo() {
        return new SystemInfoFileImpl(this);
    }

    public FileHeader getFileHeader() {
        return this._fileHeader;
    }

    public void installDebugFreespaceManager(AbstractFreespaceManager abstractFreespaceManager) {
        this._freespaceManager = abstractFreespaceManager;
    }

    public SystemData systemData() {
        return this._systemData;
    }

    public long[] getIDsForClass(Transaction transaction, ClassMetadata classMetadata) {
        final IntArrayList intArrayList = new IntArrayList();
        classMetadata.index().traverseAll(transaction, new Visitor4(){

            public void visit(Object object) {
                intArrayList.add((Integer)object);
            }
        });
        return intArrayList.asLong();
    }

    public QueryResult classOnlyQuery(Transaction transaction, ClassMetadata classMetadata) {
        if (!classMetadata.hasClassIndex()) {
            return null;
        }
        AbstractQueryResult abstractQueryResult = this.newQueryResult(transaction);
        abstractQueryResult.loadFromClassIndex(classMetadata);
        return abstractQueryResult;
    }

    public QueryResult executeQuery(QQuery qQuery) {
        AbstractQueryResult abstractQueryResult = this.newQueryResult(qQuery.getTransaction());
        abstractQueryResult.loadFromQuery(qQuery);
        return abstractQueryResult;
    }

    public LocalTransaction getLocalSystemTransaction() {
        return (LocalTransaction)this.systemTransaction();
    }

    public void onCommittedListener() {
    }
}

