# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014 Ralph Amissah,
   All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Git
   <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=blob;f=lib/sisu/v6/se_envcall.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: system environment, resource control and configuration details

=end
module SiSU_Env_Call
  begin
    require 'singleton'
  rescue LoadError
    SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:fuchsia).
      error('singleton NOT FOUND (LoadError)')
  end
  class EnvCall
    @@rc,@@fns,@@fnn,@@fnb,@@fnt,@@flv,@@fnz=nil,nil,nil,nil,nil,nil,nil
    @@ad={}
    attr_accessor :rc,:fnn,:fnb,:fnt,:fnv,:fnz,:ad
    def initialize(fns='')
      @fns=fns
      @sys=SiSU_Info_Sys::InfoSystem.instance
      get_init=SiSU_Env::GetInit.new
      @rc=get_init.sisu_yaml.rc
      @ad=get_init.ads
      if @fns \
      and @fns != '' \
      and @fns !=@@fns
        @@fns,@@fnn,@@fnb,@@fnt,@@flv,@@fnz=@fns,nil,nil,nil,nil,nil
      end
      if @fns \
      and @fns != '' #watch
        m=/((.+?)(?:\~\w\w(?:_\w\w)?)?)\.((?:-|ssm\.)?sst|ssm|ssi)$/
        @@fnn ||=@fns[m,1]
        @@fnb ||=@fns[m,2]
        @@fnt ||=@fns[m,3]
        @@flv ||=document_language_versions_found[:f]
        unless @@fns =~/\S+?\.txz/
          @@fnz ||=if @@fns =~/(?:\~\S{2,3})?\.(?:ssm\.sst|ssm)$/; @@fnb + '.ssm.txz'
          elsif @@fnb; @@fnb + '.sst.txz'
          else '' # e.g. termsheet
          end
        end
      end
      @fnn,@fnb,@fnt,@flv,@fnz=@@fnn,@@fnb,@@fnt,@@flv,@@fnz
    end
    def default_language?
      if @rc \
      && defined? @rc['language_default']
        if (@rc['language_default'].is_a?(String)) \
        && (@rc['language_default'] =~/#{Px[:lng_lst_rgx]}/)
          @rc['language_default']
        else 'en'
        end
      else 'en'
      end
    end
    def mono_multi_lingual?
      if @rc \
      && defined? @rc['output_dir_structure_by']
        if @rc['output_dir_structure_by'] \
        =~/dump/
          :mono
        elsif @rc['output_dir_structure_by'] \
        =~/language|redirect/
          :multi
        elsif @rc['output_dir_structure_by'] \
        =~/monolingual|filetype_mono|filenaneme_mono/
          :mono
        else :multi
        end
      else :multi
      end
    end
    def output_dir_structure
      def by?
        output_structure=:filename #set default output structure
        if @rc \
        && defined? @rc['output_dir_structure_by']
          output_structure=if (@rc['output_dir_structure_by'] =~/dump/) \
          or ((defined? @rc['output_structure']['dump']) \
          && @rc['output_structure']['dump'] ==true)
            :dump
          elsif (@rc['output_dir_structure_by'] =~/redirect/) \
          or ((defined? @rc['output_structure']['redirect']) \
          && @rc['output_structure']['redirect'] ==true)
            :redirect
          elsif (@rc['output_dir_structure_by'] =~/language/) \
          or ((defined? @rc['output_structure']['by_language']) \
          && @rc['output_structure']['by_language'] ==true)
            :language
          elsif (@rc['output_dir_structure_by'] =~/filetype/) \
          or ((defined? @rc['output_structure']['by_filetype']) \
          && @rc['output_structure']['by_filetype'] ==true)
            :filetype
          elsif (@rc['output_dir_structure_by'] =~/filename/) \
          or ((defined? @rc['output_structure']['by_filename']) \
          && @rc['output_structure']['by_filename'] ==true)
            :filename
          else #set default
            :language
          end
        else #set default
          :language
        end
      end
      def dump?
        ((by?) ==:dump) \
        ? true
        : false
      end
      def redirect?
        ((by?) ==:redirect) \
        ? true
        : false
      end
      def by_language_code?
        ((by?) ==:language) \
        ? true
        : false
      end
      def by_filetype?
        ((by?) ==:filetype) \
        ? true
        : false
      end
      def by_filename?
        ((by?) ==:filename) \
        ? true
        : false
      end
      def multilingual?
        by_language_code?
      end
      self
    end
    def document_language_versions_found #REVISIT
      @fn={}
      filename=(@fns =~/\.ssm\.sst$/) \
      ? @fns.gsub(/\.ssm\.sst$/,'.ssm')
      : @fns
      if filename.is_a?(String) \
      and not filename.empty?
        if output_dir_structure.by_language_code?
          m=/((.+?)(?:\~\w{2,3})?)\.(sst|ssm)$/
          @fn[:b],@fn[:m],@fn[:t]=filename[m,1],filename[m,2],filename[m,3]
        else m=/(.+?)\.(sst|ssm)$/
          @fn[:b]=@fn[:m]=filename[m,1]
          @fn[:t]=filename[m,2]
        end
      end
      lng_base=SiSU_Env::InfoEnv.new.language_default_set
      lang=SiSU_Env::StandardiseLanguage.new
      langs=lang.codes
      x=[]
      if FileTest.file?("#{@fn[:m]}.#{@fn[:t]}")
        n=@fn[:m].gsub(/^.+?\//,'')
        n =n + '.' + @fn[:t]
        x << { f: "#{@fn[:m]}.#{@fn[:t]}", l: lng_base, n: n }
      end
      langs.each do |l|
        lng=SiSU_Env::StandardiseLanguage.new(l)
        if FileTest.file?("#{@fn[:m]}~#{lng.code}.#{@fn[:t]}")
          x << { f: "#{@fn[:m]}~#{lng.code}.#{@fn[:t]}", l: lng.code }
        elsif FileTest.file?("#{@fn[:m]}~#{lng.name}.#{@fn[:t]}")
          x << { f: "#{@fn[:m]}~#{lng.name}.#{@fn[:t]}", l: lng.code }
        end
        if FileTest.file?("#{lng.code}/#{@fn[:m]}~#{lng.code}.#{@fn[:t]}")
          if FileTest.file?("#{lng.code}/#{@fn[:m]}~#{lng.code}.#{@fn[:t]}")
            x << { f: "#{lng.code}/#{@fn[:m]}~#{lng.code}.#{@fn[:t]}", l: lng.code }
          elsif FileTest.file?("#{lng.code}/#{@fn[:m]}~#{lng.name}.#{@fn[:t]}")
            x << { f: "#{lng.code}/#{@fn[:m]}~#{lng.name}.#{@fn[:t]}", l: lng.code }
          end
        end
        if FileTest.file?("#{lng.code}/#{@fn[:m]}.#{@fn[:t]}")
          if FileTest.file?("#{lng.code}/#{@fn[:m]}.#{@fn[:t]}")
            x << { f: "#{lng.code}/#{@fn[:m]}.#{@fn[:t]}", l: lng.code }
          elsif FileTest.file?("#{lng.code}/#{@fn[:m]}.#{@fn[:t]}")
            x << { f: "#{lng.code}/#{@fn[:m]}.#{@fn[:t]}", l: lng.code }
          end
        end
      end
      @fn[:f]=x
      @fn
    end
    def published_manifests?(output_base)
      @fn={}
      @m=[]
      unless (@fns.nil? \
      or @fns.empty?)
        if output_dir_structure.by_language_code?
          m=/((.+?)(?:\~\w{2,3})?)\.((?:-|ssm\.)?sst$)/
          @fn[:b],@fn[:m],@fn[:t]=@fns[m,1],@fns[m,2],@fns[m,3]
        else m=/(.+?)\.((?:-|ssm\.)?sst$)/
          @fn[:b]=@fn[:m]=@fns[m,1]
          @fn[:t]=@fns[m,2]
        end
      end
      lang=SiSU_Env::StandardiseLanguage.new
      langs=lang.codes
      x=[]
      if FileTest.file?("#{@fn[:m]}.#{@fn[:t]}"); x << "#{@fn[:m]}.#{@fn[:t]}"
      end
      dir=SiSU_Env::InfoEnv.new(@fns)
      @m << { m: 'sisu_manifest.html', l: 'English' } #fix later, default language
      langs.each do |l|
        lng=SiSU_Env::StandardiseLanguage.new(l)
        fns_c="#{@fn[:m]}~#{lng.code}.#{@fn[:t]}"
        fns_l="#{@fn[:m]}~#{lng.name}.#{@fn[:t]}"
        if FileTest.file?(fns_c)
          fn_set_lang=SiSU_Env::StandardiseLanguage.new.
            file_to_language(fns_c) #reconsider file_to_language
          lng=fn_set_lang[:n]
          fn=SiSU_Env::EnvCall.new(fns_c).lang(fn_set_lang[:c])
          @m << { m: fn[:manifest], l: lng }
        elsif FileTest.file?(fns_l)
          fn_set_lang=SiSU_Env::StandardiseLanguage.new.
            file_to_language(fns_l) #reconsider file_to_language
          @fnl=dir.i18n.lang_filename(fn_set_lang[:c])
          fn=SiSU_Env::EnvCall.new(fns_l).lang(fn_set_lang[:c])
          @m << { m: fn[:manifest], l: lng }
        end
      end
      @m=@m.uniq
    end
    def filename(code,name,suffix)
      "#{name}#{suffix}"
    end
    def lang(code)
      {
        html:            filename(code,'','.html'),
        book_index:      filename(code,'book_index','.html'),
        concordance:     filename(code,'concordance','.html'),
        sax:             filename(code,'sax','.xml'),
        dom:             filename(code,'dom','.xml'),
        docbook:         filename(code,'docbook','.xml'),
        xhtml:           filename(code,'scroll','.xhtml'),
        pdf_l:           filename(code,'','.pdf'),
        pdf_p:           filename(code,'','.pdf'),
        pdf_l_a4:        filename(code,"a4",'.pdf'),
        pdf_p_a4:        filename(code,"a4",'.pdf'),
        pdf_l_a5:        filename(code,"a5",'.pdf'),
        pdf_p_a5:        filename(code,"a5",'.pdf'),
        pdf_l_b5:        filename(code,"b5",'.pdf'),
        pdf_p_b5:        filename(code,"b5",'.pdf'),
        pdf_l_letter:    filename(code,"letter",'.pdf'),
        pdf_p_letter:    filename(code,"letter",'.pdf'),
        pdf_l_legal:     filename(code,"legal",'.pdf'),
        pdf_p_legal:     filename(code,"legal",'.pdf'),
        toc:             filename(code,'toc','.html'),
        doc:             filename(code,fnb,'.html'),
        index:           filename(code,'index','.html'),
        po:              filename(code,@fns,'.po'),
        pot:             filename(code,@fns,'.pot'),
        odf:             filename(code,'','.odt'),
        epub:            filename(code,'','.epub'),
        plain:           filename(code,'','.txt'),
        qrcode:          filename(code,'','.jpg'),
        manpage:         filename(code,'','.1'),          #fix, section number
        wiki:            filename(code,'wiki','.txt'),
        digest:          filename(code,'digest','.txt'),
        metadata:        filename(code,'metadata','.html'), #chk
        manifest:        filename(code,'manifest','.html'),
        oai_pmh:         filename(code,'oai_pmh','.xml'),
        sitemap:         filename(code,'sitemap','.xml'),
        sitemap_touch:   filename(code,"sitemap_#{fnb}",'.xml'),
        sxs:             filename(code,fnb,'.sxs.xml'),
        sxd:             filename(code,fnb,'.sxd.xml'),
        sxn:             filename(code,fnb,'.sxn.xml'),
        sisupod:         filename(nil,@fnz,''),
        book_idx_html:   filename(code,'book_index','.html'),
        book_idx_epub:   filename(code,'book_index','.xhtml'),
        epub_concord:    filename(code,'concordance','.xhtml'),
      }
    end
  end
end
__END__
