#include "sjog_list_callbacks.h"

/* Hides the application.
 */
gint
sjog_list_signal_delete_event_callback(GtkWidget * widget, GdkEvent * event,
                                       gpointer * data)
{
   D_ENTER;

   gtk_widget_hide_all(widget);

   return TRUE;
}

/* Callback called when a list item is selected.
 * Just keeps track of the selected item position.
 */
void
sjog_list_row_selected_callback(GtkWidget * widget, gint row, gint col,
                                GdkEventButton * event, gpointer * data)
{
   D_ENTER;

   selectedIndex = row;
}

int
sjog_list_signal_realize_callback(GtkWidget * widget)
{
   gint screenW = gdk_screen_width();
   gint screenH = gdk_screen_height();
   gint windowW = widget->allocation.width;
   gint windowH = widget->allocation.height;
   gint positionX, positionY;

   switch (listWindowGravity)
   {
     case SJOG_GRAVITY_NONE:
        return;
     case SJOG_GRAVITY_TOP_LEFT:
        positionX = 0;
        positionY = 0;
        break;
     case SJOG_GRAVITY_TOP:
        positionX = (screenW / 2) - (windowW / 2);
        positionY = 0;
        break;
     case SJOG_GRAVITY_TOP_RIGHT:
        positionX = screenW - windowW;
        positionY = 0;
        break;
     case SJOG_GRAVITY_LEFT:
        positionX = 0;
        positionY = (screenH / 2) - (windowH / 2);
        break;
     case SJOG_GRAVITY_CENTER:
        positionX = (screenW / 2) - (windowW / 2);
        positionY = (screenH / 2) - (windowH / 2);
        break;
     case SJOG_GRAVITY_RIGHT:
        positionX = screenW - windowW;
        positionY = (screenH / 2) - (windowH / 2);
        break;
     case SJOG_GRAVITY_BOTTOM_LEFT:
        positionX = 0;
        positionY = screenH - windowH;
        break;
     case SJOG_GRAVITY_BOTTOM:
        positionX = (screenW / 2) - (windowH / 2);
        positionY = screenH - windowH;
        break;
     case SJOG_GRAVITY_BOTTOM_RIGHT:
        positionX = screenW - windowW;
        positionY = screenH - windowH;
   }

   gtk_widget_set_uposition(widget, positionX, positionY);
   return TRUE;
}

int
sjog_list_timer_callback(gpointer * data)
{

   D_ENTER;

   sjog_list_hide();

   return FALSE;
}
