/* SNAC

 * Copyright (C) 1999 the Free Software Foundation

 * Authors : Matias Mutchinick, Jan Struyf          

 *         

 * This program is free software; you can redistribute it and/or modify

 * it under the terms of the GNU General Public License as published by

 * the Free Software Foundation; either version 2 of the License, or

 * (at your option) any later version.

 *

 * This program is distributed in the hope that it will be useful,

 * but WITHOUT ANY WARRANTY; without even the implied warranty of

 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the

 * GNU General Public License for more details.

 *

 * You should have received a copy of the GNU General Public License

 * along with this program; if not, write to the Free Software

 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */



#include <gnome.h>

#include "ag_defs.h"

#include "cursor.h"

#include "hstack.h"

#include "ag_status.h"

#include "ag_text.h"

#include "errorstring.h"

#include "formatstring.h"

#include "preferences.h"



extern AgError      errState;

extern gint         exe_state;

extern AgModePref   mode_prefs;

extern GtkWidget   *input_text;

extern GtkWidget   *output_text;

static gchar        result_str[MAX_FORMAT_SIZE]="";





void

ag_handler_ans(gpointer data)

{

	ag_status_prepare_display();

	ag_text_insert(GTK_TEXT(input_text),result_str,-1);

	ag_status_expr_modified();	

}





void

ag_handler_cursor_forward(gpointer data)

{

	ag_status_prepare_display();

	ag_cursor_move_forward();

	ag_history_stack_rewind();

}





void

ag_handler_cursor_backward(gpointer data)

{

	ag_status_prepare_display();

	ag_cursor_move_backward();

	ag_history_stack_rewind();

}





void

ag_handler_hstack_up(gpointer data)

{

	ag_status_prepare_display();

	ag_history_stack_up();

	ag_status_expr_modified();

}





void

ag_handler_hstack_down(gpointer data)

{

	ag_status_prepare_display();

	ag_history_stack_down();

	ag_status_expr_modified();

}



/*

 * ag_get_expr_n_eval

 * gets the expression from the text, sends it to the solving

 * functions, and then displays the formated result.

 * It also redraws the expression, with the special atributes

 * (error hilighting) when needed.

 */

void 

ag_get_expr_n_eval()

{	

	gint   text_len, expr_len;

	gchar *expr_str;

	

	

	text_len = gtk_text_get_length(GTK_TEXT(input_text)); 

	expr_len = text_len-1;

	

	if(expr_len == 0)

		return;

	

	gtk_text_freeze(GTK_TEXT(input_text));		

	

	expr_str = gtk_editable_get_chars(GTK_EDITABLE(input_text),0,expr_len);

	gtk_text_set_point(GTK_TEXT(input_text),0);

	gtk_text_forward_delete(GTK_TEXT(input_text),text_len);

	

	str_result_of_expr(expr_str,result_str);

	

	ag_text_insert(GTK_TEXT(output_text),result_str,-1);      

	

	if(errState.state != 0){  /* If an error ocurred */

		

		ag_text_insert(GTK_TEXT(input_text),expr_str,

			       errState.start);

		ag_text_insert_error(GTK_TEXT(input_text), 

				     &expr_str[errState.start],

				     errState.end-errState.start);

		ag_text_insert(GTK_TEXT(input_text),

			       &expr_str[errState.end],-1);

		ag_text_insert_cursor(GTK_TEXT(input_text)," ");     

		

		gtk_text_set_point(GTK_TEXT(input_text),expr_len);

		strcpy(result_str,"\0");

		

	} else { /* Executed OK */ 

		exe_state = 1;

		ag_text_insert(GTK_TEXT(input_text),expr_str,-1);

		ag_history_stack_push_item(expr_str);

	}

	

	g_free(expr_str);

	gtk_text_thaw(GTK_TEXT(input_text));

}



void

ag_recalc_expr() {

	if (exe_state == 1) {

		ag_status_prepare_display();

		ag_history_stack_up();

		ag_status_expr_modified();

		ag_get_expr_n_eval();

	}

}



/*

 * ag_keypath_handler

 * handles the action of some keytable buttons,

 * for each button a special action, the default

 * is writing to the input text. A pointer to 

 * this function is passed to the function

 * make_keytable

 */

void

ag_keypath_handler(gpointer data)

{  

	/* Execute? */

	if( !strcmp((gchar *) data,"Exe") ){ 

		if(!exe_state && !errState.state)

			ag_get_expr_n_eval();

		return;

	}

	

	ag_status_prepare_display();

	gtk_text_freeze(GTK_TEXT(input_text));		

	

	/* Auto answer */

	if (strlen((gchar *) data) == 1) {

		if (strchr("+-*/", ((gchar*)data)[0]) != NULL && exe_state == 1)

			ag_handler_ans(NULL);

	}

	

	/* DEl, AC or other */

	if (!strcmp((gchar *) data,"Del")) {

		ag_text_backward_delete(GTK_TEXT(input_text),1);	

 	} else if (!strcmp((gchar *) data,"AC")){

		ag_text_ac_input(GTK_TEXT(input_text));

		ag_text_delete_all(GTK_TEXT(output_text));

	} else {

		ag_text_insert(GTK_TEXT(input_text),(gchar *) data,-1); 

	}

		

	gtk_text_thaw(GTK_TEXT(input_text));		

	ag_status_expr_modified();

	ag_history_stack_rewind();

}



/* 

 * This number should be large enough to be visually noticeable,

 * but small enough to not allow the user to perform other actions.

 * Author: John Sullivan <sullivan@eazel.com>

 * From: Nautilus

 */

#define BUTTON_AUTO_HIGHLIGHT_MILLISECONDS    100



static gboolean

finish_button_activation (gpointer data)

{

    GtkButton *button;

    

    button = GTK_BUTTON (data);



    if (!button->in_button) {

        gtk_button_clicked (button);

    }

    gtk_button_released (button);



    return FALSE;  

}



/**

 * nautilus_gtk_button_auto_click:

 * 

 * Programatically activate a button as if the user had clicked on it,

 * including briefly drawing the button's pushed-in state.

 * @button: Any GtkButton.

 * Author: John Sullivan <sullivan@eazel.com>

 * From: Nautilus 

 **/

void

nautilus_gtk_button_auto_click (GtkButton *button)

{

    g_return_if_fail (GTK_IS_BUTTON (button));



    if (!GTK_WIDGET_IS_SENSITIVE (GTK_WIDGET (button))) {

        return;

    }



    button->in_button = TRUE;

    gtk_button_pressed (button);

    button->in_button = FALSE;



    /* FIXME bugzilla.eazel.com 2562:

     * Nothing is preventing other events from occuring between

     * now and when this timeout function fires, which means in

     * theory the user could click on a different row or otherwise

     * get in between the double-click and the button activation.

     * In practice the timeout is short enough that this probably

     * isn't a problem.

     */

    g_timeout_add (BUTTON_AUTO_HIGHLIGHT_MILLISECONDS,

               finish_button_activation, button);

}



/*

 * ag_handle_keyboard_input

 */

gboolean

ag_handle_keyboard_input (GtkWidget        *widget,

			  GdkEventKey      *event,

			  void             *data)

{

	GtkWidget* button = NULL;

	gint slen = 0;

	gchar sinput;

	

	if ((event->state & (GDK_CONTROL_MASK | GDK_MOD1_MASK)) == 0) {				

	

		switch(event->keyval) { 

			case GDK_Return:				

			case GDK_KP_Enter:

				button = ag_get_button_map(AG_KEY_EXE);

				break;



			case GDK_BackSpace:

			case GDK_Delete:			

				button = ag_get_button_map(AG_KEY_DEL);

				break;

	

			case GDK_Up:

				button = ag_get_button_map(AG_KEY_H_UP);

				break;



			case GDK_Down:

				button = ag_get_button_map(AG_KEY_H_DOWN);

				break;

		

			case GDK_Left: 

				button = ag_get_button_map(AG_KEY_BACKWARD);

				break;

		

			case GDK_Right:

				button = ag_get_button_map(AG_KEY_FORWARD);

				break;

	

			case GDK_Escape:

				button = ag_get_button_map(AG_KEY_AC);

				break;



			default: 

				slen = strlen(event->string);

				if (slen == 1) {

					sinput = event->string[0];

					button = ag_get_button_map_char(sinput);

					if (button == NULL && sinput >= ' ') {

						ag_keypath_handler((gpointer) event->string );

						gtk_signal_emit_stop_by_name(GTK_OBJECT(widget),"key-press-event");

					}

				}

		}

		

		if (button != NULL) {

			nautilus_gtk_button_auto_click(GTK_BUTTON(button));

			gtk_signal_emit_stop_by_name(GTK_OBJECT(widget),"key-press-event");			

		}							

	}

	return TRUE;

}







