/* SNAC
 * Copyright (C) 1999 the Free Software Foundation
 * Authors : Matias Mutchinick 
 *         
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <stdlib.h>
#include <gnome.h>
#include "ag_defs.h"
#include "preferences.h"
#include "handlers.h"

/*
 * Declared in preferences.c
 * AgModePrefs - defined in preferences
 * Holds the information about the calc modes,
 */
extern AgModePref mode_prefs;



/* 
 * ag_create_option_menu
 * @labels   : an arry of pointers of the labels for the menu  
 * @def_item : the label of the item to be set as default 
 * @func     : the function that will be called when an item is activated 
 * Create an option menu, this is where we will select 
 * the calculator modes
 */ 
GtkWidget *
ag_create_option_menu(gchar         *labels[],
		      gchar         *def_item,
		      void         (* func)(gpointer))
{
  
	GtkWidget   *opt_menu;
	GtkWidget   *menu;
	GtkWidget   *item;
	gint         def_item_pos = 0, i = 0;
	
	
	menu = gtk_menu_new();

	while ( *labels != (gchar *) 0 ){
		
		item = gtk_menu_item_new_with_label(*labels);
		gtk_widget_show(item);   
		
		gtk_signal_connect_object(GTK_OBJECT(item), "activate",
					  GTK_SIGNAL_FUNC(*func),
					  (gpointer) *labels);
		
		gtk_menu_append(GTK_MENU(menu),item);
		
		if(!strcmp(*labels,def_item))
			def_item_pos = i;
		
		*labels++; 
		i++;
		
	}
	
	opt_menu = gtk_option_menu_new();
	gtk_option_menu_set_menu(GTK_OPTION_MENU(opt_menu), menu);
	gtk_option_menu_set_history(GTK_OPTION_MENU(opt_menu),def_item_pos);
	
	return opt_menu;
}



/*
 * ag_mode_size_choosen
 * @data : the selected mode
 * set the format size to @data, and save it to the config file
 */
void 
ag_mode_size_choosen(gpointer data)
{
	strcpy(mode_prefs.size,(gchar *) data);
	gnome_config_set_string("/SNAC/modes/size",
				mode_prefs.size);
	gnome_config_sync();
	
	ag_recalc_expr();
}



/*
 * ag_mode_format_choosen
 * @data : the selected mode
 * set the format to @data, and save it to the config file
 */ 
void 
ag_mode_format_choosen(gpointer data)
{
	strcpy(mode_prefs.format,(gchar *) data);
	gnome_config_set_string("/SNAC/modes/format",
				mode_prefs.format);
	gnome_config_sync();
	
	ag_recalc_expr();
}




/*
 * ag_mode_angle_choosen
 * @data : the selected mode
 * set the angle messure to @data, and save it to the config file
 */
void 
ag_mode_angle_choosen(gpointer data)
{
	strcpy(mode_prefs.angle,(gchar *) data);
	gnome_config_set_string("/SNAC/modes/angle",
				mode_prefs.angle);
	gnome_config_sync();
	
	ag_recalc_expr();
}

