-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Dictionary)
function GetScalarAttributeValue
  (Base     : Boolean;
   Name     : LexTokenManager.Lex_String;
   TypeMark : Symbol)
  return     LexTokenManager.Lex_String
is
   Result : LexTokenManager.Lex_String;

   --------------------------------------------------------------------------------

   function GetBaseAttributeValue (Name     : LexTokenManager.Lex_String;
                                   TypeMark : Symbol) return LexTokenManager.Lex_String
   --# global in Dict;
   --#        in LexTokenManager.State;
   is
      Result   : LexTokenManager.Lex_String;
      BaseType : Symbol;
   begin

      -- set default case; override for various successes
      Result   := LexTokenManager.Null_String;
      BaseType := GetBaseType (TypeMark);
      if BaseType /= NullSymbol then
         if LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                 Lex_Str2 => LexTokenManager.First_Token) =
           LexTokenManager.Str_Eq then
            if TypeIsInteger (TypeMark)
              or else TypeIsEnumeration (TypeMark)
              or else TypeIsModular (TypeMark)
              or else TypeIsFloatingPoint (TypeMark) then
               Result := RawDict.GetTypeLower (BaseType);
            end if;
         elsif LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                    Lex_Str2 => LexTokenManager.Last_Token) =
           LexTokenManager.Str_Eq then
            if TypeIsInteger (TypeMark)
              or else TypeIsEnumeration (TypeMark)
              or else TypeIsModular (TypeMark)
              or else TypeIsFloatingPoint (TypeMark) then
               Result := RawDict.GetTypeUpper (BaseType);
            end if;
         end if;
      end if;
      return Result;

   end GetBaseAttributeValue;

   --------------------------------------------------------------------------------

   function GetAttributeValue (Name     : LexTokenManager.Lex_String;
                               TypeMark : Symbol) return LexTokenManager.Lex_String
   --# global in Dict;
   --#        in LexTokenManager.State;
   is
      Result : LexTokenManager.Lex_String;
   begin

      if LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                              Lex_Str2 => LexTokenManager.Delta_Token) =
        LexTokenManager.Str_Eq
        or else LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                     Lex_Str2 => LexTokenManager.Digits_Token) =
        LexTokenManager.Str_Eq then

         Result := RawDict.GetTypeErrorBound (TypeMark);

      elsif LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                 Lex_Str2 => LexTokenManager.First_Token) =
        LexTokenManager.Str_Eq then

         if TypeIsScalar (TypeMark) then
            Result := RawDict.GetTypeLower (TypeMark);
         else
            Result := RawDict.GetTypeLower (GetArrayIndex (GetFirstConstrainedSubtype (TypeMark), 1));
         end if;

      elsif LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                 Lex_Str2 => LexTokenManager.Last_Token) =
        LexTokenManager.Str_Eq then

         if TypeIsScalar (TypeMark) then
            Result := RawDict.GetTypeUpper (TypeMark);
         else
            Result := RawDict.GetTypeUpper (GetArrayIndex (GetFirstConstrainedSubtype (TypeMark), 1));
         end if;

      elsif LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                 Lex_Str2 => LexTokenManager.Modulus_Token) =
        LexTokenManager.Str_Eq then

         Result := RawDict.GetTypeModulus (TypeMark);

      else
         Result := LexTokenManager.Null_String;
      end if;

      return Result;

   end GetAttributeValue;

   --------------------------------------------------------------------------------

begin

   if TypeIsUnknown (TypeMark) then
      Result := LexTokenManager.Null_String;
   elsif Base then
      Result := GetBaseAttributeValue (Name, GetRootType (TypeMark));
   else
      Result := GetAttributeValue (Name, TypeMark);
   end if;

   return Result;

end GetScalarAttributeValue;
