#!/bin/sh
#
# Copyright (c) 2013  Peter Pentchev
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# A trivial test case for stdsyslog, the utility for logging programs' output
# to the system log

if [ -z "$TEST_STDSYSLOG" ]; then
	echo '1..0 # skip The TEST_STDSYSLOG environment variable must be set'
	exit 0
fi

: ${STDSYSLOG:=./stdsyslog}

echo '1..10'

f=`mktemp stdsyslog.test.XXXXXX`
pidf=`mktemp stdsyslog.test.pid.XXXXXX`
trap "rm -f '$f' '$pidf'" EXIT QUIT HUP INT TERM ALRM PIPE

${STDSYSLOG} -V > "$f"
if egrep -qe '^stdsyslog[[:space:]]+[[:digit:]]+(\.[[:digit:]]+)+[[:space:]]*$' "$f" && \
   ! egrep -qve '^stdsyslog[[:space:]]+[[:digit:]]+(\.[[:digit:]]+)+[[:space:]]*$' "$f"; then
	echo 'ok 1'
else
	echo 'not ok 1'
	cat "$f" 1>&2
fi

${STDSYSLOG} echo 'stdsyslog test 1 case 2' > "$f"
res="$?"
if [ "$res" = 0 ]; then
	echo 'ok 2'
else
	echo "not ok 2 exit code $res expected 0"
	cat "$f" 1>&2
fi

${STDSYSLOG} sh -c 'echo stdsyslog test 1 case 3 1>&2' > "$f"
res="$?"
if [ "$res" = 0 ]; then
	echo 'ok 3'
else
	echo "not ok 3 exit code $res"
	cat "$f" 1>&2
fi

${STDSYSLOG} sh -c 'echo stdsyslog test 1 case 4; exit 7' > "$f"
res="$?"
if [ "$res" = 7 ]; then
	echo 'ok 4'
else
	echo "not ok 4 exit code $res expected 7"
	cat "$f" 1>&2
fi

${STDSYSLOG} sh -c 'echo stdsyslog test 1 case 5; kill -INT "$$"' > "$f"
res="$?"
if [ "$res" = 130 ]; then
	echo 'ok 5'
else
	echo "not ok 5 exit code $res expected 130"
	cat "$f" 1>&2
fi

${STDSYSLOG} -l > "$f"
res="$?"
if [ "$res" = 0 ] && egrep -qe '^info$' "$f" && egrep -qe '^notice$' "$f" &&
    egrep -qe '^err$' "$f"; then
	echo 'ok 6'
else
	echo "not ok 6 exit code $res"
	cat "$f" 1>&2
fi

${STDSYSLOG} -f list > "$f"
res="$?"
if [ "$res" = 0 ] && egrep -qe '^user$' "$f" && egrep -qe '^local3$' "$f"; then
	echo 'ok 7'
else
	echo "not ok 7 exit code $res expected 0"
	cat "$f" 1>&2
fi

${STDSYSLOG} -d '0:err' -d '1:info' echo 'stdsyslog test 1 case 8' > "$f"
res="$?"
if [ "$res" = 0 ]; then
	echo 'ok 8'
else
	echo "not ok 8 exit code $res expected 0"
	cat "$f" 1>&2
fi

${STDSYSLOG} -d '1:err' -d '2:info' sh -c 'echo stdsyslog test 1 case 9 1>&2' > "$f"
res="$?"
if [ "$res" = 0 ]; then
	echo 'ok 9'
else
	echo "not ok 9 exit code $res expected 0"
	cat "$f" 1>&2
fi

${STDSYSLOG} -p "$pidf" sh -c 'pid="$(cat '"'$pidf'"')"; if [ ! "$pid" = "$$" ]; then echo "read $pid instead of $$"; exit 1; fi' > "$f"
res="$?"
if [ "$res" = 0 ]; then
	echo 'ok 10'
else
	echo "not ok 10 exit code $res expected 0"
fi
