/*
 * Decompiled with CFR 0.152.
 */
package cadyts.utilities.math;

import cadyts.utilities.math.Regression;
import cadyts.utilities.math.Vector;
import java.io.Serializable;

public class PolynomialTrendFilter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Regression regr;
    private int it = 0;

    public PolynomialTrendFilter(double lambda, int degree) {
        this.regr = new Regression(lambda, 1 + degree);
    }

    private Vector x(int it) {
        Vector result = new Vector(this.regr.getDimension());
        int i = 0;
        while (i < result.size()) {
            result.set(i, Math.pow(it, i));
            ++i;
        }
        return result;
    }

    public void setLambda(double lambda) {
        this.regr.setInertia(lambda);
    }

    public void add(double val) {
        this.regr.update(this.x(this.it++), val);
    }

    public double predict(int steps) {
        return this.regr.predict(this.x(this.it - 1 + steps));
    }
}

