/*
 * Decompiled with CFR 0.152.
 */
package trafficdefinition;

import trafficdefinition.Accident;
import trafficdefinition.AreaFlow;
import trafficdefinition.Flow;
import trafficdefinition.HotSpot;
import trafficdefinition.TrafficDefinitionElement;
import trafficdefinition.TrafficDefinitionLayer;

public class UserDefinedTrafficDefinitionLayer
extends TrafficDefinitionLayer {
    private static final long serialVersionUID = 1L;

    public UserDefinedTrafficDefinitionLayer(UserDefinedTrafficDefinitionLayer source) {
        super(source);
    }

    public UserDefinedTrafficDefinitionLayer() {
    }

    @Override
    public TrafficDefinitionLayer duplicate() {
        return new UserDefinedTrafficDefinitionLayer(this);
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + "(User-defined layer)";
    }

    @Override
    public String toXML() {
        StringBuilder sb = new StringBuilder();
        StringBuilder sbFlows = new StringBuilder();
        StringBuilder sbAreaFlows = new StringBuilder();
        StringBuilder sbHotspots = new StringBuilder();
        StringBuilder sbAccidents = new StringBuilder();
        sb.append("<userDefinedTrafficLayer name=\"" + this.name + "\" >\n");
        for (TrafficDefinitionElement tde : this.getElements()) {
            if (tde instanceof Flow) {
                sbFlows.append(tde.toXML());
                continue;
            }
            if (tde instanceof HotSpot) {
                sbHotspots.append(tde.toXML());
                continue;
            }
            if (tde instanceof AreaFlow) {
                sbAreaFlows.append(tde.toXML());
                continue;
            }
            if (!(tde instanceof Accident)) continue;
            sbAccidents.append(tde.toXML());
        }
        sb.append(sbFlows.toString());
        sb.append(sbAreaFlows.toString());
        sb.append(sbHotspots.toString());
        sb.append(sbAccidents.toString());
        sb.append("</userDefinedTrafficLayer>\n");
        return sb.toString();
    }
}

