/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.map;

import com.jhlabs.map.AngleFormat;
import com.jhlabs.map.Unit;
import java.text.ParseException;

public class DegreeUnit
extends Unit {
    static final long serialVersionUID = -3212757578604686538L;
    private static AngleFormat format = new AngleFormat("DdM", true);

    public DegreeUnit() {
        super("degree", "degrees", "deg", 1.0);
    }

    public double parse(String s) throws NumberFormatException {
        try {
            return format.parse(s).doubleValue();
        }
        catch (ParseException e) {
            throw new NumberFormatException(e.getMessage());
        }
    }

    public String format(double n) {
        return format.format(n) + " " + this.abbreviation;
    }

    public String format(double n, boolean abbrev) {
        if (abbrev) {
            return format.format(n) + " " + this.abbreviation;
        }
        return format.format(n);
    }

    public String format(double x, double y, boolean abbrev) {
        if (abbrev) {
            return format.format(x) + "/" + format.format(y) + " " + this.abbreviation;
        }
        return format.format(x) + "/" + format.format(y);
    }
}

