/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.map.proj;

import com.jhlabs.map.MapMath;
import com.jhlabs.map.proj.Projection;
import com.jhlabs.map.proj.ProjectionException;
import java.awt.geom.Point2D;

public class FoucautSinusoidalProjection
extends Projection {
    private double n;
    private double n1;
    private static final int MAX_ITER = 10;
    private static final double LOOP_TOL = 1.0E-7;

    public Point2D.Double project(double lplam, double lpphi, Point2D.Double out) {
        double t = Math.cos(lpphi);
        out.x = lplam * t / (this.n + this.n1 * t);
        out.y = this.n * lpphi + this.n1 * Math.sin(lpphi);
        return out;
    }

    public Point2D.Double projectInverse(double xyx, double xyy, Point2D.Double out) {
        double V;
        if (this.n != 0.0) {
            int i;
            out.y = xyy;
            for (i = 10; i > 0; --i) {
                V = (this.n * out.y + this.n1 * Math.sin(out.y) - xyy) / (this.n + this.n1 * Math.cos(out.y));
                out.y -= V;
                if (Math.abs(V) < 1.0E-7) break;
            }
            if (i == 0) {
                out.y = xyy < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
            }
        } else {
            out.y = MapMath.asin(xyy);
        }
        V = Math.cos(out.y);
        out.x = xyx * (this.n + this.n1 * V) / V;
        return out;
    }

    public void initialize() {
        super.initialize();
        if (this.n < 0.0 || this.n > 1.0) {
            throw new ProjectionException("-99");
        }
        this.n1 = 1.0 - this.n;
    }

    public boolean hasInverse() {
        return true;
    }

    public String toString() {
        return "Foucaut Sinusoidal";
    }
}

