/*-----------------------------------------------------------------------

                         SYRTHES version 4.1
                         -------------------

     This file is part of the SYRTHES Kernel, element of the
     thermal code SYRTHES.

     Copyright (C) 2009 EDF S.A., France

     contact: syrthes-support@edf.fr


     The SYRTHES Kernel is free software; you can redistribute it
     and/or modify it under the terms of the GNU General Public License
     as published by the Free Software Foundation; either version 2 of
     the License, or (at your option) any later version.

     The SYRTHES Kernel is distributed in the hope that it will be
     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.


     You should have received a copy of the GNU General Public License
     along with the Code_Saturne Kernel; if not, write to the
     Free Software Foundation, Inc.,
     51 Franklin St, Fifth Floor,
     Boston, MA  02110-1301  USA

-----------------------------------------------------------------------*/

#ifndef _HMT_BIBMAT_H
#define _HMT_BIBMAT_H

#include "syr_hmt_bd.h"


/*=====================================================*/
/*======== Bibliotheque de materiaux           ========*/
/*=====================================================*/

/* nombre de materiaux disponibles dans la bibliotheque */
#define NB_MAT                    6
 

#define MAT_BETON                  0
#define MAT_BOIS_PIN               1
#define MAT_PSE_NORMAL             2
#define MAT_LAINE_VERRE            3
#define MAT_BOIS_AGGLO             4
#define MAT_POLYURETHANE           5

/* liste des materiaux disponibles */
/* ------------------------------- */
#ifdef LISTE_MAT
char *liste_mat[NB_MAT]= {
"BETON",             "BOIS_PIN",             "PSE_NORMAL",
"LAINE_VERRE",       "BOIS_AGGLO",           "POLYURETHANE"
};
#else
extern char *liste_mat[NB_MAT];
#endif

/* functions protoype */
/* ------------------ */

#include "syr_hmt_bib_beton.h"
#include "syr_hmt_bib_pin.h"
#include "syr_hmt_bib_pse_normal.h"
#include "syr_hmt_bib_laine_verre.h"
#include "syr_hmt_bib_bois_agglo.h"
#include "syr_hmt_bib_polyurethane.h"


static double (*fmat_const[])(struct ConstMateriaux*,struct ConstPhyhmt)=
{fmat_const_beton,            fmat_const_pin,           fmat_const_pse_normal,   
 fmat_const_laine_verre,      fmat_const_bois_agglo,    fmat_const_polyurethane};
 

static double (*fmat_ftauv[])(struct ConstPhyhmt,struct ConstMateriaux,double,double,double)=
{fmat_ftauv_beton,            fmat_ftauv_pin,           fmat_ftauv_pse_normal,   
 fmat_ftauv_laine_verre,      fmat_ftauv_bois_agglo,    fmat_ftauv_polyurethane};

static double (*fmat_falpha[])(struct ConstPhyhmt,struct ConstMateriaux,double,double,double)=
{fmat_falpha_beton,            fmat_falpha_pin,           fmat_falpha_pse_normal,   
 fmat_falpha_laine_verre,      fmat_falpha_bois_agglo,    fmat_falpha_polyurethane};

static double (*fmat_fkrg[])(struct ConstMateriaux,double)=
{fmat_fkrg_beton,            fmat_fkrg_pin,           fmat_fkrg_pse_normal,   
 fmat_fkrg_laine_verre,      fmat_fkrg_bois_agglo,    fmat_fkrg_polyurethane};

static double (*fmat_fkrl[])(struct ConstMateriaux,double)=
{fmat_fkrl_beton,            fmat_fkrl_pin,           fmat_fkrl_pse_normal,   
 fmat_fkrl_laine_verre,      fmat_fkrl_bois_agglo,    fmat_fkrl_polyurethane};

static double (*fmat_fklambt[])(double,double)=
{fmat_fklambt_beton,            fmat_fklambt_pin,           fmat_fklambt_pse_normal,   
 fmat_fklambt_laine_verre,      fmat_fklambt_bois_agglo,    fmat_fklambt_polyurethane};

static double (*fmat_fpiv[])(double,double,double)=
{fmat_fpiv_beton,            fmat_fpiv_pin,           fmat_fpiv_pse_normal,   
 fmat_fpiv_laine_verre,      fmat_fpiv_bois_agglo,    fmat_fpiv_polyurethane};


static double (*fmat_fhm[])(double)=
{fmat_fhm_beton,            fmat_fhm_pin,           fmat_fhm_pse_normal,   
 fmat_fhm_laine_verre,      fmat_fhm_bois_agglo,    fmat_fhm_polyurethane};


static double (*fmat_fdhmdtauv[])(double)=
{fmat_fdhmdtauv_beton,            fmat_fdhmdtauv_pin,           fmat_fdhmdtauv_pse_normal,   
 fmat_fdhmdtauv_laine_verre,      fmat_fdhmdtauv_bois_agglo,    fmat_fdhmdtauv_polyurethane};


static double (*fmat_fbetap[])(struct ConstPhyhmt,struct ConstMateriaux,
				double,double,double,double)=
{fmat_fbetap_beton,            fmat_fbetap_pin,           fmat_fbetap_pse_normal,   
 fmat_fbetap_laine_verre,      fmat_fbetap_bois_agglo,    fmat_fbetap_polyurethane};


static double (*fmat_fdhp[])(double,double)=
{fmat_fdhp_beton,            fmat_fdhp_pin,           fmat_fdhp_pse_normal,   
 fmat_fdhp_laine_verre,      fmat_fdhp_bois_agglo,    fmat_fdhp_polyurethane};


static double (*fmat_fdht[])(double,double)=
{fmat_fdht_beton,            fmat_fdht_pin,           fmat_fdht_pse_normal,   
 fmat_fdht_laine_verre,      fmat_fdht_bois_agglo,    fmat_fdht_polyurethane};


#endif
