/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/

#include <glib.h>
#include <gmodule.h>

/**
 * pluginsInitFunc:
 *
 * This kind of method should exist in all plugins with the
 * name '{module_name}Init'. It is called by V_Sim when the module is loaded.
 *
 * Returns: TRUE if it loads correctly.
 */
typedef gboolean (*pluginsInitFunc)();
/**
 * pluginsDescriptionFunc:
 *
 * This kind of method should exist in all plugins it give a description of
 * what the plugin does. It must be named '{module_name}Get_description'.
 *
 * Returns: a string in UTF-8 owned by the plugin.
 */
typedef const gchar* (*pluginsDescriptionFunc)();
/**
 * pluginsAuthorsFunc:
 *
 * This kind of method should exist in all plugins it give the list of
 * the authors. It must be named '{module_name}Get_authors'.
 *
 * Returns: a string in UTF-8 owned by the plugin.
 */
typedef const gchar* (*pluginsAuthorsFunc)();
/**
 * pluginsIconFunc:
 *
 * This kind of method is not mandatory and it returns the path to
 * a loadable icon of 32x32 to illustrate the plug-in.
 *
 * Returns: a path owned by the plug-in.
 */
typedef const gchar* (*pluginsIconFunc)();

/**
 * VisuPlugin_struct:
 * @hook: a pointer to the opened shared library ;
 * @name: the name of the module (on UNIX it is lib{name}.so) ;
 * @init: a pointer on the init method ;
 * @getDescription: a pointer to the description method ;
 * @getAuthors: a pointer to the author method.
 * @getIcon: a pointer to the icon method.
 *
 * This structure is used to deals with a plugin. It gives handles
 * to the public method of the plugin.
 */
struct VisuPlugin_struct
{
  GModule *hook;

  gchar *name;

  pluginsInitFunc init;
  pluginsDescriptionFunc getDescription;
  pluginsAuthorsFunc getAuthors;
  pluginsIconFunc getIcon;
};
/**
 * VisuPlugin:
 *
 * Short way to address #VisuPlugin_struct objects.
 */
typedef struct VisuPlugin_struct VisuPlugin;

/**
 * visuPluginsInit:
 *
 * Initialise this part of code. Should not be called (called once
 * by V_Sim on startup only). It try to load
 * all plugins found in the installation directory and in the user directory.
 */
void visuPluginsInit();

/**
 * visuPluginsGet_listLoaded:
 *
 * On startup, plugins are loaded according to a list present in the configuration
 * file. It is possible to access the list of all loaded plugins with this method.
 *
 * Returns: a #GList owned by V_Sim of #VisuPlugin objects.
 */
GList* visuPluginsGet_listLoaded();
