/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#include "text.h"

#include <string.h>

#include <visu_tools.h>
#include <OSOpenGL/visu_openGL.h>

static GLuint BASE;  /* for the font display list */
static GLuint SMALL; /* for the small font display list */
static gboolean textListHaveBeenBuilt = FALSE;

void openGLText_drawChars(gchar *s, OpenGLTextSize size)
{
  g_return_if_fail(s);

  g_return_if_fail(textListHaveBeenBuilt);

  DBG_fprintf(stderr, "OpenGL Text: put text '%s'.\n", s);
  glPushAttrib(GL_LIST_BIT);
  if (size == TEXT_SMALL && SMALL > 0)
    glListBase(SMALL);
  else
    glListBase(BASE);
  glCallLists((int)strlen(s), GL_UNSIGNED_BYTE, (GLubyte *)s);
  glPopAttrib();
}

void openGLText_initFontList()
{
  if (textListHaveBeenBuilt)
    return;

  BASE  = visuOpenGLinit_fontList(18);
  SMALL = visuOpenGLinit_fontList(14);
  textListHaveBeenBuilt = (BASE > 0);
  DBG_fprintf(stderr, "OpenGL Text: creating font list: %d %d.\n", BASE, SMALL);
  g_return_if_fail(BASE > 0 && SMALL > 0);
}

void openGLText_rebuildFontList()
{
  DBG_fprintf(stderr, "OpenGL Text: force rebuilding font list.\n");
  textListHaveBeenBuilt = FALSE;
  openGLText_initFontList();
}

void openGLText_onNewContext()
{
  DBG_fprintf(stderr, "OpenGL Text: new context, forgetting fonts.\n");
  textListHaveBeenBuilt = FALSE;
}
