/***************************************************************************
                          dceditserver.cpp  -  description
                             -------------------
    begin                : Fre Aug 29 2003
    copyright            : (C) 2003 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dceditserver.h"

#include <qpushbutton.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qmessagebox.h>

#include <dclib/cconfig.h>

#include "dcguiutils.h"

/** */
DCEditServer::DCEditServer( QWidget * parent ) : QDialog( parent )
{
	setupUi(this);
	
	ComboBox_REMOTE_ENCODING->addItem(QString());
	DCGuiUtils::AddEncodings( ComboBox_REMOTE_ENCODING );
	ComboBox_REMOTE_ENCODING->setCurrentIndex(0);
	
	GroupBox_PROFILE->hide();
	adjustSize();

	connect( PushButton_PROFILE, SIGNAL(clicked()), this, SLOT(slotProfileButtonClicked()) );
	connect( CheckBox_PROFILE, SIGNAL(toggled(bool)), this, SLOT(slotCheckBoxProfileToggled(bool)) );
	
	// reset values
	Reset();
}

/** */
DCEditServer::~DCEditServer()
{
}

/** */
void DCEditServer::accept()
{
	if ( LineEdit_NAME->text().isEmpty() )
	{
		QMessageBox::critical(
			this,
			windowTitle(),
			tr("Please enter a hubname.")
		);
		return;
	}
	else if ( LineEdit_HOST->text().isEmpty() )
	{
		QMessageBox::critical(
			this,
			windowTitle(),
			tr("Please enter a hubhost.")
		);
		return;
	}
	else
	{
		QDialog::accept();
	}
}

/** */
void DCEditServer::Reset()
{
	LineEdit_PASSWORD->clear();
	CheckBox_AUTOCONNECT->setChecked(false);
	CheckBox_SSL->setChecked(false);
	CheckBox_DESCRIPTIONTAG->setChecked(true);
	CheckBox_EXT_HUB_COUNT->setChecked(true);
	LineEdit_SUPPRESS_NICKS->clear();
	ComboBox_REMOTE_ENCODING->setCurrentIndex(0);

	// disable profile
	slotCheckBoxProfileToggled(false);
}

/** */
void DCEditServer::SetProfile( DCConfigHubProfile * profile )
{
	LineEdit_NICK->setText( profile->m_sNick.Data() );
	LineEdit_PASSWORD->setText( profile->m_sPassword.Data() );
	CheckBox_AUTOCONNECT->setChecked( profile->m_bAutoConnect );
	CheckBox_SSL->setChecked( profile->m_bSSL );
	CheckBox_DESCRIPTIONTAG->setChecked( profile->m_bTag );
	CheckBox_EXT_HUB_COUNT->setChecked( profile->m_bExtHubCount );
	LineEdit_EMAIL->setText( profile->m_sEMail.Data() );
	CheckBox_EMAIL->setChecked( profile->m_bEMail );
	LineEdit_PROF_DESCRIPTION->setText( profile->m_sComment.Data() );
	CheckBox_DESCRIPTION->setChecked( profile->m_bComment );
	LineEdit_SUPPRESS_NICKS->setText( profile->m_sSuppressedNicks.Data() );
	ComboBox_REMOTE_ENCODING->setEditText( profile->m_sRemoteEncoding.Data() );

	// enable profile
	slotCheckBoxProfileToggled(true);
}

/** */
void DCEditServer::GetProfile( DCConfigHubProfile * profile )
{
	profile->m_sName        = LineEdit_NAME->text().toAscii().constData();
	profile->m_sNick        = LineEdit_NICK->text().replace( " ", "\xa0").toAscii().constData();
	profile->m_sPassword    = LineEdit_PASSWORD->text().toAscii().constData();
	profile->m_bAutoConnect = CheckBox_AUTOCONNECT->isChecked();
	profile->m_bSSL         = CheckBox_SSL->isChecked();
	profile->m_bTag         = CheckBox_DESCRIPTIONTAG->isChecked();
	profile->m_bExtHubCount = CheckBox_EXT_HUB_COUNT->isChecked();
	profile->m_bComment     = CheckBox_DESCRIPTION->isChecked();
	profile->m_sComment     = LineEdit_PROF_DESCRIPTION->text().toAscii().constData();
	profile->m_bEMail       = CheckBox_EMAIL->isChecked();
	profile->m_sEMail       = LineEdit_EMAIL->text().toAscii().constData();
	profile->m_sSuppressedNicks = LineEdit_SUPPRESS_NICKS->text().toAscii().constData();
	profile->m_sRemoteEncoding = ComboBox_REMOTE_ENCODING->currentText().toAscii().constData();
}

/** */
void DCEditServer::slotProfileButtonClicked()
{
	if ( GroupBox_PROFILE->isVisible() )
	{
		GroupBox_PROFILE->hide();
	}
	else
	{
		GroupBox_PROFILE->show();
	}
}

/** */
void DCEditServer::slotCheckBoxProfileToggled( bool on )
{
	CheckBox_PROFILE->setChecked(on);
	
	if ( !on )
	{
		// hide profile window if disabled
		if ( GroupBox_PROFILE->isVisible() )
		{
			PushButton_PROFILE->setChecked(false);
			slotProfileButtonClicked();
		}
	}

	PushButton_PROFILE->setEnabled(on);
}
