/* 
file: entrieswin.cc
*/
#include "entrieswin.h"
// in pixmaps.cc   
extern char * mini_penguin_xpm[];
// in fonts.cc
extern char *lucida12;        
extern char *timesbold12;
static char buff[256];
char* prompts[] =  
{
"Normal input",                  
"Numeric input",
"Date input",
"Secret input",             
0       
};
/*
 */
DEFINE_SIGNAL_MAP(EntriesWin,VDKForm)
  ON_SIGNAL(normal,activate_signal,ShowText),
  ON_SIGNAL(numeric,activate_signal,ShowText),
  ON_SIGNAL(date,activate_signal,ShowText),
  ON_SIGNAL(secret,activate_signal,ShowText),
  ON_SIGNAL(normal,focus_out_signal,ShowText),
  ON_SIGNAL(numeric,focus_out_signal,ShowText),
  ON_SIGNAL(date,focus_out_signal,ShowText),
  ON_SIGNAL(secret,focus_out_signal,ShowText),
  ON_SIGNAL(secret,focus_in_signal,SecretGetFocus),
  ON_SIGNAL(toggleEdit,clicked_signal,ToggleEdit),
  ON_SIGNAL(quit,clicked_signal,Quit) 
END_SIGNAL_MAP 
/*
 */
void EntriesWin::Setup()
{
  int t; 
  calendardate d;
  table = new VDKTable(this,4,2);
  table->ColSpacing = 10;
  table->RowSpacing = 10;
  for(t=0; t < MAX_ENTRIES; t++)
    {
      labels[t] = new VDKLabel(this,prompts[t]);
      table->AddToCell(labels[t],t,0);
    }
  table->AddToCell(normal = new VDKEntry(this,0,prompts[0]),0,1);
  table->AddToCell(numeric =  new VDKNumericEntry(this,0,"0.567"),1,1);
  table->AddToCell(date =  new VDKEntry(this,10,(char*) d),2,1);
  table->AddToCell(secret =  new VDKEntry(this,8,""),3,1);
  numeric->Foreground = VDKRgb("forest green");
  date->Foreground = clWhite; 
  date->NormalBackground = clDodgerBlue;
  secret->Hidden = true;
  // object tags
  normal->Tag  =  0;
  numeric->Tag =  1;
  date->Tag    =  2;
  secret->Tag  =  3;

  hbox = new VDKBox(this,h_box);
  quit = new VDKLabelButton(this,     
 			   "Close child");
  hbox->Add(quit);
  hbox->Add(new VDKSeparator(this,v_separator)); 
  toggleEdit = new VDKLabelButton(this,    
 				      "Toggle read only");
  hbox->Add(toggleEdit,l_justify,FALSE,FALSE,0);
  VDKBox *box = new VDKBox(this);      
  box->Add(table);   
  box->Add(new VDKSeparator(this)); 
  box->Add(showtext = new VDKLabel(this,""));
  showtext->Justify = GTK_JUSTIFY_CENTER;
  showtext->Foreground = VDKRgb("navy blue"); 
  box->Add(new VDKSeparator(this));
  box->Add(hbox); 
  Add(box);
}       
/*
 */
bool EntriesWin::ShowText(VDKObject* sender)
{
  calendardate d;
  char* p = (char*) ((VDKEntry*)sender)->Text;
  if(sender == normal && !strcmp(p,"pippo"))
    {
      printf("\nlocking focus");
      fflush(stdout);
      gtk_widget_activate (sender->Widget());
      //      my_gtk_window_set_focus(GTK_WINDOW(Window()),sender->Widget());
    }
  if(sender == date)
    {
      if(*p)
	d = p;
      sprintf(buff,"%s: %s",prompts[sender->Tag],d.CalendarDate());
    }
  else 
    sprintf(buff,"%s:%s",prompts[sender->Tag],p);
  // clear secret text
  if(sender == secret)
    {
      VDKEntry* entry = dynamic_cast<VDKEntry*>(sender);
      if(entry)
	entry->Text = "";
    }
  showtext->Caption = buff;
  return true;
}
/*
 */
bool EntriesWin::ToggleEdit(VDKObject*)
{
normal->Editable = normal->Editable ? false : true; 
numeric->Editable = numeric->Editable ? false : true;
date->Editable = date->Editable ? false : true;
return true; 
}
/*  
 */
bool EntriesWin::SecretGetFocus(VDKObject*)
{
  // clear secret field
secret->Text = "";
return true;
}  

bool EntriesWin::Quit(VDKObject* ) 
{ 
  Close();
  return true; 
}

