/*
file: tbarwin.cc
*/   
#include "tbarwin.h"
extern char * mini_ofolder_xpm[];
extern char * book_xpm[];
extern char * mini_bball_xpm[];
extern char * mini_gball_xpm[];
extern char * mini_penguin_xpm[];
extern char * book_open_xpm[];
extern char * book_closed_xpm[];
#define MAXPIX 6
#define FRAMETAG  2000
#define FRAME1TAG 4000
static char buff[128]; 
char ** pixmaps[MAXPIX] =
{
  mini_ofolder_xpm,book_xpm,mini_bball_xpm,mini_penguin_xpm,
book_open_xpm,book_closed_xpm
};
  
char *tips[MAXPIX] = 
{
"quit","enable/disable blue ball","blue ball","penguin","book open","book closed"
};

DEFINE_SIGNAL_MAP(ToolBarWin,VDKForm)
  ON_SIGNAL(toolbar,clicked_signal,HandleToolBarSignals),
  ON_SIGNAL(entry,activate_signal,HandleEntry),
  ON_SIGNAL(handlebox1,child_attached_signal,HandleChildAttached),
  ON_SIGNAL(handlebox1,child_detached_signal,HandleChildDetached)
END_SIGNAL_MAP
/*
 */
void ToolBarWin::Setup()
{
  int t; 
  VDKBox* box = new VDKBox(this,v_box);
  // 
  VDKFrame* frame1 = new VDKFrame(this,"toolbar",v_box,GTK_SHADOW_ETCHED_IN);
  toolbar = new VDKToolbar(this);
  toolbar->AddSpace(); 
  // modified for gcc 2.95 by Ionutz
  VDKString defaultText = "flips icons/icons+text";
  for(t = 0; t < MAXPIX ;t++) 
    { 
      toolbar->AddButton(pixmaps[t], 
			 t != 2 ? tips[t]: (char *) defaultText , 
			 t != 2 ? tips[t]: (char *) defaultText); 
      toolbar->AddSpace();
    } 
  entry = new VDKEntry(this,0, "The Visual Development Kit");
  entry->Foreground = clSiena;
  toolbar->AddWidget(entry,"The Visual Development Kit");
  GtkWidget* wid = (*toolbar->ButtonList)[2];
  gtk_widget_set_sensitive(wid,FALSE);
  frame1->Add(toolbar);
  handlebox1 = new VDKHandleBox(this);
  frame1->Tag = FRAME1TAG; 
  handlebox1->Add(frame1);
  box->Add(handlebox1);
  box->Add(new VDKSeparator(this,h_separator));
  box->Add(sbar = new VDKStatusbar(this));
  Add(box);
  }
/*
 */
bool ToolBarWin::HandleToolBarSignals(VDKObject* s)
{
  VDKToolbar* tbar = dynamic_cast<VDKToolbar*>(s);
  if(!tbar)
    return true;
  int id = tbar->ButtonPressed;
  bool sensitive;
  GtkWidget* wid;
  switch(id)
    {
    case 0 :
      Close();
      return true;
    case 1: 
       wid = (*tbar->ButtonList)[2];
       sensitive = GTK_WIDGET_IS_SENSITIVE(wid);
       gtk_widget_set_sensitive(wid, sensitive ? FALSE : TRUE);
       break;
     case 2:
       tbar->Style = 
	 tbar->Style == GTK_TOOLBAR_ICONS ?
	 GTK_TOOLBAR_BOTH : GTK_TOOLBAR_ICONS ;
     break;
    }
  sprintf(buff,"Button with tip: \"%s\" was pressed",
	  tips[id]);
  sbar->Push(buff);
  return true;
}  
/*
 */
bool ToolBarWin::HandleEntry(VDKObject* s)
{
VDKEntry* sender = dynamic_cast<VDKEntry*>(s);
  if(!sender)
    return true;
  sbar->Push(sender->Text);
return true;
}
/*
 */
bool ToolBarWin::HandleChildAttached(VDKObject* s)
{
  VDKHandleBox* handle = dynamic_cast<VDKHandleBox*>(s);
  if(!handle)
    return true;
  VDKObject* obj = handle->Child;
  printf("\nchild with tag: %d attached",obj->Tag);
  fflush(stdout);
  return true;
}
/*
 */
bool ToolBarWin::HandleChildDetached(VDKObject* s)
{
  VDKHandleBox* handle = dynamic_cast<VDKHandleBox*>(s);
  if(!handle)
    return true;
  VDKObject* obj = handle->Child;
  printf("\nchild with tag: %d detached",obj->Tag);
  fflush(stdout);
  return true;
}









