/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.5
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
*/


#include "vdk/scrolled.h"
#include "vdk/forms.h"
/*
 */
VDKScrolled::VDKScrolled(VDKForm* owner,int mode)
  :VDKObjectContainer(owner)
{
  widget = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (widget),
				      GTK_POLICY_AUTOMATIC,
				      GTK_POLICY_AUTOMATIC);
  //  ConnectDefaultSignals();
}
/*
 */
VDKScrolled::~VDKScrolled()
{}
/*
 */
void VDKScrolled::Add(VDKObject* obj, int ,
		 int,  int , int )
{
  AddWithViewport(obj);
}
/*
 */
void VDKScrolled::AddWithoutViewport(VDKObject* obj, int justify,
		 int expand, int fill , int padding)
{
  gtk_container_add(GTK_CONTAINER(widget),obj->Widget());
  // calls ancestor (B.Liskov docet...)
  VDKObjectContainer::Add(obj,0,0,0,0);
}
/*
 */
void VDKScrolled::AddWithViewport(VDKObject* obj)
{
  gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(widget),
					obj->Widget());
  gtk_container_set_focus_hadjustment ( GTK_CONTAINER (obj->Widget()),
					gtk_scrolled_window_get_hadjustment 
					(GTK_SCROLLED_WINDOW (widget)));
  gtk_container_set_focus_vadjustment (GTK_CONTAINER (obj->Widget()),
				       gtk_scrolled_window_get_vadjustment 
				       (GTK_SCROLLED_WINDOW (widget)));
  // calls ancestor (B.Liskov docet...)
  VDKObjectContainer::Add(obj,0,0,0,0);
}
