/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * updating to 0.5 (November 98)
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */


#include "vdk/vdkclist.h"
#include "vdk/forms.h"
#include <string.h>
/*
 */
void VDKCustomList::RowSelection(GtkWidget* ,
		  gint row,
		  gint column,
		  GdkEvent *event,
		  gpointer s)
{
  g_return_if_fail(s != NULL);
  VDKObjectSignal* signal =
    reinterpret_cast<VDKObjectSignal*>(s);
  VDKCustomList* obj = reinterpret_cast<VDKCustomList*>(signal->obj);
  obj->pointer = row;
  switch(obj->mode)
    {
    case GTK_SELECTION_EXTENDED:
      obj->selection = VDKPoint(row,column);
      if(event && event->type == GDK_2BUTTON_PRESS)
	{
	  if( obj->Tuples.size() > 0)
	    obj->SignalEmit(signal->signal);
	    obj->SignalEmit("select_row");
	}
      break;
    default:
      obj->selection = VDKPoint(row,column);
      obj->SignalEmit(signal->signal);
      obj->SignalEmit("select_row");
    }
#ifdef USE_SIGCPLUSPLUS
  obj->OnRowSelect(obj, row, column);
#endif
}
/*
 */
void VDKCustomList::RowUnselection(GtkWidget* ,
		  gint row,
		  gint column,
		  GdkEventButton *,
		  gpointer s)
{
  g_return_if_fail(s != NULL);
  VDKObjectSignal* signal =  reinterpret_cast<VDKObjectSignal*>(s);
  VDKCustomList* obj = reinterpret_cast<VDKCustomList*>(signal->obj);
  if(obj->mode == GTK_SELECTION_EXTENDED)
    return;
  obj->unselection = VDKPoint(row,column);
  obj->selection = VDKPoint(-1,-1);
  obj->SignalEmit(signal->signal);
  obj->SignalEmit("unselect_row");
#ifdef USE_SIGCPLUSPLUS
  obj->OnRowUnselect(obj, row, column);
#endif
}
//////////////////////////////////////////////
/*
 */
VDKCustomList::VDKCustomList(VDKForm* owner,
			     int columns,
			     char** titles,
			     GtkSelectionMode mode):
  VDKCustom(owner,columns,titles,mode),
  WideSelection(0),
  // sets property
  Selected("Selected",this,VDKPoint(-1,-1),
	   &VDKCustomList::SelectRow,&VDKCustomList::Selection),
  Unselected("Unselected",this,VDKPoint(-1,-1),
	   &VDKCustomList::UnselectRow,&VDKCustomList::Unselection)

{
  int t = 0;
  selection = VDKPoint(-1,-1);
  // rows pointer in extended selection
  pointer = -1;
  // rows pointer in wide selection
  start = end = -1;
  if(!titles)
    custom_widget =  gtk_clist_new(columns);
  else
    custom_widget =  gtk_clist_new_with_titles(columns,titles);
  gtk_container_add (GTK_CONTAINER (widget), custom_widget);
  gtk_widget_show(GTK_WIDGET(custom_widget));
  /*
   */
  gtk_clist_set_selection_mode(GTK_CLIST(custom_widget),mode);
  //gtk_clist_set_shadow_type(GTK_CLIST(custom_widget), GTK_SHADOW_ETCHED_OUT);
  if(titles)
    {
      for (t = 0; t < columns; t++)
	{
	  Titles[t] =
	    new VDKObject(owner,
			  GTK_CLIST(custom_widget)->column[t].button);
	  AddItem(Titles[t]);
	}
    }
  int rh = custom_widget->style->font->ascent +
			   custom_widget->style->font->descent+1;
  RowHeight(rh);
  AutoResize = true;
  gtk_clist_set_row_height(GTK_CLIST(custom_widget), rh);
  ConnectSignals();
#ifdef USE_SIGCPLUSPLUS
  make_gtksigc_connection(this);
#endif
}
/*
 */
/*
 */
void
VDKCustomList::ConnectSignals()
{
  // call ancestor
  VDKCustom::ConnectSignals();
  //
  s_list_select.obj = this;
  s_list_select.signal = select_row_signal;
  s_list_unselect.obj = this;
  s_list_unselect.signal = unselect_row_signal;

  select_connect =
    gtk_signal_connect( GTK_OBJECT(custom_widget),
			"select_row",
			GTK_SIGNAL_FUNC(VDKCustomList::RowSelection),
			(gpointer) &s_list_select);
  unselect_connect =
    gtk_signal_connect(GTK_OBJECT(custom_widget),
		       "unselect_row",
		       GTK_SIGNAL_FUNC(VDKCustomList::RowUnselection),
		       (gpointer) &s_list_unselect);
  // specialized connect to realize signal
  s_realize.obj = this;
  s_realize.signal = realize_signal;
  gtk_signal_connect(GTK_OBJECT(CustomWidget()),"realize",
		     GTK_SIGNAL_FUNC(VDKObject::VDKSignalPipe),
		     (gpointer) &s_realize);

}

/*
 */
VDKCustomList::~VDKCustomList()
{

}
/*
removed since conflicts with i18n
void VDKCustomList::AddRow(vector<string> v, char** pixdata, int col)
{
char **s;
s = (char **)malloc(v.size() * sizeof(char *));
if(s != NULL)
{
  for(unsigned int n = 0; n < v.size(); n++)
    {
      const char *cTmp = v[n].c_str();
      
      s[n] = (char *)malloc(strlen(cTmp));
      if(s[n] != NULL)
	{
	  strcpy(s[n], v[n].c_str());
	}
      //	  else
      // do something useful here... throw an exception mebbe?
    }
}
 AddRow(s, pixdata, col);
 for(unsigned int n = 0; n < v.size(); n++)
   {
     free(s[n]);
   }
 free(s);
 return;
}
*/

/*
 */
void
VDKCustomList::AddRow(char** s,char** pixdata, int col)
{
  Tuple tuple(columns);
  int j ;
  for(j = 0; j < tuple.size(); j++)
    tuple[j] = s[j];
  Tuples.add(tuple);
  int row = gtk_clist_append(GTK_CLIST(custom_widget),s);
  SetStyle(row);
  pointer = pointer < 0 ? 0 : pointer;
  if(pixdata)
    _update_pix(Tuples.size()-1,s[col],pixdata,col);
  return;
}

/*
 */
void VDKCustomList::SetStyle(int row)
{

    GtkStyle *style =
    gtk_style_copy(gtk_widget_get_style(GTK_WIDGET(custom_widget)));
    g_return_if_fail(style != NULL);
    gtk_style_ref(style);
    if(UnselectedBackground)
    style->base[GTK_STATE_NORMAL] = *(*UnselectedBackground);
    if(SelectedBackground)
    style->bg[GTK_STATE_SELECTED] = *(*SelectedBackground);
    if(UnselectedForeground)
    style->fg[GTK_STATE_NORMAL] = *(*UnselectedForeground);
    if(SelectedForeground)
    style->fg[GTK_STATE_SELECTED] = *(*SelectedForeground);
    gtk_clist_set_row_style (GTK_CLIST (custom_widget), row, style);

}

/*
 */
void VDKCustomList::UpdateRow(int row, char** s, char** pixdata, int col)
{
  if (row < 0 || row >= Tuples.size() )
    return;
  Tuple tuple(columns);
  int j ;
  for(j = 0; j < tuple.size(); j++)
    tuple[j] = s[j];
  Tuples[row] = tuple;
  for(j = 0; j < columns; j++)
    gtk_clist_set_text(GTK_CLIST(custom_widget),row,j, s[j]);
  if(pixdata)
    _update_pix(row,s[col],pixdata,col);
}
/*
 */
void VDKCustomList::UpdateRow(int row, Tuple& tuple,
	      char** pixdata, int col)
{
int t;
char **array = new char*[tuple.size()];
for(t = 0; t < tuple.size(); t++)
  {
    array[t] = new char[strlen((char*) tuple[t])+1];
    strcpy(array[t],(char*) tuple[t]);
  }
UpdateRow(row,array,pixdata,col);
for(t = 0; t < tuple.size(); t++)
  delete array[t];
delete[] array;
}
/*
 */
void VDKCustomList::UpdateCell(int row, int col, char* s, char** pixdata)
{
  if(row < 0 || row >= Tuples.size())
    return ;
  if(col < 0 || col >= columns)
    return;
  Tuples[row][col] = s;
  gtk_clist_set_text(GTK_CLIST(custom_widget),row,col, s);
  if(pixdata)
    _update_pix(row,s,pixdata,col);
}
/*
 */
void VDKCustomList::RemoveRow(int row)
{
if(row < 0 || row >= Tuples.size())
  return;
Tuples.unlink(row);
gtk_clist_remove(GTK_CLIST(custom_widget),row);
}
/*
private
 */
void VDKCustomList::_update_pix(int row,char* s, char** pixdata, int col)
{
  GdkBitmap *mask;
  GtkStyle* style = gtk_widget_get_style(owner->Window());
  GdkPixmap* pixmap =
    gdk_pixmap_create_from_xpm_d(owner->Window()->window,
				 &mask,
				 &style->bg[GTK_STATE_NORMAL],
				 pixdata);
  gtk_clist_set_pixtext(GTK_CLIST(custom_widget),
			row,
			col,
			s,
			2,
			pixmap,
			mask);
}

/*
 */
void VDKCustomList::SelectRow(int row, int col)
{
  gtk_clist_select_row(GTK_CLIST(custom_widget),row,col);
  /* it should scroll to the right position,but
    does not work well
  GtkVisibility visible = gtk_clist_row_is_visible(GTK_CLIST(custom_widget),
						   row);
  if( (visible  == GTK_VISIBILITY_NONE) || 
      (visible  == GTK_VISIBILITY_PARTIAL)
      )
    gtk_clist_moveto (GTK_CLIST(custom_widget),row,0,0.0,0.0);
  */  
}
/*
 */
void VDKCustomList::UnselectRow(int row, int col)
{
  gtk_clist_unselect_row(GTK_CLIST(custom_widget),row,col);
}

/*
 */
VDKIntArray& VDKCustomList::Selections()
{
  GList* list,*head;
  int listSize = 0, t;
  WideSelection = VDKIntArray(0);
  if(Size() == 0)
    return WideSelection;
  else if(
	  (mode == GTK_SELECTION_EXTENDED)
	  ||
	  (mode == GTK_SELECTION_MULTIPLE)
	  )

    {
      list = head = GTK_CLIST(custom_widget)->selection;
      // count list size
      if(head)
	for(t=0; head; head = head->next,listSize++);
      // load array;
      WideSelection = VDKIntArray(listSize);
      for(t = 0; t < WideSelection.size();t++,list = list->next)
	WideSelection[t] = (int) list->data;
    }
  return WideSelection;
}
/*
*/
void VDKCustomList::Clear()
{
  VDKCustom::Clear();
  Tuples.flush();
  selection = VDKPoint(-1,-1);
  unselection = VDKPoint(-1,-1);
}


#ifdef USE_SIGCPLUSPLUS
void
VDKCustomList::make_gtksigc_connection(VDKCustomList* obj)
{
     VDKCustom::make_gtksigc_connection(obj);
     gtk_signal_connect(GTK_OBJECT(obj->CustomWidget()),"row_move",
			GTK_SIGNAL_FUNC(&VDKCustomList::_handle_row_move),
			reinterpret_cast<gpointer>(obj));
//      gtk_signal_connect(GTK_OBJECT(obj->CustomWidget()),"insert_row",
// 			GTK_SIGNAL_FUNC(&VDKCustomList::_handle_row_insert),
// 			reinterpret_cast<gpointer>(obj));
//      gtk_signal_connect(GTK_OBJECT(obj->CustomWidget()),"remove_row",
// 			GTK_SIGNAL_FUNC(&VDKCustomList::_handle_row_remove),
// 			reinterpret_cast<gpointer>(obj));
}

void
VDKCustomList::_handle_row_move(GtkWidget* wid, int from ,int to,
				gpointer gp)
{
     VDKCustomList* obj=reinterpret_cast<VDKCustomList*>(gp);
     obj->OnRowMove(obj, from, to);
}
/*
void
VDKCustomList::_handle_row_insert(GtkWidget* wid, int row, char** texts,
				  gpointer gp)
{
     VDKCustomList* obj=reinterpret_cast<VDKCustomList*>(gp);
     obj->OnRowInsert(obj, row, (const char**) texts);
}

void
VDKCustomList::_handle_row_remove(GtkWidget* wid, int row, gpointer gp)
{
     VDKCustomList* obj=reinterpret_cast<VDKCustomList*>(gp);
     obj->OnRowRemove(obj, row);
}*/
#endif /* USE_SIGCPLUSPLUS */
