/*
databox Form
implementation file:databox.cc
*/
#include <databox.h>
// Databox FORM  CLASS

/*
form constructor
*/
DataboxForm::DataboxForm(VDKForm* owner, char* title):
	VDKForm(owner,title)
{
}

/*
form destructor
*/
DataboxForm::~DataboxForm()
{
}

/*
form setup
*/
void
DataboxForm::Setup(void)
{
	GUISetup(); // vdkb gui setup
// put your code below here
  int i;
  gfloat off = _lissajousFrequency*4*PI/POINTS;
  gfloat freq = 14+10*sin(_lissajousFrequency);

  for(i=0; i<POINTS; i++){
	_lissajousX[i] = 100.*sin(i*4*PI/POINTS+off);
	_lissajousY[i] = 100.*cos(i*freq*PI/POINTS+off);
  }

  _red = new VDKColor(this, "red");
  _green = new VDKColor(this, "navyblue");

  _databox->NormalBackground = clWhite;

  _databox->AddXY(POINTS, _lissajousX, _lissajousY,
	_green, GTK_DATABOX_POINTS);
  _databox->Rescale();

   _check[0] = new VDKCheckButton( this, "Rulers");
  _check[0]->Checked = (bool) _databox->Rulers;

  _check[1] = new VDKCheckButton( this, "Scrollbars");
  _check[1]->Checked = (bool) _databox->Scrollbars;

  _check[2] = new VDKCheckButton( this, "Cross");
  _check[2]->Checked = (bool) _databox->Cross;

  _check[3] = new VDKCheckButton( this, "Zoom");
  _check[3]->Checked = (bool) _databox->Zoom;

  _check[4] = new VDKCheckButton( this, "Enabled");
  _check[4]->Checked = (bool) _databox->Enabled;
 
  _check[5] = new VDKCheckButton( this, "Change color");

  _check[6] = new VDKCheckButton( this, "Run");
  
  for(i=0; i<CHECKS; i++){
	_check[i]->Tag = i;
	SignalConnect(_check[i],"toggled",&DataboxForm::OnToggle);
	vbox11->Add(_check[i], l_justify, false, false);
  }

}

bool 
DataboxForm::OnMarked(VDKObject *)
{
  GtkDataboxValue c = _databox->GetValue(_databox->Mark);
  printf("marked %.2f x %.2f\n", c.x, c.y);
  fflush(stdout);
  return true;
}

/*
*/
bool 
DataboxForm::OnToggle(VDKObject *obj)
{
  static VDKRgb red("red");
  static VDKRgb green("green");

  switch(obj->Tag)
 {
  case 0:
	_databox->Rulers = (bool)_check[0]->Checked;
	break;
  case 1:
	_databox->Scrollbars = (bool)_check[1]->Checked;
	break;
  case 2:
	_databox->Cross = (bool)_check[2]->Checked;
	break;
  case 3:
	_databox->Zoom = (bool)_check[3]->Checked;
	break;
  case 4:
	_databox->Enabled = (bool)_check[4]->Checked;
	break;
  case 5:
	_databox->SetColor(0, (_check[5]->Checked)?_red:_green);
	break;
  case 6:
	if(_check[6]->Checked)
	{
	  Application()->SetIdleCallback(DataboxForm::OnIdle, this);
	} 
	else
	{
	  Application()->SetIdleCallback(NULL, this);
	}
   default:
	  break;
 }
return true;
}
/*
*/
gint 
DataboxForm::OnIdle(gpointer data)
{
  DataboxForm *form = reinterpret_cast<DataboxForm*>(data);

  int i;
  char text[100];

  form->_lissajousFrequency += 0.001;
  form->_lissajousCounter++;

  gfloat off = form->_lissajousFrequency*4*PI/POINTS;
  gfloat freq = 14+10*sin(form->_lissajousFrequency);

  for(i=0; i<POINTS; i++){
	form->_lissajousX[i] = 100.*sin(i*4*PI/POINTS+off);
	form->_lissajousY[i] = 100.*cos(i*freq*PI/POINTS+off);
  }
  form->_databox->Redraw();
  
  sprintf(text, "%.3f %d\n", 
	form->_lissajousFrequency, form->_lissajousCounter);
  form->_entry->Text = text;

  return 1;
}
// signal response method 
bool
DataboxForm::OnquitButtonClick(VDKObject* sender)
{
Close();
return true;
}
/*
disconnect from idle callback before closing.
*/
bool
DataboxForm::CanClose()
{
if(_check[6]->Checked)
	  Application()->SetIdleCallback(NULL, this);
return true;
}