/*
progress Form
implementation file:progress.cc
*/
#include <progress.h>
// Progress FORM  CLASS
const int maxTime = 20;    
static int timeElapsed = 0;
static char buff[64];

/*
form constructor
*/
ProgressForm::ProgressForm(VDKForm* owner, char* title):
	VDKForm(owner,title)
{
} 

/*
form destructor
*/
ProgressForm::~ProgressForm()
{
}

/*
form setup
*/
void
ProgressForm::Setup(void)
{
	GUISetup(); // vdkb gui setup
    // put your code below here
    timer = new VDKTimer(this,1000,false); // 1 second tick
    timeElapsed = 0;
    // note <false> arg since this signal is internally handled by vdk
    SignalConnect(timer,"timer_tick_signal",&ProgressForm::OnTimer,false);
}

// signal response method 
bool
ProgressForm::OnstartClick(VDKObject* sender)
{
sprintf(buff,"Time elapsed: %.0f - Remaining:%.0f",
	bar->Position(),
	maxTime - bar->Value);
label->Caption = buff;
timer->Start();
return true;
}

/*
this is necessary since we must stop timer before
closing the form, otherwise timer will continue
to send timer tick signal to non-existent widgets
*/
bool 
ProgressForm::CanClose()
{
if(timer->Started())
    timer->Stop();
return true;
}
// signal response method 
bool
ProgressForm::OnstopClick(VDKObject* sender)
{
timer->Stop();
return true;
}

// signal response method 
bool
ProgressForm::OnquitClick(VDKObject* sender)
{
Close();
return true;
}
/*
 */ 
bool
ProgressForm::OnTimer(VDKObject*)
{
timeElapsed++;
bar->Value = double(timeElapsed);
sprintf(buff,"Time elapsed: %.0f - Remaining:%.0f",
	bar->Position(),
	maxTime - bar->Value);
label->Caption = buff;
if(timeElapsed >= maxTime)
  {
    timeElapsed = 0;
    Close();
  }
return true;
}  
// form event response method 
void
ProgressForm::OnShow(VDKForm* sender)
{
quit->Cursor = curHandPtr;
start->Cursor = curHandPtr;
stop->Cursor = curHandPtr;
return ;
}
