/*
 * ===========================
 * VDK Visual Development Kit
 * Version 1.0
 * Revision 7
 * January 2000
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
/*
OVERVIEW
--------
This file has the aim to be a footstep that shows how to make a 
gtk+ widget wrapper in vdk.
We choose here to wrap GtkExText widget.
*/

#ifndef _VDKEXTEXT_H
#define _VDKEXTEXT_H
#include <vdk/vdk.h>
#include <vdkb/gdseditor.h>
/*
new defined signals
put them into vdktypes
as works well
*/

#define move_to_row_signal 2048
#define move_to_column_signal 2049

class VDKExText: public VDKObject
{
    protected:
    // a void constructor to make gtk+ inheritance easier
        VDKExText(VDKForm* owner, GtkWidget* dummy);    
    public:
        VDKExText(VDKForm* owner);
        virtual ~VDKExText();
        virtual int LoadFromFile(char* filename);
        virtual int SaveToFile(char* filename);
        void Clear();
        void TextInsert(char* t, int nchar = -1);
        char* GetChars(int start, int end = -1);
        void Freeze();
        void Thaw();
        void Eol();
        void  BackwardDelete(int nchars);
        void  ForwardDelete(int nchars);
        // text style setting
        // override VDKObject::ones
        virtual void SetBackground(VDKRgb color, 
        			     GtkStateType state = GTK_STATE_NORMAL);
        virtual void SetForeground(VDKRgb color, 
        			     GtkStateType state = GTK_STATE_NORMAL);
        virtual void SetFont(VDKFont* font);
  	bool Undo(void);
    // signal section
    protected:
        virtual void LocalConnect();
        static void ChangedHandler(GtkWidget* wid, gpointer gp);
        static void MoveToRowHandler(GtkWidget* wid,
                            gint row,
                            gpointer gp);
        static void MoveToColumnHandler(GtkWidget* wid,
                            gint row,
                            gpointer gp);
   
    // properties section
    public:
        VDKReadWriteValueProp<VDKExText,bool>        Editable;
        VDKReadWriteValueProp<VDKExText,int>         Pointer;
        VDKReadOnlyValueProp<VDKExText,unsigned int> Length;
        VDKReadWriteValueProp<VDKExText,int>         Column;
        VDKReadWriteValueProp<VDKExText,int>         Line;
	VDKReadWriteValueProp<VDKExText,int>         MaxUndo;
        VDKReadWriteValueProp<VDKExText,bool>        ShowLineNumbers;
        VDKReadWriteValueProp<VDKExText,bool>        LineAutoSelect;
        bool Changed;
    // and setting/getting functions
    protected:
        void SetPointer(int pos);
        int GetPointer();
        void SetColumn(int col);
        int GetColumn();
        void SetLine(int line);
        int  GetLine(void);
        void SetEditable(bool flag);
        bool GetEditable(void);
        unsigned int GetLength();
	void SetMaxUndo(int m);
	void SetShowLineNumbers(bool flag);
	void SetLineAutoSelect(bool flag);
};
#endif  
