/*
 * ============
 * VDK Builder
 * Version 1.2
 * Revision 4
 * October 2000
 * ============
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library 
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#if !HAVE_GNOME
#if ENABLE_NLS
#include <libintl.h>
#define _(str) gettext(str)
#define N_(str) str
#else
#define _(str) str
#define N_(str) str 
#endif
#endif
#include <vdkb/vdkb_lru.h>
#include <vdkb/vdkb.h>
#define MAX_LRU 10
extern VDKBuilder* TheApp;
extern char* BugFix01(const char* where);
static char buff[256];
#define LRUFILE ".vdkb/res/lruprojects"

LRUManager::LRUManager()
{
}

LRUManager::~LRUManager()
{
  Save();
}
/*
initializes LRU projects stuff
loadin itemlist with lru project names
*/
void
LRUManager::Init()
{
  struct stat info;
  char* file;
  FILE* fp;
  // look at user home
  sprintf(buff,"%s/%s",(char*) TheApp->user_home,LRUFILE);
  file = buff;
  // no lru projects here
  if(stat(file,&info) == -1)
    return;
  else if (! Load(buff))
      TheApp->MessageBox(APPNAME,
			 _("Failed to load lru projects file"),
			 MB_ICONINFORMATION|MB_OK,
			 _(user_messages[user_ok]),
			 NULL,
			 4000
			 );
  return;
		  
}
/*
  load item list reading lru file
 */
bool 
LRUManager::Load(const char* fn)
{
  FILE* fp = fopen(fn,"r");
  if(!fp)
    return false;
  else
    {
      itemlist.flush();
      while(fgets(buff,sizeof(buff),fp) != NULL)
	{
	  buff[strlen(buff)-1] = 
	    buff[strlen(buff)-1] == '\n' ? 
	    '\0':
	    buff[strlen(buff)-1];
	  itemlist.add(LRUItem(buff));
	}
      fclose(fp);
      return true;
    }
}

bool 
LRUManager::Save()
{
  char* file;
  FILE* fp;
  // look at user home
  sprintf(buff,"%s/%s",(char*) TheApp->user_home,LRUFILE);
  file = buff;
  fp = fopen(file,"w+");
  if(!fp)
    return false;
  // scans list and save items
  LRUItemsIterator li(itemlist);
  for(;li;li++)
    {
      // retrieves project name from list item
      const char* prompt = li.current().Name();
      fputs(prompt,fp);
      fputc('\n',fp);
    }
  fclose(fp);
  return true;
}
/*
update lru list
*/
bool
LRUManager::Update(char* prj)
{
  char* local = NULL;
  if(!prj)
    return false;
  else
    {
      // ugly patch to remove double "//"
      // inserted by old buggy projects wizard
      char* rep = NULL;
      local = new char[strlen(prj)+1];
      strcpy(local,prj);
      rep = BugFix01(local);
      if(rep)
	{
	  strcpy(local,rep);
	  delete rep;
	}
    }
  LRUItem item(local);
  bool have_room = itemlist.size() < MAX_LRU;
  bool found = itemlist.find(item) != NULL;
  // project isn't into list
  if(!found)
    {
      // there is enough space
      if(have_room)
	// push item into list
	itemlist.push(item);
      else
	{
	  // remove less recently used
	  itemlist.unlink(itemlist.size()-1);
	  // push item
	  itemlist.push(item);
	}
    }
  // project is already into list
  else
    {
      // find ordinal position
      int ndx = itemlist.at(item);
      if(ndx >= 0)
	{
	  // unlink it
	  itemlist.unlink(ndx);
	  // push
	  itemlist.push(item);
	}
    }
  if(local)
    delete[] local;
  return true;
}




