/*
 * ===========================
 * VDK Visual Development Kit
 * xdb subsystem
 * Version 0.1
 * Revision 0.0
 * April 2000
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include <vdkxdb/vdkxentry.h>
#include <vdk/vdkdate.h>

VDKXEntry::VDKXEntry(VDKForm* owner, int maxLen , char* def): 
  VDKEntry(owner,maxLen,def), VDKXControl()
{
}

bool 
VDKXEntry::AssignTableField(VDKXTable* t,
			    char* fname)
{
  if(t)
    {
      xbShort id = t->GetFieldNo(fname);
      xbShort type = t->GetFieldType(id);
      if((type != 'M') && (type != 'L') )
	return VDKXControl::AssignTableField(t, fname);
      else
	return false;
    }
  else
    return false;
}
/*
 */
xbShort
VDKXEntry::Read()
{
  xbShort l, rc = XB_NOT_OPEN; 
  char* buffer = NULL;
  if(table)
    {
      calendardate d;
      l = table->GetFieldLen(field_id);
      buffer = new char[l+1];
      rc = table->GetField(field_id,buffer);
      if(rc)
	{
	  switch(field_type)
	    {
	    case 'D':
	      d = MakeDate(buffer);
	      Text = (char*) d;
	      break;

	    case 'N':
	    case 'F':
	      Text = table->xbase->LTRIM(buffer);
	      break;

	    default:
	      Text = table->xbase->RTRIM(buffer);
	      break;
	      
	    }
	}
      if(buffer)
	delete[] buffer;
    }
  return XB_NO_ERROR;
}
/*
 */
xbShort
VDKXEntry::Write()
{
  calendardate d;
  xbShort rc = XB_NOT_OPEN, l;
  char* buffer = NULL;
  if(table)
    {
      l = table->GetFieldLen(field_id);
      switch(field_type)
	{
	case 'D':
	  d = calendardate(Text);
	  if (d.Valid())
	    rc = table->PutField(field_id,d.AsString());
	  break;

	case 'N':
	case 'F':
	  buffer = new char[l+1];
	  strcpy(buffer,(char*) Text);
	  rc = table->PutField(field_id,table->xbase->LTRIM(buffer));
	  break;

	default:
	  rc = table->PutField(field_id,(char*) Text);
	}
      if(buffer)
	delete[] buffer;
    }
  return rc;
}










