/*
testxdb Plain VDK Application 
Main unit implementation file:testxdb.cc
Mario Motta
*/ 
#include <testxdb.h>
// database files
#define DBFNAME "./myfamily.dbf"
#define NDX1    "./name.ndx"
#define NDX2    "./birthday.ndx"
// record structure 
    
VDKXRecordTemplate MyFamily[] = 
{
  { "FIRSTNAME", XB_CHAR_FLD,     15, 0 }, 
  { "LASTNAME",  XB_CHAR_FLD,     15, 0 },
  { "BIRTHDATE", XB_DATE_FLD,      8, 0 },
  { "SEX",       XB_CHAR_FLD,      1, 0 }, // either M(ale) or F(emale)
  { "HOWMANY",   XB_NUMERIC_FLD,   3, 0 }, // how many days to birthday
  { "OFAGE",     XB_LOGICAL_FLD,   1, 0 }, // older than 18 or not
  /*
  above fields are here just to show numeric and logic types,
  fields that can be calculated with database data should not stay here however 
  */
  { "MEMO",      XB_MEMO_FLD,     10, 0 }, // a memo field
  { "",0,0,0 }
};
 // a static buffer
static char buff[256];
/*
main program
*/
int main (int argc, char *argv[])
{
  // makes application
  TestxdbApp app(&argc, argv);
  // runs application
  app.Run();
  return 0;
}
       
// Testxdb MAIN FORM  CLASS
/*
    main form constructor
*/
TestxdbForm::TestxdbForm(VDKApplication* app, char* title):
	VDKForm(app,title)
{
  // get table pointer
  TestxdbApp* theApp = dynamic_cast<TestxdbApp*>(app);
  table = theApp ? (*theApp->TheXdb())[DBFNAME] : NULL;
}
  
/*
main form destructor
*/
TestxdbForm::~TestxdbForm()
{

}

/*
main form setup
*/
void
TestxdbForm::Setup(void)
{
  GUISetup();
  // adds controls to control list
  cList.add(firstname);
  cList.add(lastname);
  cList.add(birthdate);
  cList.add(sex);
  cList.add(ofage);
  cList.add(memo);
  cList.add(fieldList);
  Read();
}

// Testxdb APPLICATION  CLASS
/*
application constructor
*/
TestxdbApp::TestxdbApp(int* argc, char** argv):
	VDKApplication(argc,argv)
{
#ifdef VDKXDB_SUPPORT
  xdb = new VDKXDatabase;
#endif      
}

/*
application destructor
*/
TestxdbApp::~TestxdbApp()
{ 
#ifdef VDKXDB_SUPPORT

  if(xdb) 
  {
    delete xdb; 
  }
#endif
}

/*
application setup
*/
void
TestxdbApp::SetupDatabase(void)
{
  // temporary creates tables and indices
  VDKXTable* table = new VDKXTable(xdb,DBFNAME);
  xbShort rc;
  VDKXTableIndex* index;
  rc = table->Create(MyFamily);
  if(rc != XB_NO_ERROR)
    table->Open();
  index = new VDKXTableIndex(table,NDX1); 
  index->Create("FIRSTNAME-LASTNAME");
  index = new VDKXTableIndex(table,NDX2); 
  index->Create("BIRTHDATE");
  table->Close();
  xdb->RemoveTable(DBFNAME);
}
/*
*/

void
TestxdbApp::Setup(void)
{
  SetupDatabase();
#ifdef VDKXDB_SUPPORT
  XDBSetup();
#endif
  MainForm = new TestxdbForm(this,NULL);
  MainForm->Setup();
  MainForm->Visible = true;
}

/*
*/
void
TestxdbForm::EnableControls(bool flag) 
{
  ControlListIterator li(cList);
  for(;li;li++)
  {
    VDKObject* obj = dynamic_cast<VDKObject*>(li.current());
    if(obj && obj != fieldList)
      obj->Enabled = flag;    
  }
}
/*
reads from record buffer into controls
*/
void
TestxdbForm::Read() 
{
  if(!table)
    return;
  ControlListIterator li(cList);
  for(;li;li++)
  {
    // reading a list better be explicit
    // since is a O(n) operation
    if(li.current() != fieldList)
        li.current()->Read();    
  }
  delButton->Enabled = table->RecordDeleted() ? false : true;
  undelButton->Enabled = table->RecordDeleted() ? true : false;
  EnableControls(!table->RecordDeleted()); 
}
/*
    writes from controls to record buffer
*/
void
TestxdbForm::Write()
{
  ControlListIterator li(cList);
  for(;li;li++)
    li.current()->Write();    
}
// do not remove this mark: #!#
//signal response method
bool
TestxdbForm::OnfieldListSelectRow(VDKObject* sender)
{
  VDKString firstname,lastname,birthdate,key;
  Tuple tuple;
  int ndx = fieldList->Selected.Row();
  // get table
  if( (ndx < 0) || (! table))
        return true;
  // get selected tuple 
  tuple =  fieldList->Tuples[ndx];
  // load keys from tuple pending on index order
  if(table->Order == 1)
  {
    firstname = tuple[0];
    lastname = tuple[1];                
  }
  else if(table->Order == 0)
    birthdate = tuple[2];
  // make key
  if(!firstname.isNull())
    key = firstname+lastname;
  else if(!birthdate.isNull())
  {
    calendardate d = (char*) birthdate;
    key = d.AsString();
  }
  // find key
  if(!key.isNull())
  {
    VDKXTableIndex* index = table->Index(table->Order);
    if(index)
    {
      xbShort rc = index->FindKey((char*) key);
      if(rc == XB_FOUND)
        Read();
      sprintf(buff,"FindKey:%s-%s",(char*) key,VDKXError(rc));
      statusbar->Push(buff); 
    }
  }
  return true;
}

//signal response method
bool
TestxdbForm::OnorderButtonClick(VDKObject* sender)
{
   if(!table)
        return true;
    table->Order = table->Order == 0 ? 1 : 0;
    Read();
    fieldList->Read();
    VDKXTableIndex* index = table->Index(table->Order);
    if(index)
    {
        sprintf(buff,"Index order on: - %s",(char*) index->Key());
        statusbar->Push(buff);
    }
  return true;
}

//signal response method
bool
TestxdbForm::OnaddButtonClick(VDKObject* sender)
{
  xbShort rc;
  if(!table)
    return true;
  table->BlankRecord();
  Write();
  rc = table->AppendRecord();
  sprintf(buff,"Adding a record - %s",VDKXError(rc));
  statusbar->Push(buff);
  fieldList->Read();
  return true;
}

//signal response method
bool
TestxdbForm::OndelButtonClick(VDKObject* sender)
{
  xbShort rc;
  if(!table)
    return true;
  table->ExclusiveLock( F_SETLKW ); /* lock the files for our exclusive use */
  rc = table->DeleteRecord();
  sprintf(buff,"Deleting record - %s",VDKXError(rc));
  statusbar->Push(buff);  
  Read();
  fieldList->Read();
  return true;
}

//signal response method
bool
TestxdbForm::OnundelButtonClick(VDKObject* sender)
{
    if(!table)
        return true;
    xbShort rc = table->UndeleteRecord();
    sprintf(buff,"Undeleting record - %s",VDKXError(rc));
    statusbar->Push(buff);            
    Read();
    fieldList->Read();
    return true;
}

//signal response method
bool
TestxdbForm::OnupdateButtonClick(VDKObject* sender)
{
  xbShort rc;
  if(!table)
    return true;
  Write();
  rc = table->PutRecord();
  sprintf(buff,"Updating record - %s",VDKXError(rc));
  statusbar->Push(buff);
  return true;
}

//signal response method
bool
TestxdbForm::OnshowdelButtonClick(VDKObject* sender)
{
  if(!table)
    return true;
  if(table->ShowDeleted)
    table->ShowDeleted = false;
  else
    table->ShowDeleted = true;
  Read();
  fieldList->Read();
  return true;
}

//signal response method
bool
TestxdbForm::OnlastButtonClick(VDKObject* sender)
{
  xbShort rc;
   if(!table)
        return true;
   rc = sender == firstButton ? table->First() : table->Last();
   if(rc == XB_NO_ERROR)
     Read();
   sprintf(buff,"%s - %s", sender == firstButton ? "First:" : "Last:", VDKXError(rc) );
   statusbar->Push(buff);    
   return true;
}

//signal response method
bool
TestxdbForm::OnnextButtonClick(VDKObject* sender)
{
   xbShort rc;
   if(!table)
        return true;
   rc = sender == nextButton ? table->Next() : table->Prev();
   if(rc == XB_NO_ERROR)
     Read();
   sprintf(buff,"%s - %s", sender == nextButton ? "Next:" : "Prev:", VDKXError(rc) );
   statusbar->Push(buff);    
   return true;
}

//signal response method
/*
some widget must be realized before accept
updating operations
*/
bool
TestxdbForm::OnmemoRealize(VDKObject* sender)
{
    memo->Read();
    return true;
}

//signal response method
bool
TestxdbForm::OnfieldListRealize(VDKObject* sender)
{
    fieldList->Read();
    return true;
}

//signal response method
bool
TestxdbForm::OnquitButtonClick(VDKObject* sender)
{
    Close();
    return true;
}

// end of file:testxdb.cc




