#include "util.h"

#include <gtk/gtkwindow.h>

using namespace std;


string
initDictPointers()
{
    extern verbiste::FrenchVerbDictionary *frenchDict, *italianDict;

    try
    {
        // Initialize global dictionary pointers.
        string conjFN, verbsFN;
        verbiste::FrenchVerbDictionary::getXMLFilenames(conjFN, verbsFN, "fr");
        //cout << "fr: '" << conjFN << "', '" << verbsFN << "'\n";
        frenchDict = new verbiste::FrenchVerbDictionary(conjFN, verbsFN, true, "fr");  // may throw

        verbiste::FrenchVerbDictionary::getXMLFilenames(conjFN, verbsFN, "it");
        //cout << "it: '" << conjFN << "', '" << verbsFN << "'\n";
        italianDict = new verbiste::FrenchVerbDictionary(conjFN, verbsFN, true, "it");  // may throw
        return string();  // success
    }
    catch(logic_error &e)
    {
        delete italianDict;
        italianDict = NULL;
        delete frenchDict;
        frenchDict = NULL;
        return e.what();
    }
}


void
set_window_icon_to_default(GtkWidget *window)
{
    GdkPixbuf *icon = gdk_pixbuf_new_from_file(
                                PIXMAPDIR "/" PACKAGE ".png", NULL);
    if (icon == NULL)
        g_warning("gdk_pixbuf_new_from_file() failed on "
                                PIXMAPDIR "/" PACKAGE ".png");
    else
        gtk_window_set_icon(GTK_WINDOW(window), icon);
}
